// Decky Loader will pass this api in, it's versioned to allow for backwards compatibility.
// @ts-ignore

// Prevents it from being duplicated in output.
const manifest = {"name":"MagicPods","author":"Aleksandr Maslov & Andrey Litvintsev","flags":[],"api_version":1,"publish":{"tags":["bluetooth","battery","airpods","beats","headphones"],"description":"Monitor the battery level of your AirPods, Beats and Galaxy Buds. Easily switch between noise cancellation modes and enjoy the magic.","image":"https://raw.githubusercontent.com/steam3d/MagicPodsDecky/master/docs/images/preview.png"}};
const API_VERSION = 2;
const internalAPIConnection = window.__DECKY_SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED_deckyLoaderAPIInit;
// Initialize
if (!internalAPIConnection) {
    throw new Error('[@decky/api]: Failed to connect to the loader as as the loader API was not initialized. This is likely a bug in Decky Loader.');
}
// Version 1 throws on version mismatch so we have to account for that here.
let api;
try {
    api = internalAPIConnection.connect(API_VERSION, manifest.name);
}
catch {
    api = internalAPIConnection.connect(1, manifest.name);
    console.warn(`[@decky/api] Requested API version ${API_VERSION} but the running loader only supports version 1. Some features may not work.`);
}
if (api._version != API_VERSION) {
    console.warn(`[@decky/api] Requested API version ${API_VERSION} but the running loader only supports version ${api._version}. Some features may not work.`);
}
// TODO these could use a lot of JSDoc
const call = api.call;
const routerHook = api.routerHook;
const toaster = api.toaster;

const isString$1 = obj => typeof obj === 'string';
const defer = () => {
  let res;
  let rej;
  const promise = new Promise((resolve, reject) => {
    res = resolve;
    rej = reject;
  });
  promise.resolve = res;
  promise.reject = rej;
  return promise;
};
const makeString = object => {
  if (object == null) return '';
  return '' + object;
};
const copy = (a, s, t) => {
  a.forEach(m => {
    if (s[m]) t[m] = s[m];
  });
};
const lastOfPathSeparatorRegExp = /###/g;
const cleanKey = key => key && key.indexOf('###') > -1 ? key.replace(lastOfPathSeparatorRegExp, '.') : key;
const canNotTraverseDeeper = object => !object || isString$1(object);
const getLastOfPath = (object, path, Empty) => {
  const stack = !isString$1(path) ? path : path.split('.');
  let stackIndex = 0;
  while (stackIndex < stack.length - 1) {
    if (canNotTraverseDeeper(object)) return {};
    const key = cleanKey(stack[stackIndex]);
    if (!object[key] && Empty) object[key] = new Empty();
    if (Object.prototype.hasOwnProperty.call(object, key)) {
      object = object[key];
    } else {
      object = {};
    }
    ++stackIndex;
  }
  if (canNotTraverseDeeper(object)) return {};
  return {
    obj: object,
    k: cleanKey(stack[stackIndex])
  };
};
const setPath = (object, path, newValue) => {
  const {
    obj,
    k
  } = getLastOfPath(object, path, Object);
  if (obj !== undefined || path.length === 1) {
    obj[k] = newValue;
    return;
  }
  let e = path[path.length - 1];
  let p = path.slice(0, path.length - 1);
  let last = getLastOfPath(object, p, Object);
  while (last.obj === undefined && p.length) {
    e = `${p[p.length - 1]}.${e}`;
    p = p.slice(0, p.length - 1);
    last = getLastOfPath(object, p, Object);
    if (last && last.obj && typeof last.obj[`${last.k}.${e}`] !== 'undefined') {
      last.obj = undefined;
    }
  }
  last.obj[`${last.k}.${e}`] = newValue;
};
const pushPath = (object, path, newValue, concat) => {
  const {
    obj,
    k
  } = getLastOfPath(object, path, Object);
  obj[k] = obj[k] || [];
  obj[k].push(newValue);
};
const getPath = (object, path) => {
  const {
    obj,
    k
  } = getLastOfPath(object, path);
  if (!obj) return undefined;
  return obj[k];
};
const getPathWithDefaults = (data, defaultData, key) => {
  const value = getPath(data, key);
  if (value !== undefined) {
    return value;
  }
  return getPath(defaultData, key);
};
const deepExtend = (target, source, overwrite) => {
  for (const prop in source) {
    if (prop !== '__proto__' && prop !== 'constructor') {
      if (prop in target) {
        if (isString$1(target[prop]) || target[prop] instanceof String || isString$1(source[prop]) || source[prop] instanceof String) {
          if (overwrite) target[prop] = source[prop];
        } else {
          deepExtend(target[prop], source[prop], overwrite);
        }
      } else {
        target[prop] = source[prop];
      }
    }
  }
  return target;
};
const regexEscape = str => str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
var _entityMap = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&quot;',
  "'": '&#39;',
  '/': '&#x2F;'
};
const escape = data => {
  if (isString$1(data)) {
    return data.replace(/[&<>"'\/]/g, s => _entityMap[s]);
  }
  return data;
};
class RegExpCache {
  constructor(capacity) {
    this.capacity = capacity;
    this.regExpMap = new Map();
    this.regExpQueue = [];
  }
  getRegExp(pattern) {
    const regExpFromCache = this.regExpMap.get(pattern);
    if (regExpFromCache !== undefined) {
      return regExpFromCache;
    }
    const regExpNew = new RegExp(pattern);
    if (this.regExpQueue.length === this.capacity) {
      this.regExpMap.delete(this.regExpQueue.shift());
    }
    this.regExpMap.set(pattern, regExpNew);
    this.regExpQueue.push(pattern);
    return regExpNew;
  }
}
const chars = [' ', ',', '?', '!', ';'];
const looksLikeObjectPathRegExpCache = new RegExpCache(20);
const looksLikeObjectPath = (key, nsSeparator, keySeparator) => {
  nsSeparator = nsSeparator || '';
  keySeparator = keySeparator || '';
  const possibleChars = chars.filter(c => nsSeparator.indexOf(c) < 0 && keySeparator.indexOf(c) < 0);
  if (possibleChars.length === 0) return true;
  const r = looksLikeObjectPathRegExpCache.getRegExp(`(${possibleChars.map(c => c === '?' ? '\\?' : c).join('|')})`);
  let matched = !r.test(key);
  if (!matched) {
    const ki = key.indexOf(keySeparator);
    if (ki > 0 && !r.test(key.substring(0, ki))) {
      matched = true;
    }
  }
  return matched;
};
const deepFind = function (obj, path) {
  let keySeparator = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '.';
  if (!obj) return undefined;
  if (obj[path]) return obj[path];
  const tokens = path.split(keySeparator);
  let current = obj;
  for (let i = 0; i < tokens.length;) {
    if (!current || typeof current !== 'object') {
      return undefined;
    }
    let next;
    let nextPath = '';
    for (let j = i; j < tokens.length; ++j) {
      if (j !== i) {
        nextPath += keySeparator;
      }
      nextPath += tokens[j];
      next = current[nextPath];
      if (next !== undefined) {
        if (['string', 'number', 'boolean'].indexOf(typeof next) > -1 && j < tokens.length - 1) {
          continue;
        }
        i += j - i + 1;
        break;
      }
    }
    current = next;
  }
  return current;
};
const getCleanedCode = code => code && code.replace('_', '-');

const consoleLogger = {
  type: 'logger',
  log(args) {
    this.output('log', args);
  },
  warn(args) {
    this.output('warn', args);
  },
  error(args) {
    this.output('error', args);
  },
  output(type, args) {
    if (console && console[type]) console[type].apply(console, args);
  }
};
class Logger {
  constructor(concreteLogger) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    this.init(concreteLogger, options);
  }
  init(concreteLogger) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    this.prefix = options.prefix || 'i18next:';
    this.logger = concreteLogger || consoleLogger;
    this.options = options;
    this.debug = options.debug;
  }
  log() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return this.forward(args, 'log', '', true);
  }
  warn() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    return this.forward(args, 'warn', '', true);
  }
  error() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }
    return this.forward(args, 'error', '');
  }
  deprecate() {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }
    return this.forward(args, 'warn', 'WARNING DEPRECATED: ', true);
  }
  forward(args, lvl, prefix, debugOnly) {
    if (debugOnly && !this.debug) return null;
    if (isString$1(args[0])) args[0] = `${prefix}${this.prefix} ${args[0]}`;
    return this.logger[lvl](args);
  }
  create(moduleName) {
    return new Logger(this.logger, {
      ...{
        prefix: `${this.prefix}:${moduleName}:`
      },
      ...this.options
    });
  }
  clone(options) {
    options = options || this.options;
    options.prefix = options.prefix || this.prefix;
    return new Logger(this.logger, options);
  }
}
var baseLogger = new Logger();

class EventEmitter {
  constructor() {
    this.observers = {};
  }
  on(events, listener) {
    events.split(' ').forEach(event => {
      if (!this.observers[event]) this.observers[event] = new Map();
      const numListeners = this.observers[event].get(listener) || 0;
      this.observers[event].set(listener, numListeners + 1);
    });
    return this;
  }
  off(event, listener) {
    if (!this.observers[event]) return;
    if (!listener) {
      delete this.observers[event];
      return;
    }
    this.observers[event].delete(listener);
  }
  emit(event) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    if (this.observers[event]) {
      const cloned = Array.from(this.observers[event].entries());
      cloned.forEach(_ref => {
        let [observer, numTimesAdded] = _ref;
        for (let i = 0; i < numTimesAdded; i++) {
          observer(...args);
        }
      });
    }
    if (this.observers['*']) {
      const cloned = Array.from(this.observers['*'].entries());
      cloned.forEach(_ref2 => {
        let [observer, numTimesAdded] = _ref2;
        for (let i = 0; i < numTimesAdded; i++) {
          observer.apply(observer, [event, ...args]);
        }
      });
    }
  }
}

class ResourceStore extends EventEmitter {
  constructor(data) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      ns: ['translation'],
      defaultNS: 'translation'
    };
    super();
    this.data = data || {};
    this.options = options;
    if (this.options.keySeparator === undefined) {
      this.options.keySeparator = '.';
    }
    if (this.options.ignoreJSONStructure === undefined) {
      this.options.ignoreJSONStructure = true;
    }
  }
  addNamespaces(ns) {
    if (this.options.ns.indexOf(ns) < 0) {
      this.options.ns.push(ns);
    }
  }
  removeNamespaces(ns) {
    const index = this.options.ns.indexOf(ns);
    if (index > -1) {
      this.options.ns.splice(index, 1);
    }
  }
  getResource(lng, ns, key) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    const keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
    const ignoreJSONStructure = options.ignoreJSONStructure !== undefined ? options.ignoreJSONStructure : this.options.ignoreJSONStructure;
    let path;
    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
    } else {
      path = [lng, ns];
      if (key) {
        if (Array.isArray(key)) {
          path.push(...key);
        } else if (isString$1(key) && keySeparator) {
          path.push(...key.split(keySeparator));
        } else {
          path.push(key);
        }
      }
    }
    const result = getPath(this.data, path);
    if (!result && !ns && !key && lng.indexOf('.') > -1) {
      lng = path[0];
      ns = path[1];
      key = path.slice(2).join('.');
    }
    if (result || !ignoreJSONStructure || !isString$1(key)) return result;
    return deepFind(this.data && this.data[lng] && this.data[lng][ns], key, keySeparator);
  }
  addResource(lng, ns, key, value) {
    let options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
      silent: false
    };
    const keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
    let path = [lng, ns];
    if (key) path = path.concat(keySeparator ? key.split(keySeparator) : key);
    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
      value = ns;
      ns = path[1];
    }
    this.addNamespaces(ns);
    setPath(this.data, path, value);
    if (!options.silent) this.emit('added', lng, ns, key, value);
  }
  addResources(lng, ns, resources) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
      silent: false
    };
    for (const m in resources) {
      if (isString$1(resources[m]) || Array.isArray(resources[m])) this.addResource(lng, ns, m, resources[m], {
        silent: true
      });
    }
    if (!options.silent) this.emit('added', lng, ns, resources);
  }
  addResourceBundle(lng, ns, resources, deep, overwrite) {
    let options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {
      silent: false,
      skipCopy: false
    };
    let path = [lng, ns];
    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
      deep = resources;
      resources = ns;
      ns = path[1];
    }
    this.addNamespaces(ns);
    let pack = getPath(this.data, path) || {};
    if (!options.skipCopy) resources = JSON.parse(JSON.stringify(resources));
    if (deep) {
      deepExtend(pack, resources, overwrite);
    } else {
      pack = {
        ...pack,
        ...resources
      };
    }
    setPath(this.data, path, pack);
    if (!options.silent) this.emit('added', lng, ns, resources);
  }
  removeResourceBundle(lng, ns) {
    if (this.hasResourceBundle(lng, ns)) {
      delete this.data[lng][ns];
    }
    this.removeNamespaces(ns);
    this.emit('removed', lng, ns);
  }
  hasResourceBundle(lng, ns) {
    return this.getResource(lng, ns) !== undefined;
  }
  getResourceBundle(lng, ns) {
    if (!ns) ns = this.options.defaultNS;
    if (this.options.compatibilityAPI === 'v1') return {
      ...{},
      ...this.getResource(lng, ns)
    };
    return this.getResource(lng, ns);
  }
  getDataByLanguage(lng) {
    return this.data[lng];
  }
  hasLanguageSomeTranslations(lng) {
    const data = this.getDataByLanguage(lng);
    const n = data && Object.keys(data) || [];
    return !!n.find(v => data[v] && Object.keys(data[v]).length > 0);
  }
  toJSON() {
    return this.data;
  }
}

var postProcessor = {
  processors: {},
  addPostProcessor(module) {
    this.processors[module.name] = module;
  },
  handle(processors, value, key, options, translator) {
    processors.forEach(processor => {
      if (this.processors[processor]) value = this.processors[processor].process(value, key, options, translator);
    });
    return value;
  }
};

const checkedLoadedFor = {};
class Translator extends EventEmitter {
  constructor(services) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    super();
    copy(['resourceStore', 'languageUtils', 'pluralResolver', 'interpolator', 'backendConnector', 'i18nFormat', 'utils'], services, this);
    this.options = options;
    if (this.options.keySeparator === undefined) {
      this.options.keySeparator = '.';
    }
    this.logger = baseLogger.create('translator');
  }
  changeLanguage(lng) {
    if (lng) this.language = lng;
  }
  exists(key) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      interpolation: {}
    };
    if (key === undefined || key === null) {
      return false;
    }
    const resolved = this.resolve(key, options);
    return resolved && resolved.res !== undefined;
  }
  extractFromKey(key, options) {
    let nsSeparator = options.nsSeparator !== undefined ? options.nsSeparator : this.options.nsSeparator;
    if (nsSeparator === undefined) nsSeparator = ':';
    const keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
    let namespaces = options.ns || this.options.defaultNS || [];
    const wouldCheckForNsInKey = nsSeparator && key.indexOf(nsSeparator) > -1;
    const seemsNaturalLanguage = !this.options.userDefinedKeySeparator && !options.keySeparator && !this.options.userDefinedNsSeparator && !options.nsSeparator && !looksLikeObjectPath(key, nsSeparator, keySeparator);
    if (wouldCheckForNsInKey && !seemsNaturalLanguage) {
      const m = key.match(this.interpolator.nestingRegexp);
      if (m && m.length > 0) {
        return {
          key,
          namespaces: isString$1(namespaces) ? [namespaces] : namespaces
        };
      }
      const parts = key.split(nsSeparator);
      if (nsSeparator !== keySeparator || nsSeparator === keySeparator && this.options.ns.indexOf(parts[0]) > -1) namespaces = parts.shift();
      key = parts.join(keySeparator);
    }
    return {
      key,
      namespaces: isString$1(namespaces) ? [namespaces] : namespaces
    };
  }
  translate(keys, options, lastKey) {
    if (typeof options !== 'object' && this.options.overloadTranslationOptionHandler) {
      options = this.options.overloadTranslationOptionHandler(arguments);
    }
    if (typeof options === 'object') options = {
      ...options
    };
    if (!options) options = {};
    if (keys === undefined || keys === null) return '';
    if (!Array.isArray(keys)) keys = [String(keys)];
    const returnDetails = options.returnDetails !== undefined ? options.returnDetails : this.options.returnDetails;
    const keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
    const {
      key,
      namespaces
    } = this.extractFromKey(keys[keys.length - 1], options);
    const namespace = namespaces[namespaces.length - 1];
    const lng = options.lng || this.language;
    const appendNamespaceToCIMode = options.appendNamespaceToCIMode || this.options.appendNamespaceToCIMode;
    if (lng && lng.toLowerCase() === 'cimode') {
      if (appendNamespaceToCIMode) {
        const nsSeparator = options.nsSeparator || this.options.nsSeparator;
        if (returnDetails) {
          return {
            res: `${namespace}${nsSeparator}${key}`,
            usedKey: key,
            exactUsedKey: key,
            usedLng: lng,
            usedNS: namespace,
            usedParams: this.getUsedParamsDetails(options)
          };
        }
        return `${namespace}${nsSeparator}${key}`;
      }
      if (returnDetails) {
        return {
          res: key,
          usedKey: key,
          exactUsedKey: key,
          usedLng: lng,
          usedNS: namespace,
          usedParams: this.getUsedParamsDetails(options)
        };
      }
      return key;
    }
    const resolved = this.resolve(keys, options);
    let res = resolved && resolved.res;
    const resUsedKey = resolved && resolved.usedKey || key;
    const resExactUsedKey = resolved && resolved.exactUsedKey || key;
    const resType = Object.prototype.toString.apply(res);
    const noObject = ['[object Number]', '[object Function]', '[object RegExp]'];
    const joinArrays = options.joinArrays !== undefined ? options.joinArrays : this.options.joinArrays;
    const handleAsObjectInI18nFormat = !this.i18nFormat || this.i18nFormat.handleAsObject;
    const handleAsObject = !isString$1(res) && typeof res !== 'boolean' && typeof res !== 'number';
    if (handleAsObjectInI18nFormat && res && handleAsObject && noObject.indexOf(resType) < 0 && !(isString$1(joinArrays) && Array.isArray(res))) {
      if (!options.returnObjects && !this.options.returnObjects) {
        if (!this.options.returnedObjectHandler) {
          this.logger.warn('accessing an object - but returnObjects options is not enabled!');
        }
        const r = this.options.returnedObjectHandler ? this.options.returnedObjectHandler(resUsedKey, res, {
          ...options,
          ns: namespaces
        }) : `key '${key} (${this.language})' returned an object instead of string.`;
        if (returnDetails) {
          resolved.res = r;
          resolved.usedParams = this.getUsedParamsDetails(options);
          return resolved;
        }
        return r;
      }
      if (keySeparator) {
        const resTypeIsArray = Array.isArray(res);
        const copy = resTypeIsArray ? [] : {};
        const newKeyToUse = resTypeIsArray ? resExactUsedKey : resUsedKey;
        for (const m in res) {
          if (Object.prototype.hasOwnProperty.call(res, m)) {
            const deepKey = `${newKeyToUse}${keySeparator}${m}`;
            copy[m] = this.translate(deepKey, {
              ...options,
              ...{
                joinArrays: false,
                ns: namespaces
              }
            });
            if (copy[m] === deepKey) copy[m] = res[m];
          }
        }
        res = copy;
      }
    } else if (handleAsObjectInI18nFormat && isString$1(joinArrays) && Array.isArray(res)) {
      res = res.join(joinArrays);
      if (res) res = this.extendTranslation(res, keys, options, lastKey);
    } else {
      let usedDefault = false;
      let usedKey = false;
      const needsPluralHandling = options.count !== undefined && !isString$1(options.count);
      const hasDefaultValue = Translator.hasDefaultValue(options);
      const defaultValueSuffix = needsPluralHandling ? this.pluralResolver.getSuffix(lng, options.count, options) : '';
      const defaultValueSuffixOrdinalFallback = options.ordinal && needsPluralHandling ? this.pluralResolver.getSuffix(lng, options.count, {
        ordinal: false
      }) : '';
      const needsZeroSuffixLookup = needsPluralHandling && !options.ordinal && options.count === 0 && this.pluralResolver.shouldUseIntlApi();
      const defaultValue = needsZeroSuffixLookup && options[`defaultValue${this.options.pluralSeparator}zero`] || options[`defaultValue${defaultValueSuffix}`] || options[`defaultValue${defaultValueSuffixOrdinalFallback}`] || options.defaultValue;
      if (!this.isValidLookup(res) && hasDefaultValue) {
        usedDefault = true;
        res = defaultValue;
      }
      if (!this.isValidLookup(res)) {
        usedKey = true;
        res = key;
      }
      const missingKeyNoValueFallbackToKey = options.missingKeyNoValueFallbackToKey || this.options.missingKeyNoValueFallbackToKey;
      const resForMissing = missingKeyNoValueFallbackToKey && usedKey ? undefined : res;
      const updateMissing = hasDefaultValue && defaultValue !== res && this.options.updateMissing;
      if (usedKey || usedDefault || updateMissing) {
        this.logger.log(updateMissing ? 'updateKey' : 'missingKey', lng, namespace, key, updateMissing ? defaultValue : res);
        if (keySeparator) {
          const fk = this.resolve(key, {
            ...options,
            keySeparator: false
          });
          if (fk && fk.res) this.logger.warn('Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.');
        }
        let lngs = [];
        const fallbackLngs = this.languageUtils.getFallbackCodes(this.options.fallbackLng, options.lng || this.language);
        if (this.options.saveMissingTo === 'fallback' && fallbackLngs && fallbackLngs[0]) {
          for (let i = 0; i < fallbackLngs.length; i++) {
            lngs.push(fallbackLngs[i]);
          }
        } else if (this.options.saveMissingTo === 'all') {
          lngs = this.languageUtils.toResolveHierarchy(options.lng || this.language);
        } else {
          lngs.push(options.lng || this.language);
        }
        const send = (l, k, specificDefaultValue) => {
          const defaultForMissing = hasDefaultValue && specificDefaultValue !== res ? specificDefaultValue : resForMissing;
          if (this.options.missingKeyHandler) {
            this.options.missingKeyHandler(l, namespace, k, defaultForMissing, updateMissing, options);
          } else if (this.backendConnector && this.backendConnector.saveMissing) {
            this.backendConnector.saveMissing(l, namespace, k, defaultForMissing, updateMissing, options);
          }
          this.emit('missingKey', l, namespace, k, res);
        };
        if (this.options.saveMissing) {
          if (this.options.saveMissingPlurals && needsPluralHandling) {
            lngs.forEach(language => {
              const suffixes = this.pluralResolver.getSuffixes(language, options);
              if (needsZeroSuffixLookup && options[`defaultValue${this.options.pluralSeparator}zero`] && suffixes.indexOf(`${this.options.pluralSeparator}zero`) < 0) {
                suffixes.push(`${this.options.pluralSeparator}zero`);
              }
              suffixes.forEach(suffix => {
                send([language], key + suffix, options[`defaultValue${suffix}`] || defaultValue);
              });
            });
          } else {
            send(lngs, key, defaultValue);
          }
        }
      }
      res = this.extendTranslation(res, keys, options, resolved, lastKey);
      if (usedKey && res === key && this.options.appendNamespaceToMissingKey) res = `${namespace}:${key}`;
      if ((usedKey || usedDefault) && this.options.parseMissingKeyHandler) {
        if (this.options.compatibilityAPI !== 'v1') {
          res = this.options.parseMissingKeyHandler(this.options.appendNamespaceToMissingKey ? `${namespace}:${key}` : key, usedDefault ? res : undefined);
        } else {
          res = this.options.parseMissingKeyHandler(res);
        }
      }
    }
    if (returnDetails) {
      resolved.res = res;
      resolved.usedParams = this.getUsedParamsDetails(options);
      return resolved;
    }
    return res;
  }
  extendTranslation(res, key, options, resolved, lastKey) {
    var _this = this;
    if (this.i18nFormat && this.i18nFormat.parse) {
      res = this.i18nFormat.parse(res, {
        ...this.options.interpolation.defaultVariables,
        ...options
      }, options.lng || this.language || resolved.usedLng, resolved.usedNS, resolved.usedKey, {
        resolved
      });
    } else if (!options.skipInterpolation) {
      if (options.interpolation) this.interpolator.init({
        ...options,
        ...{
          interpolation: {
            ...this.options.interpolation,
            ...options.interpolation
          }
        }
      });
      const skipOnVariables = isString$1(res) && (options && options.interpolation && options.interpolation.skipOnVariables !== undefined ? options.interpolation.skipOnVariables : this.options.interpolation.skipOnVariables);
      let nestBef;
      if (skipOnVariables) {
        const nb = res.match(this.interpolator.nestingRegexp);
        nestBef = nb && nb.length;
      }
      let data = options.replace && !isString$1(options.replace) ? options.replace : options;
      if (this.options.interpolation.defaultVariables) data = {
        ...this.options.interpolation.defaultVariables,
        ...data
      };
      res = this.interpolator.interpolate(res, data, options.lng || this.language || resolved.usedLng, options);
      if (skipOnVariables) {
        const na = res.match(this.interpolator.nestingRegexp);
        const nestAft = na && na.length;
        if (nestBef < nestAft) options.nest = false;
      }
      if (!options.lng && this.options.compatibilityAPI !== 'v1' && resolved && resolved.res) options.lng = this.language || resolved.usedLng;
      if (options.nest !== false) res = this.interpolator.nest(res, function () {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        if (lastKey && lastKey[0] === args[0] && !options.context) {
          _this.logger.warn(`It seems you are nesting recursively key: ${args[0]} in key: ${key[0]}`);
          return null;
        }
        return _this.translate(...args, key);
      }, options);
      if (options.interpolation) this.interpolator.reset();
    }
    const postProcess = options.postProcess || this.options.postProcess;
    const postProcessorNames = isString$1(postProcess) ? [postProcess] : postProcess;
    if (res !== undefined && res !== null && postProcessorNames && postProcessorNames.length && options.applyPostProcessor !== false) {
      res = postProcessor.handle(postProcessorNames, res, key, this.options && this.options.postProcessPassResolved ? {
        i18nResolved: {
          ...resolved,
          usedParams: this.getUsedParamsDetails(options)
        },
        ...options
      } : options, this);
    }
    return res;
  }
  resolve(keys) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    let found;
    let usedKey;
    let exactUsedKey;
    let usedLng;
    let usedNS;
    if (isString$1(keys)) keys = [keys];
    keys.forEach(k => {
      if (this.isValidLookup(found)) return;
      const extracted = this.extractFromKey(k, options);
      const key = extracted.key;
      usedKey = key;
      let namespaces = extracted.namespaces;
      if (this.options.fallbackNS) namespaces = namespaces.concat(this.options.fallbackNS);
      const needsPluralHandling = options.count !== undefined && !isString$1(options.count);
      const needsZeroSuffixLookup = needsPluralHandling && !options.ordinal && options.count === 0 && this.pluralResolver.shouldUseIntlApi();
      const needsContextHandling = options.context !== undefined && (isString$1(options.context) || typeof options.context === 'number') && options.context !== '';
      const codes = options.lngs ? options.lngs : this.languageUtils.toResolveHierarchy(options.lng || this.language, options.fallbackLng);
      namespaces.forEach(ns => {
        if (this.isValidLookup(found)) return;
        usedNS = ns;
        if (!checkedLoadedFor[`${codes[0]}-${ns}`] && this.utils && this.utils.hasLoadedNamespace && !this.utils.hasLoadedNamespace(usedNS)) {
          checkedLoadedFor[`${codes[0]}-${ns}`] = true;
          this.logger.warn(`key "${usedKey}" for languages "${codes.join(', ')}" won't get resolved as namespace "${usedNS}" was not yet loaded`, 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
        }
        codes.forEach(code => {
          if (this.isValidLookup(found)) return;
          usedLng = code;
          const finalKeys = [key];
          if (this.i18nFormat && this.i18nFormat.addLookupKeys) {
            this.i18nFormat.addLookupKeys(finalKeys, key, code, ns, options);
          } else {
            let pluralSuffix;
            if (needsPluralHandling) pluralSuffix = this.pluralResolver.getSuffix(code, options.count, options);
            const zeroSuffix = `${this.options.pluralSeparator}zero`;
            const ordinalPrefix = `${this.options.pluralSeparator}ordinal${this.options.pluralSeparator}`;
            if (needsPluralHandling) {
              finalKeys.push(key + pluralSuffix);
              if (options.ordinal && pluralSuffix.indexOf(ordinalPrefix) === 0) {
                finalKeys.push(key + pluralSuffix.replace(ordinalPrefix, this.options.pluralSeparator));
              }
              if (needsZeroSuffixLookup) {
                finalKeys.push(key + zeroSuffix);
              }
            }
            if (needsContextHandling) {
              const contextKey = `${key}${this.options.contextSeparator}${options.context}`;
              finalKeys.push(contextKey);
              if (needsPluralHandling) {
                finalKeys.push(contextKey + pluralSuffix);
                if (options.ordinal && pluralSuffix.indexOf(ordinalPrefix) === 0) {
                  finalKeys.push(contextKey + pluralSuffix.replace(ordinalPrefix, this.options.pluralSeparator));
                }
                if (needsZeroSuffixLookup) {
                  finalKeys.push(contextKey + zeroSuffix);
                }
              }
            }
          }
          let possibleKey;
          while (possibleKey = finalKeys.pop()) {
            if (!this.isValidLookup(found)) {
              exactUsedKey = possibleKey;
              found = this.getResource(code, ns, possibleKey, options);
            }
          }
        });
      });
    });
    return {
      res: found,
      usedKey,
      exactUsedKey,
      usedLng,
      usedNS
    };
  }
  isValidLookup(res) {
    return res !== undefined && !(!this.options.returnNull && res === null) && !(!this.options.returnEmptyString && res === '');
  }
  getResource(code, ns, key) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    if (this.i18nFormat && this.i18nFormat.getResource) return this.i18nFormat.getResource(code, ns, key, options);
    return this.resourceStore.getResource(code, ns, key, options);
  }
  getUsedParamsDetails() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    const optionsKeys = ['defaultValue', 'ordinal', 'context', 'replace', 'lng', 'lngs', 'fallbackLng', 'ns', 'keySeparator', 'nsSeparator', 'returnObjects', 'returnDetails', 'joinArrays', 'postProcess', 'interpolation'];
    const useOptionsReplaceForData = options.replace && !isString$1(options.replace);
    let data = useOptionsReplaceForData ? options.replace : options;
    if (useOptionsReplaceForData && typeof options.count !== 'undefined') {
      data.count = options.count;
    }
    if (this.options.interpolation.defaultVariables) {
      data = {
        ...this.options.interpolation.defaultVariables,
        ...data
      };
    }
    if (!useOptionsReplaceForData) {
      data = {
        ...data
      };
      for (const key of optionsKeys) {
        delete data[key];
      }
    }
    return data;
  }
  static hasDefaultValue(options) {
    const prefix = 'defaultValue';
    for (const option in options) {
      if (Object.prototype.hasOwnProperty.call(options, option) && prefix === option.substring(0, prefix.length) && undefined !== options[option]) {
        return true;
      }
    }
    return false;
  }
}

const capitalize = string => string.charAt(0).toUpperCase() + string.slice(1);
class LanguageUtil {
  constructor(options) {
    this.options = options;
    this.supportedLngs = this.options.supportedLngs || false;
    this.logger = baseLogger.create('languageUtils');
  }
  getScriptPartFromCode(code) {
    code = getCleanedCode(code);
    if (!code || code.indexOf('-') < 0) return null;
    const p = code.split('-');
    if (p.length === 2) return null;
    p.pop();
    if (p[p.length - 1].toLowerCase() === 'x') return null;
    return this.formatLanguageCode(p.join('-'));
  }
  getLanguagePartFromCode(code) {
    code = getCleanedCode(code);
    if (!code || code.indexOf('-') < 0) return code;
    const p = code.split('-');
    return this.formatLanguageCode(p[0]);
  }
  formatLanguageCode(code) {
    if (isString$1(code) && code.indexOf('-') > -1) {
      if (typeof Intl !== 'undefined' && typeof Intl.getCanonicalLocales !== 'undefined') {
        try {
          let formattedCode = Intl.getCanonicalLocales(code)[0];
          if (formattedCode && this.options.lowerCaseLng) {
            formattedCode = formattedCode.toLowerCase();
          }
          if (formattedCode) return formattedCode;
        } catch (e) {}
      }
      const specialCases = ['hans', 'hant', 'latn', 'cyrl', 'cans', 'mong', 'arab'];
      let p = code.split('-');
      if (this.options.lowerCaseLng) {
        p = p.map(part => part.toLowerCase());
      } else if (p.length === 2) {
        p[0] = p[0].toLowerCase();
        p[1] = p[1].toUpperCase();
        if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
      } else if (p.length === 3) {
        p[0] = p[0].toLowerCase();
        if (p[1].length === 2) p[1] = p[1].toUpperCase();
        if (p[0] !== 'sgn' && p[2].length === 2) p[2] = p[2].toUpperCase();
        if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
        if (specialCases.indexOf(p[2].toLowerCase()) > -1) p[2] = capitalize(p[2].toLowerCase());
      }
      return p.join('-');
    }
    return this.options.cleanCode || this.options.lowerCaseLng ? code.toLowerCase() : code;
  }
  isSupportedCode(code) {
    if (this.options.load === 'languageOnly' || this.options.nonExplicitSupportedLngs) {
      code = this.getLanguagePartFromCode(code);
    }
    return !this.supportedLngs || !this.supportedLngs.length || this.supportedLngs.indexOf(code) > -1;
  }
  getBestMatchFromCodes(codes) {
    if (!codes) return null;
    let found;
    codes.forEach(code => {
      if (found) return;
      const cleanedLng = this.formatLanguageCode(code);
      if (!this.options.supportedLngs || this.isSupportedCode(cleanedLng)) found = cleanedLng;
    });
    if (!found && this.options.supportedLngs) {
      codes.forEach(code => {
        if (found) return;
        const lngOnly = this.getLanguagePartFromCode(code);
        if (this.isSupportedCode(lngOnly)) return found = lngOnly;
        found = this.options.supportedLngs.find(supportedLng => {
          if (supportedLng === lngOnly) return supportedLng;
          if (supportedLng.indexOf('-') < 0 && lngOnly.indexOf('-') < 0) return;
          if (supportedLng.indexOf('-') > 0 && lngOnly.indexOf('-') < 0 && supportedLng.substring(0, supportedLng.indexOf('-')) === lngOnly) return supportedLng;
          if (supportedLng.indexOf(lngOnly) === 0 && lngOnly.length > 1) return supportedLng;
        });
      });
    }
    if (!found) found = this.getFallbackCodes(this.options.fallbackLng)[0];
    return found;
  }
  getFallbackCodes(fallbacks, code) {
    if (!fallbacks) return [];
    if (typeof fallbacks === 'function') fallbacks = fallbacks(code);
    if (isString$1(fallbacks)) fallbacks = [fallbacks];
    if (Array.isArray(fallbacks)) return fallbacks;
    if (!code) return fallbacks.default || [];
    let found = fallbacks[code];
    if (!found) found = fallbacks[this.getScriptPartFromCode(code)];
    if (!found) found = fallbacks[this.formatLanguageCode(code)];
    if (!found) found = fallbacks[this.getLanguagePartFromCode(code)];
    if (!found) found = fallbacks.default;
    return found || [];
  }
  toResolveHierarchy(code, fallbackCode) {
    const fallbackCodes = this.getFallbackCodes(fallbackCode || this.options.fallbackLng || [], code);
    const codes = [];
    const addCode = c => {
      if (!c) return;
      if (this.isSupportedCode(c)) {
        codes.push(c);
      } else {
        this.logger.warn(`rejecting language code not found in supportedLngs: ${c}`);
      }
    };
    if (isString$1(code) && (code.indexOf('-') > -1 || code.indexOf('_') > -1)) {
      if (this.options.load !== 'languageOnly') addCode(this.formatLanguageCode(code));
      if (this.options.load !== 'languageOnly' && this.options.load !== 'currentOnly') addCode(this.getScriptPartFromCode(code));
      if (this.options.load !== 'currentOnly') addCode(this.getLanguagePartFromCode(code));
    } else if (isString$1(code)) {
      addCode(this.formatLanguageCode(code));
    }
    fallbackCodes.forEach(fc => {
      if (codes.indexOf(fc) < 0) addCode(this.formatLanguageCode(fc));
    });
    return codes;
  }
}

let sets = [{
  lngs: ['ach', 'ak', 'am', 'arn', 'br', 'fil', 'gun', 'ln', 'mfe', 'mg', 'mi', 'oc', 'pt', 'pt-BR', 'tg', 'tl', 'ti', 'tr', 'uz', 'wa'],
  nr: [1, 2],
  fc: 1
}, {
  lngs: ['af', 'an', 'ast', 'az', 'bg', 'bn', 'ca', 'da', 'de', 'dev', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fi', 'fo', 'fur', 'fy', 'gl', 'gu', 'ha', 'hi', 'hu', 'hy', 'ia', 'it', 'kk', 'kn', 'ku', 'lb', 'mai', 'ml', 'mn', 'mr', 'nah', 'nap', 'nb', 'ne', 'nl', 'nn', 'no', 'nso', 'pa', 'pap', 'pms', 'ps', 'pt-PT', 'rm', 'sco', 'se', 'si', 'so', 'son', 'sq', 'sv', 'sw', 'ta', 'te', 'tk', 'ur', 'yo'],
  nr: [1, 2],
  fc: 2
}, {
  lngs: ['ay', 'bo', 'cgg', 'fa', 'ht', 'id', 'ja', 'jbo', 'ka', 'km', 'ko', 'ky', 'lo', 'ms', 'sah', 'su', 'th', 'tt', 'ug', 'vi', 'wo', 'zh'],
  nr: [1],
  fc: 3
}, {
  lngs: ['be', 'bs', 'cnr', 'dz', 'hr', 'ru', 'sr', 'uk'],
  nr: [1, 2, 5],
  fc: 4
}, {
  lngs: ['ar'],
  nr: [0, 1, 2, 3, 11, 100],
  fc: 5
}, {
  lngs: ['cs', 'sk'],
  nr: [1, 2, 5],
  fc: 6
}, {
  lngs: ['csb', 'pl'],
  nr: [1, 2, 5],
  fc: 7
}, {
  lngs: ['cy'],
  nr: [1, 2, 3, 8],
  fc: 8
}, {
  lngs: ['fr'],
  nr: [1, 2],
  fc: 9
}, {
  lngs: ['ga'],
  nr: [1, 2, 3, 7, 11],
  fc: 10
}, {
  lngs: ['gd'],
  nr: [1, 2, 3, 20],
  fc: 11
}, {
  lngs: ['is'],
  nr: [1, 2],
  fc: 12
}, {
  lngs: ['jv'],
  nr: [0, 1],
  fc: 13
}, {
  lngs: ['kw'],
  nr: [1, 2, 3, 4],
  fc: 14
}, {
  lngs: ['lt'],
  nr: [1, 2, 10],
  fc: 15
}, {
  lngs: ['lv'],
  nr: [1, 2, 0],
  fc: 16
}, {
  lngs: ['mk'],
  nr: [1, 2],
  fc: 17
}, {
  lngs: ['mnk'],
  nr: [0, 1, 2],
  fc: 18
}, {
  lngs: ['mt'],
  nr: [1, 2, 11, 20],
  fc: 19
}, {
  lngs: ['or'],
  nr: [2, 1],
  fc: 2
}, {
  lngs: ['ro'],
  nr: [1, 2, 20],
  fc: 20
}, {
  lngs: ['sl'],
  nr: [5, 1, 2, 3],
  fc: 21
}, {
  lngs: ['he', 'iw'],
  nr: [1, 2, 20, 21],
  fc: 22
}];
let _rulesPluralsTypes = {
  1: n => Number(n > 1),
  2: n => Number(n != 1),
  3: n => 0,
  4: n => Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2),
  5: n => Number(n == 0 ? 0 : n == 1 ? 1 : n == 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5),
  6: n => Number(n == 1 ? 0 : n >= 2 && n <= 4 ? 1 : 2),
  7: n => Number(n == 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2),
  8: n => Number(n == 1 ? 0 : n == 2 ? 1 : n != 8 && n != 11 ? 2 : 3),
  9: n => Number(n >= 2),
  10: n => Number(n == 1 ? 0 : n == 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4),
  11: n => Number(n == 1 || n == 11 ? 0 : n == 2 || n == 12 ? 1 : n > 2 && n < 20 ? 2 : 3),
  12: n => Number(n % 10 != 1 || n % 100 == 11),
  13: n => Number(n !== 0),
  14: n => Number(n == 1 ? 0 : n == 2 ? 1 : n == 3 ? 2 : 3),
  15: n => Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2),
  16: n => Number(n % 10 == 1 && n % 100 != 11 ? 0 : n !== 0 ? 1 : 2),
  17: n => Number(n == 1 || n % 10 == 1 && n % 100 != 11 ? 0 : 1),
  18: n => Number(n == 0 ? 0 : n == 1 ? 1 : 2),
  19: n => Number(n == 1 ? 0 : n == 0 || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3),
  20: n => Number(n == 1 ? 0 : n == 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2),
  21: n => Number(n % 100 == 1 ? 1 : n % 100 == 2 ? 2 : n % 100 == 3 || n % 100 == 4 ? 3 : 0),
  22: n => Number(n == 1 ? 0 : n == 2 ? 1 : (n < 0 || n > 10) && n % 10 == 0 ? 2 : 3)
};
const nonIntlVersions = ['v1', 'v2', 'v3'];
const intlVersions = ['v4'];
const suffixesOrder = {
  zero: 0,
  one: 1,
  two: 2,
  few: 3,
  many: 4,
  other: 5
};
const createRules = () => {
  const rules = {};
  sets.forEach(set => {
    set.lngs.forEach(l => {
      rules[l] = {
        numbers: set.nr,
        plurals: _rulesPluralsTypes[set.fc]
      };
    });
  });
  return rules;
};
class PluralResolver {
  constructor(languageUtils) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    this.languageUtils = languageUtils;
    this.options = options;
    this.logger = baseLogger.create('pluralResolver');
    if ((!this.options.compatibilityJSON || intlVersions.includes(this.options.compatibilityJSON)) && (typeof Intl === 'undefined' || !Intl.PluralRules)) {
      this.options.compatibilityJSON = 'v3';
      this.logger.error('Your environment seems not to be Intl API compatible, use an Intl.PluralRules polyfill. Will fallback to the compatibilityJSON v3 format handling.');
    }
    this.rules = createRules();
    this.pluralRulesCache = {};
  }
  addRule(lng, obj) {
    this.rules[lng] = obj;
  }
  clearCache() {
    this.pluralRulesCache = {};
  }
  getRule(code) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (this.shouldUseIntlApi()) {
      const cleanedCode = getCleanedCode(code === 'dev' ? 'en' : code);
      const type = options.ordinal ? 'ordinal' : 'cardinal';
      const cacheKey = JSON.stringify({
        cleanedCode,
        type
      });
      if (cacheKey in this.pluralRulesCache) {
        return this.pluralRulesCache[cacheKey];
      }
      let rule;
      try {
        rule = new Intl.PluralRules(cleanedCode, {
          type
        });
      } catch (err) {
        if (!code.match(/-|_/)) return;
        const lngPart = this.languageUtils.getLanguagePartFromCode(code);
        rule = this.getRule(lngPart, options);
      }
      this.pluralRulesCache[cacheKey] = rule;
      return rule;
    }
    return this.rules[code] || this.rules[this.languageUtils.getLanguagePartFromCode(code)];
  }
  needsPlural(code) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    const rule = this.getRule(code, options);
    if (this.shouldUseIntlApi()) {
      return rule && rule.resolvedOptions().pluralCategories.length > 1;
    }
    return rule && rule.numbers.length > 1;
  }
  getPluralFormsOfKey(code, key) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    return this.getSuffixes(code, options).map(suffix => `${key}${suffix}`);
  }
  getSuffixes(code) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    const rule = this.getRule(code, options);
    if (!rule) {
      return [];
    }
    if (this.shouldUseIntlApi()) {
      return rule.resolvedOptions().pluralCategories.sort((pluralCategory1, pluralCategory2) => suffixesOrder[pluralCategory1] - suffixesOrder[pluralCategory2]).map(pluralCategory => `${this.options.prepend}${options.ordinal ? `ordinal${this.options.prepend}` : ''}${pluralCategory}`);
    }
    return rule.numbers.map(number => this.getSuffix(code, number, options));
  }
  getSuffix(code, count) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    const rule = this.getRule(code, options);
    if (rule) {
      if (this.shouldUseIntlApi()) {
        return `${this.options.prepend}${options.ordinal ? `ordinal${this.options.prepend}` : ''}${rule.select(count)}`;
      }
      return this.getSuffixRetroCompatible(rule, count);
    }
    this.logger.warn(`no plural rule found for: ${code}`);
    return '';
  }
  getSuffixRetroCompatible(rule, count) {
    const idx = rule.noAbs ? rule.plurals(count) : rule.plurals(Math.abs(count));
    let suffix = rule.numbers[idx];
    if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
      if (suffix === 2) {
        suffix = 'plural';
      } else if (suffix === 1) {
        suffix = '';
      }
    }
    const returnSuffix = () => this.options.prepend && suffix.toString() ? this.options.prepend + suffix.toString() : suffix.toString();
    if (this.options.compatibilityJSON === 'v1') {
      if (suffix === 1) return '';
      if (typeof suffix === 'number') return `_plural_${suffix.toString()}`;
      return returnSuffix();
    } else if (this.options.compatibilityJSON === 'v2') {
      return returnSuffix();
    } else if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
      return returnSuffix();
    }
    return this.options.prepend && idx.toString() ? this.options.prepend + idx.toString() : idx.toString();
  }
  shouldUseIntlApi() {
    return !nonIntlVersions.includes(this.options.compatibilityJSON);
  }
}

const deepFindWithDefaults = function (data, defaultData, key) {
  let keySeparator = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '.';
  let ignoreJSONStructure = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
  let path = getPathWithDefaults(data, defaultData, key);
  if (!path && ignoreJSONStructure && isString$1(key)) {
    path = deepFind(data, key, keySeparator);
    if (path === undefined) path = deepFind(defaultData, key, keySeparator);
  }
  return path;
};
const regexSafe = val => val.replace(/\$/g, '$$$$');
class Interpolator {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.logger = baseLogger.create('interpolator');
    this.options = options;
    this.format = options.interpolation && options.interpolation.format || (value => value);
    this.init(options);
  }
  init() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (!options.interpolation) options.interpolation = {
      escapeValue: true
    };
    const {
      escape: escape$1,
      escapeValue,
      useRawValueToEscape,
      prefix,
      prefixEscaped,
      suffix,
      suffixEscaped,
      formatSeparator,
      unescapeSuffix,
      unescapePrefix,
      nestingPrefix,
      nestingPrefixEscaped,
      nestingSuffix,
      nestingSuffixEscaped,
      nestingOptionsSeparator,
      maxReplaces,
      alwaysFormat
    } = options.interpolation;
    this.escape = escape$1 !== undefined ? escape$1 : escape;
    this.escapeValue = escapeValue !== undefined ? escapeValue : true;
    this.useRawValueToEscape = useRawValueToEscape !== undefined ? useRawValueToEscape : false;
    this.prefix = prefix ? regexEscape(prefix) : prefixEscaped || '{{';
    this.suffix = suffix ? regexEscape(suffix) : suffixEscaped || '}}';
    this.formatSeparator = formatSeparator || ',';
    this.unescapePrefix = unescapeSuffix ? '' : unescapePrefix || '-';
    this.unescapeSuffix = this.unescapePrefix ? '' : unescapeSuffix || '';
    this.nestingPrefix = nestingPrefix ? regexEscape(nestingPrefix) : nestingPrefixEscaped || regexEscape('$t(');
    this.nestingSuffix = nestingSuffix ? regexEscape(nestingSuffix) : nestingSuffixEscaped || regexEscape(')');
    this.nestingOptionsSeparator = nestingOptionsSeparator || ',';
    this.maxReplaces = maxReplaces || 1000;
    this.alwaysFormat = alwaysFormat !== undefined ? alwaysFormat : false;
    this.resetRegExp();
  }
  reset() {
    if (this.options) this.init(this.options);
  }
  resetRegExp() {
    const getOrResetRegExp = (existingRegExp, pattern) => {
      if (existingRegExp && existingRegExp.source === pattern) {
        existingRegExp.lastIndex = 0;
        return existingRegExp;
      }
      return new RegExp(pattern, 'g');
    };
    this.regexp = getOrResetRegExp(this.regexp, `${this.prefix}(.+?)${this.suffix}`);
    this.regexpUnescape = getOrResetRegExp(this.regexpUnescape, `${this.prefix}${this.unescapePrefix}(.+?)${this.unescapeSuffix}${this.suffix}`);
    this.nestingRegexp = getOrResetRegExp(this.nestingRegexp, `${this.nestingPrefix}(.+?)${this.nestingSuffix}`);
  }
  interpolate(str, data, lng, options) {
    let match;
    let value;
    let replaces;
    const defaultData = this.options && this.options.interpolation && this.options.interpolation.defaultVariables || {};
    const handleFormat = key => {
      if (key.indexOf(this.formatSeparator) < 0) {
        const path = deepFindWithDefaults(data, defaultData, key, this.options.keySeparator, this.options.ignoreJSONStructure);
        return this.alwaysFormat ? this.format(path, undefined, lng, {
          ...options,
          ...data,
          interpolationkey: key
        }) : path;
      }
      const p = key.split(this.formatSeparator);
      const k = p.shift().trim();
      const f = p.join(this.formatSeparator).trim();
      return this.format(deepFindWithDefaults(data, defaultData, k, this.options.keySeparator, this.options.ignoreJSONStructure), f, lng, {
        ...options,
        ...data,
        interpolationkey: k
      });
    };
    this.resetRegExp();
    const missingInterpolationHandler = options && options.missingInterpolationHandler || this.options.missingInterpolationHandler;
    const skipOnVariables = options && options.interpolation && options.interpolation.skipOnVariables !== undefined ? options.interpolation.skipOnVariables : this.options.interpolation.skipOnVariables;
    const todos = [{
      regex: this.regexpUnescape,
      safeValue: val => regexSafe(val)
    }, {
      regex: this.regexp,
      safeValue: val => this.escapeValue ? regexSafe(this.escape(val)) : regexSafe(val)
    }];
    todos.forEach(todo => {
      replaces = 0;
      while (match = todo.regex.exec(str)) {
        const matchedVar = match[1].trim();
        value = handleFormat(matchedVar);
        if (value === undefined) {
          if (typeof missingInterpolationHandler === 'function') {
            const temp = missingInterpolationHandler(str, match, options);
            value = isString$1(temp) ? temp : '';
          } else if (options && Object.prototype.hasOwnProperty.call(options, matchedVar)) {
            value = '';
          } else if (skipOnVariables) {
            value = match[0];
            continue;
          } else {
            this.logger.warn(`missed to pass in variable ${matchedVar} for interpolating ${str}`);
            value = '';
          }
        } else if (!isString$1(value) && !this.useRawValueToEscape) {
          value = makeString(value);
        }
        const safeValue = todo.safeValue(value);
        str = str.replace(match[0], safeValue);
        if (skipOnVariables) {
          todo.regex.lastIndex += value.length;
          todo.regex.lastIndex -= match[0].length;
        } else {
          todo.regex.lastIndex = 0;
        }
        replaces++;
        if (replaces >= this.maxReplaces) {
          break;
        }
      }
    });
    return str;
  }
  nest(str, fc) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    let match;
    let value;
    let clonedOptions;
    const handleHasOptions = (key, inheritedOptions) => {
      const sep = this.nestingOptionsSeparator;
      if (key.indexOf(sep) < 0) return key;
      const c = key.split(new RegExp(`${sep}[ ]*{`));
      let optionsString = `{${c[1]}`;
      key = c[0];
      optionsString = this.interpolate(optionsString, clonedOptions);
      const matchedSingleQuotes = optionsString.match(/'/g);
      const matchedDoubleQuotes = optionsString.match(/"/g);
      if (matchedSingleQuotes && matchedSingleQuotes.length % 2 === 0 && !matchedDoubleQuotes || matchedDoubleQuotes.length % 2 !== 0) {
        optionsString = optionsString.replace(/'/g, '"');
      }
      try {
        clonedOptions = JSON.parse(optionsString);
        if (inheritedOptions) clonedOptions = {
          ...inheritedOptions,
          ...clonedOptions
        };
      } catch (e) {
        this.logger.warn(`failed parsing options string in nesting for key ${key}`, e);
        return `${key}${sep}${optionsString}`;
      }
      if (clonedOptions.defaultValue && clonedOptions.defaultValue.indexOf(this.prefix) > -1) delete clonedOptions.defaultValue;
      return key;
    };
    while (match = this.nestingRegexp.exec(str)) {
      let formatters = [];
      clonedOptions = {
        ...options
      };
      clonedOptions = clonedOptions.replace && !isString$1(clonedOptions.replace) ? clonedOptions.replace : clonedOptions;
      clonedOptions.applyPostProcessor = false;
      delete clonedOptions.defaultValue;
      let doReduce = false;
      if (match[0].indexOf(this.formatSeparator) !== -1 && !/{.*}/.test(match[1])) {
        const r = match[1].split(this.formatSeparator).map(elem => elem.trim());
        match[1] = r.shift();
        formatters = r;
        doReduce = true;
      }
      value = fc(handleHasOptions.call(this, match[1].trim(), clonedOptions), clonedOptions);
      if (value && match[0] === str && !isString$1(value)) return value;
      if (!isString$1(value)) value = makeString(value);
      if (!value) {
        this.logger.warn(`missed to resolve ${match[1]} for nesting ${str}`);
        value = '';
      }
      if (doReduce) {
        value = formatters.reduce((v, f) => this.format(v, f, options.lng, {
          ...options,
          interpolationkey: match[1].trim()
        }), value.trim());
      }
      str = str.replace(match[0], value);
      this.regexp.lastIndex = 0;
    }
    return str;
  }
}

const parseFormatStr = formatStr => {
  let formatName = formatStr.toLowerCase().trim();
  const formatOptions = {};
  if (formatStr.indexOf('(') > -1) {
    const p = formatStr.split('(');
    formatName = p[0].toLowerCase().trim();
    const optStr = p[1].substring(0, p[1].length - 1);
    if (formatName === 'currency' && optStr.indexOf(':') < 0) {
      if (!formatOptions.currency) formatOptions.currency = optStr.trim();
    } else if (formatName === 'relativetime' && optStr.indexOf(':') < 0) {
      if (!formatOptions.range) formatOptions.range = optStr.trim();
    } else {
      const opts = optStr.split(';');
      opts.forEach(opt => {
        if (opt) {
          const [key, ...rest] = opt.split(':');
          const val = rest.join(':').trim().replace(/^'+|'+$/g, '');
          const trimmedKey = key.trim();
          if (!formatOptions[trimmedKey]) formatOptions[trimmedKey] = val;
          if (val === 'false') formatOptions[trimmedKey] = false;
          if (val === 'true') formatOptions[trimmedKey] = true;
          if (!isNaN(val)) formatOptions[trimmedKey] = parseInt(val, 10);
        }
      });
    }
  }
  return {
    formatName,
    formatOptions
  };
};
const createCachedFormatter = fn => {
  const cache = {};
  return (val, lng, options) => {
    let optForCache = options;
    if (options && options.interpolationkey && options.formatParams && options.formatParams[options.interpolationkey] && options[options.interpolationkey]) {
      optForCache = {
        ...optForCache,
        [options.interpolationkey]: undefined
      };
    }
    const key = lng + JSON.stringify(optForCache);
    let formatter = cache[key];
    if (!formatter) {
      formatter = fn(getCleanedCode(lng), options);
      cache[key] = formatter;
    }
    return formatter(val);
  };
};
class Formatter {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.logger = baseLogger.create('formatter');
    this.options = options;
    this.formats = {
      number: createCachedFormatter((lng, opt) => {
        const formatter = new Intl.NumberFormat(lng, {
          ...opt
        });
        return val => formatter.format(val);
      }),
      currency: createCachedFormatter((lng, opt) => {
        const formatter = new Intl.NumberFormat(lng, {
          ...opt,
          style: 'currency'
        });
        return val => formatter.format(val);
      }),
      datetime: createCachedFormatter((lng, opt) => {
        const formatter = new Intl.DateTimeFormat(lng, {
          ...opt
        });
        return val => formatter.format(val);
      }),
      relativetime: createCachedFormatter((lng, opt) => {
        const formatter = new Intl.RelativeTimeFormat(lng, {
          ...opt
        });
        return val => formatter.format(val, opt.range || 'day');
      }),
      list: createCachedFormatter((lng, opt) => {
        const formatter = new Intl.ListFormat(lng, {
          ...opt
        });
        return val => formatter.format(val);
      })
    };
    this.init(options);
  }
  init(services) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      interpolation: {}
    };
    this.formatSeparator = options.interpolation.formatSeparator || ',';
  }
  add(name, fc) {
    this.formats[name.toLowerCase().trim()] = fc;
  }
  addCached(name, fc) {
    this.formats[name.toLowerCase().trim()] = createCachedFormatter(fc);
  }
  format(value, format, lng) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    const formats = format.split(this.formatSeparator);
    if (formats.length > 1 && formats[0].indexOf('(') > 1 && formats[0].indexOf(')') < 0 && formats.find(f => f.indexOf(')') > -1)) {
      const lastIndex = formats.findIndex(f => f.indexOf(')') > -1);
      formats[0] = [formats[0], ...formats.splice(1, lastIndex)].join(this.formatSeparator);
    }
    const result = formats.reduce((mem, f) => {
      const {
        formatName,
        formatOptions
      } = parseFormatStr(f);
      if (this.formats[formatName]) {
        let formatted = mem;
        try {
          const valOptions = options && options.formatParams && options.formatParams[options.interpolationkey] || {};
          const l = valOptions.locale || valOptions.lng || options.locale || options.lng || lng;
          formatted = this.formats[formatName](mem, l, {
            ...formatOptions,
            ...options,
            ...valOptions
          });
        } catch (error) {
          this.logger.warn(error);
        }
        return formatted;
      } else {
        this.logger.warn(`there was no format function for ${formatName}`);
      }
      return mem;
    }, value);
    return result;
  }
}

const removePending = (q, name) => {
  if (q.pending[name] !== undefined) {
    delete q.pending[name];
    q.pendingCount--;
  }
};
class Connector extends EventEmitter {
  constructor(backend, store, services) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    super();
    this.backend = backend;
    this.store = store;
    this.services = services;
    this.languageUtils = services.languageUtils;
    this.options = options;
    this.logger = baseLogger.create('backendConnector');
    this.waitingReads = [];
    this.maxParallelReads = options.maxParallelReads || 10;
    this.readingCalls = 0;
    this.maxRetries = options.maxRetries >= 0 ? options.maxRetries : 5;
    this.retryTimeout = options.retryTimeout >= 1 ? options.retryTimeout : 350;
    this.state = {};
    this.queue = [];
    if (this.backend && this.backend.init) {
      this.backend.init(services, options.backend, options);
    }
  }
  queueLoad(languages, namespaces, options, callback) {
    const toLoad = {};
    const pending = {};
    const toLoadLanguages = {};
    const toLoadNamespaces = {};
    languages.forEach(lng => {
      let hasAllNamespaces = true;
      namespaces.forEach(ns => {
        const name = `${lng}|${ns}`;
        if (!options.reload && this.store.hasResourceBundle(lng, ns)) {
          this.state[name] = 2;
        } else if (this.state[name] < 0) ; else if (this.state[name] === 1) {
          if (pending[name] === undefined) pending[name] = true;
        } else {
          this.state[name] = 1;
          hasAllNamespaces = false;
          if (pending[name] === undefined) pending[name] = true;
          if (toLoad[name] === undefined) toLoad[name] = true;
          if (toLoadNamespaces[ns] === undefined) toLoadNamespaces[ns] = true;
        }
      });
      if (!hasAllNamespaces) toLoadLanguages[lng] = true;
    });
    if (Object.keys(toLoad).length || Object.keys(pending).length) {
      this.queue.push({
        pending,
        pendingCount: Object.keys(pending).length,
        loaded: {},
        errors: [],
        callback
      });
    }
    return {
      toLoad: Object.keys(toLoad),
      pending: Object.keys(pending),
      toLoadLanguages: Object.keys(toLoadLanguages),
      toLoadNamespaces: Object.keys(toLoadNamespaces)
    };
  }
  loaded(name, err, data) {
    const s = name.split('|');
    const lng = s[0];
    const ns = s[1];
    if (err) this.emit('failedLoading', lng, ns, err);
    if (!err && data) {
      this.store.addResourceBundle(lng, ns, data, undefined, undefined, {
        skipCopy: true
      });
    }
    this.state[name] = err ? -1 : 2;
    if (err && data) this.state[name] = 0;
    const loaded = {};
    this.queue.forEach(q => {
      pushPath(q.loaded, [lng], ns);
      removePending(q, name);
      if (err) q.errors.push(err);
      if (q.pendingCount === 0 && !q.done) {
        Object.keys(q.loaded).forEach(l => {
          if (!loaded[l]) loaded[l] = {};
          const loadedKeys = q.loaded[l];
          if (loadedKeys.length) {
            loadedKeys.forEach(n => {
              if (loaded[l][n] === undefined) loaded[l][n] = true;
            });
          }
        });
        q.done = true;
        if (q.errors.length) {
          q.callback(q.errors);
        } else {
          q.callback();
        }
      }
    });
    this.emit('loaded', loaded);
    this.queue = this.queue.filter(q => !q.done);
  }
  read(lng, ns, fcName) {
    let tried = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    let wait = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.retryTimeout;
    let callback = arguments.length > 5 ? arguments[5] : undefined;
    if (!lng.length) return callback(null, {});
    if (this.readingCalls >= this.maxParallelReads) {
      this.waitingReads.push({
        lng,
        ns,
        fcName,
        tried,
        wait,
        callback
      });
      return;
    }
    this.readingCalls++;
    const resolver = (err, data) => {
      this.readingCalls--;
      if (this.waitingReads.length > 0) {
        const next = this.waitingReads.shift();
        this.read(next.lng, next.ns, next.fcName, next.tried, next.wait, next.callback);
      }
      if (err && data && tried < this.maxRetries) {
        setTimeout(() => {
          this.read.call(this, lng, ns, fcName, tried + 1, wait * 2, callback);
        }, wait);
        return;
      }
      callback(err, data);
    };
    const fc = this.backend[fcName].bind(this.backend);
    if (fc.length === 2) {
      try {
        const r = fc(lng, ns);
        if (r && typeof r.then === 'function') {
          r.then(data => resolver(null, data)).catch(resolver);
        } else {
          resolver(null, r);
        }
      } catch (err) {
        resolver(err);
      }
      return;
    }
    return fc(lng, ns, resolver);
  }
  prepareLoading(languages, namespaces) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    let callback = arguments.length > 3 ? arguments[3] : undefined;
    if (!this.backend) {
      this.logger.warn('No backend was added via i18next.use. Will not load resources.');
      return callback && callback();
    }
    if (isString$1(languages)) languages = this.languageUtils.toResolveHierarchy(languages);
    if (isString$1(namespaces)) namespaces = [namespaces];
    const toLoad = this.queueLoad(languages, namespaces, options, callback);
    if (!toLoad.toLoad.length) {
      if (!toLoad.pending.length) callback();
      return null;
    }
    toLoad.toLoad.forEach(name => {
      this.loadOne(name);
    });
  }
  load(languages, namespaces, callback) {
    this.prepareLoading(languages, namespaces, {}, callback);
  }
  reload(languages, namespaces, callback) {
    this.prepareLoading(languages, namespaces, {
      reload: true
    }, callback);
  }
  loadOne(name) {
    let prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    const s = name.split('|');
    const lng = s[0];
    const ns = s[1];
    this.read(lng, ns, 'read', undefined, undefined, (err, data) => {
      if (err) this.logger.warn(`${prefix}loading namespace ${ns} for language ${lng} failed`, err);
      if (!err && data) this.logger.log(`${prefix}loaded namespace ${ns} for language ${lng}`, data);
      this.loaded(name, err, data);
    });
  }
  saveMissing(languages, namespace, key, fallbackValue, isUpdate) {
    let options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};
    let clb = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : () => {};
    if (this.services.utils && this.services.utils.hasLoadedNamespace && !this.services.utils.hasLoadedNamespace(namespace)) {
      this.logger.warn(`did not save key "${key}" as the namespace "${namespace}" was not yet loaded`, 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
      return;
    }
    if (key === undefined || key === null || key === '') return;
    if (this.backend && this.backend.create) {
      const opts = {
        ...options,
        isUpdate
      };
      const fc = this.backend.create.bind(this.backend);
      if (fc.length < 6) {
        try {
          let r;
          if (fc.length === 5) {
            r = fc(languages, namespace, key, fallbackValue, opts);
          } else {
            r = fc(languages, namespace, key, fallbackValue);
          }
          if (r && typeof r.then === 'function') {
            r.then(data => clb(null, data)).catch(clb);
          } else {
            clb(null, r);
          }
        } catch (err) {
          clb(err);
        }
      } else {
        fc(languages, namespace, key, fallbackValue, clb, opts);
      }
    }
    if (!languages || !languages[0]) return;
    this.store.addResource(languages[0], namespace, key, fallbackValue);
  }
}

const get = () => ({
  debug: false,
  initImmediate: true,
  ns: ['translation'],
  defaultNS: ['translation'],
  fallbackLng: ['dev'],
  fallbackNS: false,
  supportedLngs: false,
  nonExplicitSupportedLngs: false,
  load: 'all',
  preload: false,
  simplifyPluralSuffix: true,
  keySeparator: '.',
  nsSeparator: ':',
  pluralSeparator: '_',
  contextSeparator: '_',
  partialBundledLanguages: false,
  saveMissing: false,
  updateMissing: false,
  saveMissingTo: 'fallback',
  saveMissingPlurals: true,
  missingKeyHandler: false,
  missingInterpolationHandler: false,
  postProcess: false,
  postProcessPassResolved: false,
  returnNull: false,
  returnEmptyString: true,
  returnObjects: false,
  joinArrays: false,
  returnedObjectHandler: false,
  parseMissingKeyHandler: false,
  appendNamespaceToMissingKey: false,
  appendNamespaceToCIMode: false,
  overloadTranslationOptionHandler: args => {
    let ret = {};
    if (typeof args[1] === 'object') ret = args[1];
    if (isString$1(args[1])) ret.defaultValue = args[1];
    if (isString$1(args[2])) ret.tDescription = args[2];
    if (typeof args[2] === 'object' || typeof args[3] === 'object') {
      const options = args[3] || args[2];
      Object.keys(options).forEach(key => {
        ret[key] = options[key];
      });
    }
    return ret;
  },
  interpolation: {
    escapeValue: true,
    format: value => value,
    prefix: '{{',
    suffix: '}}',
    formatSeparator: ',',
    unescapePrefix: '-',
    nestingPrefix: '$t(',
    nestingSuffix: ')',
    nestingOptionsSeparator: ',',
    maxReplaces: 1000,
    skipOnVariables: true
  }
});
const transformOptions = options => {
  if (isString$1(options.ns)) options.ns = [options.ns];
  if (isString$1(options.fallbackLng)) options.fallbackLng = [options.fallbackLng];
  if (isString$1(options.fallbackNS)) options.fallbackNS = [options.fallbackNS];
  if (options.supportedLngs && options.supportedLngs.indexOf('cimode') < 0) {
    options.supportedLngs = options.supportedLngs.concat(['cimode']);
  }
  return options;
};

const noop = () => {};
const bindMemberFunctions = inst => {
  const mems = Object.getOwnPropertyNames(Object.getPrototypeOf(inst));
  mems.forEach(mem => {
    if (typeof inst[mem] === 'function') {
      inst[mem] = inst[mem].bind(inst);
    }
  });
};
class I18n extends EventEmitter {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let callback = arguments.length > 1 ? arguments[1] : undefined;
    super();
    this.options = transformOptions(options);
    this.services = {};
    this.logger = baseLogger;
    this.modules = {
      external: []
    };
    bindMemberFunctions(this);
    if (callback && !this.isInitialized && !options.isClone) {
      if (!this.options.initImmediate) {
        this.init(options, callback);
        return this;
      }
      setTimeout(() => {
        this.init(options, callback);
      }, 0);
    }
  }
  init() {
    var _this = this;
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let callback = arguments.length > 1 ? arguments[1] : undefined;
    this.isInitializing = true;
    if (typeof options === 'function') {
      callback = options;
      options = {};
    }
    if (!options.defaultNS && options.defaultNS !== false && options.ns) {
      if (isString$1(options.ns)) {
        options.defaultNS = options.ns;
      } else if (options.ns.indexOf('translation') < 0) {
        options.defaultNS = options.ns[0];
      }
    }
    const defOpts = get();
    this.options = {
      ...defOpts,
      ...this.options,
      ...transformOptions(options)
    };
    if (this.options.compatibilityAPI !== 'v1') {
      this.options.interpolation = {
        ...defOpts.interpolation,
        ...this.options.interpolation
      };
    }
    if (options.keySeparator !== undefined) {
      this.options.userDefinedKeySeparator = options.keySeparator;
    }
    if (options.nsSeparator !== undefined) {
      this.options.userDefinedNsSeparator = options.nsSeparator;
    }
    const createClassOnDemand = ClassOrObject => {
      if (!ClassOrObject) return null;
      if (typeof ClassOrObject === 'function') return new ClassOrObject();
      return ClassOrObject;
    };
    if (!this.options.isClone) {
      if (this.modules.logger) {
        baseLogger.init(createClassOnDemand(this.modules.logger), this.options);
      } else {
        baseLogger.init(null, this.options);
      }
      let formatter;
      if (this.modules.formatter) {
        formatter = this.modules.formatter;
      } else if (typeof Intl !== 'undefined') {
        formatter = Formatter;
      }
      const lu = new LanguageUtil(this.options);
      this.store = new ResourceStore(this.options.resources, this.options);
      const s = this.services;
      s.logger = baseLogger;
      s.resourceStore = this.store;
      s.languageUtils = lu;
      s.pluralResolver = new PluralResolver(lu, {
        prepend: this.options.pluralSeparator,
        compatibilityJSON: this.options.compatibilityJSON,
        simplifyPluralSuffix: this.options.simplifyPluralSuffix
      });
      if (formatter && (!this.options.interpolation.format || this.options.interpolation.format === defOpts.interpolation.format)) {
        s.formatter = createClassOnDemand(formatter);
        s.formatter.init(s, this.options);
        this.options.interpolation.format = s.formatter.format.bind(s.formatter);
      }
      s.interpolator = new Interpolator(this.options);
      s.utils = {
        hasLoadedNamespace: this.hasLoadedNamespace.bind(this)
      };
      s.backendConnector = new Connector(createClassOnDemand(this.modules.backend), s.resourceStore, s, this.options);
      s.backendConnector.on('*', function (event) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        _this.emit(event, ...args);
      });
      if (this.modules.languageDetector) {
        s.languageDetector = createClassOnDemand(this.modules.languageDetector);
        if (s.languageDetector.init) s.languageDetector.init(s, this.options.detection, this.options);
      }
      if (this.modules.i18nFormat) {
        s.i18nFormat = createClassOnDemand(this.modules.i18nFormat);
        if (s.i18nFormat.init) s.i18nFormat.init(this);
      }
      this.translator = new Translator(this.services, this.options);
      this.translator.on('*', function (event) {
        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }
        _this.emit(event, ...args);
      });
      this.modules.external.forEach(m => {
        if (m.init) m.init(this);
      });
    }
    this.format = this.options.interpolation.format;
    if (!callback) callback = noop;
    if (this.options.fallbackLng && !this.services.languageDetector && !this.options.lng) {
      const codes = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
      if (codes.length > 0 && codes[0] !== 'dev') this.options.lng = codes[0];
    }
    if (!this.services.languageDetector && !this.options.lng) {
      this.logger.warn('init: no languageDetector is used and no lng is defined');
    }
    const storeApi = ['getResource', 'hasResourceBundle', 'getResourceBundle', 'getDataByLanguage'];
    storeApi.forEach(fcName => {
      this[fcName] = function () {
        return _this.store[fcName](...arguments);
      };
    });
    const storeApiChained = ['addResource', 'addResources', 'addResourceBundle', 'removeResourceBundle'];
    storeApiChained.forEach(fcName => {
      this[fcName] = function () {
        _this.store[fcName](...arguments);
        return _this;
      };
    });
    const deferred = defer();
    const load = () => {
      const finish = (err, t) => {
        this.isInitializing = false;
        if (this.isInitialized && !this.initializedStoreOnce) this.logger.warn('init: i18next is already initialized. You should call init just once!');
        this.isInitialized = true;
        if (!this.options.isClone) this.logger.log('initialized', this.options);
        this.emit('initialized', this.options);
        deferred.resolve(t);
        callback(err, t);
      };
      if (this.languages && this.options.compatibilityAPI !== 'v1' && !this.isInitialized) return finish(null, this.t.bind(this));
      this.changeLanguage(this.options.lng, finish);
    };
    if (this.options.resources || !this.options.initImmediate) {
      load();
    } else {
      setTimeout(load, 0);
    }
    return deferred;
  }
  loadResources(language) {
    let callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;
    let usedCallback = callback;
    const usedLng = isString$1(language) ? language : this.language;
    if (typeof language === 'function') usedCallback = language;
    if (!this.options.resources || this.options.partialBundledLanguages) {
      if (usedLng && usedLng.toLowerCase() === 'cimode' && (!this.options.preload || this.options.preload.length === 0)) return usedCallback();
      const toLoad = [];
      const append = lng => {
        if (!lng) return;
        if (lng === 'cimode') return;
        const lngs = this.services.languageUtils.toResolveHierarchy(lng);
        lngs.forEach(l => {
          if (l === 'cimode') return;
          if (toLoad.indexOf(l) < 0) toLoad.push(l);
        });
      };
      if (!usedLng) {
        const fallbacks = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
        fallbacks.forEach(l => append(l));
      } else {
        append(usedLng);
      }
      if (this.options.preload) {
        this.options.preload.forEach(l => append(l));
      }
      this.services.backendConnector.load(toLoad, this.options.ns, e => {
        if (!e && !this.resolvedLanguage && this.language) this.setResolvedLanguage(this.language);
        usedCallback(e);
      });
    } else {
      usedCallback(null);
    }
  }
  reloadResources(lngs, ns, callback) {
    const deferred = defer();
    if (typeof lngs === 'function') {
      callback = lngs;
      lngs = undefined;
    }
    if (typeof ns === 'function') {
      callback = ns;
      ns = undefined;
    }
    if (!lngs) lngs = this.languages;
    if (!ns) ns = this.options.ns;
    if (!callback) callback = noop;
    this.services.backendConnector.reload(lngs, ns, err => {
      deferred.resolve();
      callback(err);
    });
    return deferred;
  }
  use(module) {
    if (!module) throw new Error('You are passing an undefined module! Please check the object you are passing to i18next.use()');
    if (!module.type) throw new Error('You are passing a wrong module! Please check the object you are passing to i18next.use()');
    if (module.type === 'backend') {
      this.modules.backend = module;
    }
    if (module.type === 'logger' || module.log && module.warn && module.error) {
      this.modules.logger = module;
    }
    if (module.type === 'languageDetector') {
      this.modules.languageDetector = module;
    }
    if (module.type === 'i18nFormat') {
      this.modules.i18nFormat = module;
    }
    if (module.type === 'postProcessor') {
      postProcessor.addPostProcessor(module);
    }
    if (module.type === 'formatter') {
      this.modules.formatter = module;
    }
    if (module.type === '3rdParty') {
      this.modules.external.push(module);
    }
    return this;
  }
  setResolvedLanguage(l) {
    if (!l || !this.languages) return;
    if (['cimode', 'dev'].indexOf(l) > -1) return;
    for (let li = 0; li < this.languages.length; li++) {
      const lngInLngs = this.languages[li];
      if (['cimode', 'dev'].indexOf(lngInLngs) > -1) continue;
      if (this.store.hasLanguageSomeTranslations(lngInLngs)) {
        this.resolvedLanguage = lngInLngs;
        break;
      }
    }
  }
  changeLanguage(lng, callback) {
    var _this2 = this;
    this.isLanguageChangingTo = lng;
    const deferred = defer();
    this.emit('languageChanging', lng);
    const setLngProps = l => {
      this.language = l;
      this.languages = this.services.languageUtils.toResolveHierarchy(l);
      this.resolvedLanguage = undefined;
      this.setResolvedLanguage(l);
    };
    const done = (err, l) => {
      if (l) {
        setLngProps(l);
        this.translator.changeLanguage(l);
        this.isLanguageChangingTo = undefined;
        this.emit('languageChanged', l);
        this.logger.log('languageChanged', l);
      } else {
        this.isLanguageChangingTo = undefined;
      }
      deferred.resolve(function () {
        return _this2.t(...arguments);
      });
      if (callback) callback(err, function () {
        return _this2.t(...arguments);
      });
    };
    const setLng = lngs => {
      if (!lng && !lngs && this.services.languageDetector) lngs = [];
      const l = isString$1(lngs) ? lngs : this.services.languageUtils.getBestMatchFromCodes(lngs);
      if (l) {
        if (!this.language) {
          setLngProps(l);
        }
        if (!this.translator.language) this.translator.changeLanguage(l);
        if (this.services.languageDetector && this.services.languageDetector.cacheUserLanguage) this.services.languageDetector.cacheUserLanguage(l);
      }
      this.loadResources(l, err => {
        done(err, l);
      });
    };
    if (!lng && this.services.languageDetector && !this.services.languageDetector.async) {
      setLng(this.services.languageDetector.detect());
    } else if (!lng && this.services.languageDetector && this.services.languageDetector.async) {
      if (this.services.languageDetector.detect.length === 0) {
        this.services.languageDetector.detect().then(setLng);
      } else {
        this.services.languageDetector.detect(setLng);
      }
    } else {
      setLng(lng);
    }
    return deferred;
  }
  getFixedT(lng, ns, keyPrefix) {
    var _this3 = this;
    const fixedT = function (key, opts) {
      let options;
      if (typeof opts !== 'object') {
        for (var _len3 = arguments.length, rest = new Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
          rest[_key3 - 2] = arguments[_key3];
        }
        options = _this3.options.overloadTranslationOptionHandler([key, opts].concat(rest));
      } else {
        options = {
          ...opts
        };
      }
      options.lng = options.lng || fixedT.lng;
      options.lngs = options.lngs || fixedT.lngs;
      options.ns = options.ns || fixedT.ns;
      if (options.keyPrefix !== '') options.keyPrefix = options.keyPrefix || keyPrefix || fixedT.keyPrefix;
      const keySeparator = _this3.options.keySeparator || '.';
      let resultKey;
      if (options.keyPrefix && Array.isArray(key)) {
        resultKey = key.map(k => `${options.keyPrefix}${keySeparator}${k}`);
      } else {
        resultKey = options.keyPrefix ? `${options.keyPrefix}${keySeparator}${key}` : key;
      }
      return _this3.t(resultKey, options);
    };
    if (isString$1(lng)) {
      fixedT.lng = lng;
    } else {
      fixedT.lngs = lng;
    }
    fixedT.ns = ns;
    fixedT.keyPrefix = keyPrefix;
    return fixedT;
  }
  t() {
    return this.translator && this.translator.translate(...arguments);
  }
  exists() {
    return this.translator && this.translator.exists(...arguments);
  }
  setDefaultNamespace(ns) {
    this.options.defaultNS = ns;
  }
  hasLoadedNamespace(ns) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!this.isInitialized) {
      this.logger.warn('hasLoadedNamespace: i18next was not initialized', this.languages);
      return false;
    }
    if (!this.languages || !this.languages.length) {
      this.logger.warn('hasLoadedNamespace: i18n.languages were undefined or empty', this.languages);
      return false;
    }
    const lng = options.lng || this.resolvedLanguage || this.languages[0];
    const fallbackLng = this.options ? this.options.fallbackLng : false;
    const lastLng = this.languages[this.languages.length - 1];
    if (lng.toLowerCase() === 'cimode') return true;
    const loadNotPending = (l, n) => {
      const loadState = this.services.backendConnector.state[`${l}|${n}`];
      return loadState === -1 || loadState === 0 || loadState === 2;
    };
    if (options.precheck) {
      const preResult = options.precheck(this, loadNotPending);
      if (preResult !== undefined) return preResult;
    }
    if (this.hasResourceBundle(lng, ns)) return true;
    if (!this.services.backendConnector.backend || this.options.resources && !this.options.partialBundledLanguages) return true;
    if (loadNotPending(lng, ns) && (!fallbackLng || loadNotPending(lastLng, ns))) return true;
    return false;
  }
  loadNamespaces(ns, callback) {
    const deferred = defer();
    if (!this.options.ns) {
      if (callback) callback();
      return Promise.resolve();
    }
    if (isString$1(ns)) ns = [ns];
    ns.forEach(n => {
      if (this.options.ns.indexOf(n) < 0) this.options.ns.push(n);
    });
    this.loadResources(err => {
      deferred.resolve();
      if (callback) callback(err);
    });
    return deferred;
  }
  loadLanguages(lngs, callback) {
    const deferred = defer();
    if (isString$1(lngs)) lngs = [lngs];
    const preloaded = this.options.preload || [];
    const newLngs = lngs.filter(lng => preloaded.indexOf(lng) < 0 && this.services.languageUtils.isSupportedCode(lng));
    if (!newLngs.length) {
      if (callback) callback();
      return Promise.resolve();
    }
    this.options.preload = preloaded.concat(newLngs);
    this.loadResources(err => {
      deferred.resolve();
      if (callback) callback(err);
    });
    return deferred;
  }
  dir(lng) {
    if (!lng) lng = this.resolvedLanguage || (this.languages && this.languages.length > 0 ? this.languages[0] : this.language);
    if (!lng) return 'rtl';
    const rtlLngs = ['ar', 'shu', 'sqr', 'ssh', 'xaa', 'yhd', 'yud', 'aao', 'abh', 'abv', 'acm', 'acq', 'acw', 'acx', 'acy', 'adf', 'ads', 'aeb', 'aec', 'afb', 'ajp', 'apc', 'apd', 'arb', 'arq', 'ars', 'ary', 'arz', 'auz', 'avl', 'ayh', 'ayl', 'ayn', 'ayp', 'bbz', 'pga', 'he', 'iw', 'ps', 'pbt', 'pbu', 'pst', 'prp', 'prd', 'ug', 'ur', 'ydd', 'yds', 'yih', 'ji', 'yi', 'hbo', 'men', 'xmn', 'fa', 'jpr', 'peo', 'pes', 'prs', 'dv', 'sam', 'ckb'];
    const languageUtils = this.services && this.services.languageUtils || new LanguageUtil(get());
    return rtlLngs.indexOf(languageUtils.getLanguagePartFromCode(lng)) > -1 || lng.toLowerCase().indexOf('-arab') > 1 ? 'rtl' : 'ltr';
  }
  static createInstance() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let callback = arguments.length > 1 ? arguments[1] : undefined;
    return new I18n(options, callback);
  }
  cloneInstance() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;
    const forkResourceStore = options.forkResourceStore;
    if (forkResourceStore) delete options.forkResourceStore;
    const mergedOptions = {
      ...this.options,
      ...options,
      ...{
        isClone: true
      }
    };
    const clone = new I18n(mergedOptions);
    if (options.debug !== undefined || options.prefix !== undefined) {
      clone.logger = clone.logger.clone(options);
    }
    const membersToCopy = ['store', 'services', 'language'];
    membersToCopy.forEach(m => {
      clone[m] = this[m];
    });
    clone.services = {
      ...this.services
    };
    clone.services.utils = {
      hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
    };
    if (forkResourceStore) {
      clone.store = new ResourceStore(this.store.data, mergedOptions);
      clone.services.resourceStore = clone.store;
    }
    clone.translator = new Translator(clone.services, mergedOptions);
    clone.translator.on('*', function (event) {
      for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
        args[_key4 - 1] = arguments[_key4];
      }
      clone.emit(event, ...args);
    });
    clone.init(mergedOptions, callback);
    clone.translator.options = mergedOptions;
    clone.translator.backendConnector.services.utils = {
      hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
    };
    return clone;
  }
  toJSON() {
    return {
      options: this.options,
      store: this.store,
      language: this.language,
      languages: this.languages,
      resolvedLanguage: this.resolvedLanguage
    };
  }
}
const instance = I18n.createInstance();
instance.createInstance = I18n.createInstance;
const t$1 = instance.t;

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

/**
 * This file automatically generated from `pre-publish.js`.
 * Do not manually edit.
 */

var voidElements = {
  "area": true,
  "base": true,
  "br": true,
  "col": true,
  "embed": true,
  "hr": true,
  "img": true,
  "input": true,
  "link": true,
  "meta": true,
  "param": true,
  "source": true,
  "track": true,
  "wbr": true
};

var e = /*@__PURE__*/getDefaultExportFromCjs(voidElements);

var t=/\s([^'"/\s><]+?)[\s/>]|([^\s=]+)=\s?(".*?"|'.*?')/g;function n(n){var r={type:"tag",name:"",voidElement:!1,attrs:{},children:[]},i=n.match(/<\/?([^\s]+?)[/\s>]/);if(i&&(r.name=i[1],(e[i[1]]||"/"===n.charAt(n.length-2))&&(r.voidElement=!0),r.name.startsWith("!--"))){var s=n.indexOf("--\x3e");return {type:"comment",comment:-1!==s?n.slice(4,s):""}}for(var a=new RegExp(t),c=null;null!==(c=a.exec(n));)if(c[0].trim())if(c[1]){var o=c[1].trim(),l=[o,""];o.indexOf("=")>-1&&(l=o.split("=")),r.attrs[l[0]]=l[1],a.lastIndex--;}else c[2]&&(r.attrs[c[2]]=c[3].trim().substring(1,c[3].length-1));return r}var r=/<[a-zA-Z0-9\-\!\/](?:"[^"]*"|'[^']*'|[^'">])*>/g,i=/^\s*$/,s=Object.create(null);function a(e,t){switch(t.type){case"text":return e+t.content;case"tag":return e+="<"+t.name+(t.attrs?function(e){var t=[];for(var n in e)t.push(n+'="'+e[n]+'"');return t.length?" "+t.join(" "):""}(t.attrs):"")+(t.voidElement?"/>":">"),t.voidElement?e:e+t.children.reduce(a,"")+"</"+t.name+">";case"comment":return e+"\x3c!--"+t.comment+"--\x3e"}}var c={parse:function(e,t){t||(t={}),t.components||(t.components=s);var a,c=[],o=[],l=-1,m=!1;if(0!==e.indexOf("<")){var u=e.indexOf("<");c.push({type:"text",content:-1===u?e:e.substring(0,u)});}return e.replace(r,function(r,s){if(m){if(r!=="</"+a.name+">")return;m=!1;}var u,f="/"!==r.charAt(1),h=r.startsWith("\x3c!--"),p=s+r.length,d=e.charAt(p);if(h){var v=n(r);return l<0?(c.push(v),c):((u=o[l]).children.push(v),c)}if(f&&(l++,"tag"===(a=n(r)).type&&t.components[a.name]&&(a.type="component",m=!0),a.voidElement||m||!d||"<"===d||a.children.push({type:"text",content:e.slice(p,e.indexOf("<",p))}),0===l&&c.push(a),(u=o[l-1])&&u.children.push(a),o[l]=a),(!f||a.voidElement)&&(l>-1&&(a.voidElement||a.name===r.slice(2,-1))&&(l--,a=-1===l?c:o[l]),!m&&"<"!==d&&d)){u=-1===l?c:o[l].children;var x=e.indexOf("<",p),g=e.slice(p,-1===x?void 0:x);i.test(g)&&(g=" "),(x>-1&&l+u.length>=0||" "!==g)&&u.push({type:"text",content:g});}}),c},stringify:function(e){return e.reduce(function(e,t){return e+a("",t)},"")}};

function warn() {
  if (console && console.warn) {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (isString(args[0])) args[0] = `react-i18next:: ${args[0]}`;
    console.warn(...args);
  }
}
const alreadyWarned = {};
function warnOnce() {
  for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    args[_key2] = arguments[_key2];
  }
  if (isString(args[0]) && alreadyWarned[args[0]]) return;
  if (isString(args[0])) alreadyWarned[args[0]] = new Date();
  warn(...args);
}
const loadedClb = (i18n, cb) => () => {
  if (i18n.isInitialized) {
    cb();
  } else {
    const initialized = () => {
      setTimeout(() => {
        i18n.off('initialized', initialized);
      }, 0);
      cb();
    };
    i18n.on('initialized', initialized);
  }
};
const loadNamespaces = (i18n, ns, cb) => {
  i18n.loadNamespaces(ns, loadedClb(i18n, cb));
};
const loadLanguages = (i18n, lng, ns, cb) => {
  if (isString(ns)) ns = [ns];
  ns.forEach(n => {
    if (i18n.options.ns.indexOf(n) < 0) i18n.options.ns.push(n);
  });
  i18n.loadLanguages(lng, loadedClb(i18n, cb));
};
const oldI18nextHasLoadedNamespace = function (ns, i18n) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const lng = i18n.languages[0];
  const fallbackLng = i18n.options ? i18n.options.fallbackLng : false;
  const lastLng = i18n.languages[i18n.languages.length - 1];
  if (lng.toLowerCase() === 'cimode') return true;
  const loadNotPending = (l, n) => {
    const loadState = i18n.services.backendConnector.state[`${l}|${n}`];
    return loadState === -1 || loadState === 2;
  };
  if (options.bindI18n && options.bindI18n.indexOf('languageChanging') > -1 && i18n.services.backendConnector.backend && i18n.isLanguageChangingTo && !loadNotPending(i18n.isLanguageChangingTo, ns)) return false;
  if (i18n.hasResourceBundle(lng, ns)) return true;
  if (!i18n.services.backendConnector.backend || i18n.options.resources && !i18n.options.partialBundledLanguages) return true;
  if (loadNotPending(lng, ns) && (!fallbackLng || loadNotPending(lastLng, ns))) return true;
  return false;
};
const hasLoadedNamespace = function (ns, i18n) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (!i18n.languages || !i18n.languages.length) {
    warnOnce('i18n.languages were undefined or empty', i18n.languages);
    return true;
  }
  const isNewerI18next = i18n.options.ignoreJSONStructure !== undefined;
  if (!isNewerI18next) {
    return oldI18nextHasLoadedNamespace(ns, i18n, options);
  }
  return i18n.hasLoadedNamespace(ns, {
    lng: options.lng,
    precheck: (i18nInstance, loadNotPending) => {
      if (options.bindI18n && options.bindI18n.indexOf('languageChanging') > -1 && i18nInstance.services.backendConnector.backend && i18nInstance.isLanguageChangingTo && !loadNotPending(i18nInstance.isLanguageChangingTo, ns)) return false;
    }
  });
};
const isString = obj => typeof obj === 'string';
const isObject = obj => typeof obj === 'object' && obj !== null;

const matchHtmlEntity = /&(?:amp|#38|lt|#60|gt|#62|apos|#39|quot|#34|nbsp|#160|copy|#169|reg|#174|hellip|#8230|#x2F|#47);/g;
const htmlEntities = {
  '&amp;': '&',
  '&#38;': '&',
  '&lt;': '<',
  '&#60;': '<',
  '&gt;': '>',
  '&#62;': '>',
  '&apos;': "'",
  '&#39;': "'",
  '&quot;': '"',
  '&#34;': '"',
  '&nbsp;': ' ',
  '&#160;': ' ',
  '&copy;': '©',
  '&#169;': '©',
  '&reg;': '®',
  '&#174;': '®',
  '&hellip;': '…',
  '&#8230;': '…',
  '&#x2F;': '/',
  '&#47;': '/'
};
const unescapeHtmlEntity = m => htmlEntities[m];
const unescape = text => text.replace(matchHtmlEntity, unescapeHtmlEntity);

let defaultOptions = {
  bindI18n: 'languageChanged',
  bindI18nStore: '',
  transEmptyNodeValue: '',
  transSupportBasicHtmlNodes: true,
  transWrapTextNodes: '',
  transKeepBasicHtmlNodesFor: ['br', 'strong', 'i', 'p'],
  useSuspense: true,
  unescape
};
const setDefaults = function () {
  let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  defaultOptions = {
    ...defaultOptions,
    ...options
  };
};
const getDefaults = () => defaultOptions;

let i18nInstance;
const setI18n = instance => {
  i18nInstance = instance;
};
const getI18n = () => i18nInstance;

const hasChildren = (node, checkLength) => {
  if (!node) return false;
  const base = node.props ? node.props.children : node.children;
  if (checkLength) return base.length > 0;
  return !!base;
};
const getChildren = node => {
  if (!node) return [];
  const children = node.props ? node.props.children : node.children;
  return node.props && node.props.i18nIsDynamicList ? getAsArray(children) : children;
};
const hasValidReactChildren = children => Array.isArray(children) && children.every(SP_REACT.isValidElement);
const getAsArray = data => Array.isArray(data) ? data : [data];
const mergeProps = (source, target) => {
  const newTarget = {
    ...target
  };
  newTarget.props = Object.assign(source.props, target.props);
  return newTarget;
};
const nodesToString = (children, i18nOptions) => {
  if (!children) return '';
  let stringNode = '';
  const childrenArray = getAsArray(children);
  const keepArray = i18nOptions.transSupportBasicHtmlNodes && i18nOptions.transKeepBasicHtmlNodesFor ? i18nOptions.transKeepBasicHtmlNodesFor : [];
  childrenArray.forEach((child, childIndex) => {
    if (isString(child)) {
      stringNode += `${child}`;
    } else if (SP_REACT.isValidElement(child)) {
      const {
        props,
        type
      } = child;
      const childPropsCount = Object.keys(props).length;
      const shouldKeepChild = keepArray.indexOf(type) > -1;
      const childChildren = props.children;
      if (!childChildren && shouldKeepChild && !childPropsCount) {
        stringNode += `<${type}/>`;
      } else if (!childChildren && (!shouldKeepChild || childPropsCount) || props.i18nIsDynamicList) {
        stringNode += `<${childIndex}></${childIndex}>`;
      } else if (shouldKeepChild && childPropsCount === 1 && isString(childChildren)) {
        stringNode += `<${type}>${childChildren}</${type}>`;
      } else {
        const content = nodesToString(childChildren, i18nOptions);
        stringNode += `<${childIndex}>${content}</${childIndex}>`;
      }
    } else if (child === null) {
      warn(`Trans: the passed in value is invalid - seems you passed in a null child.`);
    } else if (isObject(child)) {
      const {
        format,
        ...clone
      } = child;
      const keys = Object.keys(clone);
      if (keys.length === 1) {
        const value = format ? `${keys[0]}, ${format}` : keys[0];
        stringNode += `{{${value}}}`;
      } else {
        warn(`react-i18next: the passed in object contained more than one variable - the object should look like {{ value, format }} where format is optional.`, child);
      }
    } else {
      warn(`Trans: the passed in value is invalid - seems you passed in a variable like {number} - please pass in variables for interpolation as full objects like {{number}}.`, child);
    }
  });
  return stringNode;
};
const renderNodes = (children, targetString, i18n, i18nOptions, combinedTOpts, shouldUnescape) => {
  if (targetString === '') return [];
  const keepArray = i18nOptions.transKeepBasicHtmlNodesFor || [];
  const emptyChildrenButNeedsHandling = targetString && new RegExp(keepArray.map(keep => `<${keep}`).join('|')).test(targetString);
  if (!children && !emptyChildrenButNeedsHandling && !shouldUnescape) return [targetString];
  const data = {};
  const getData = childs => {
    const childrenArray = getAsArray(childs);
    childrenArray.forEach(child => {
      if (isString(child)) return;
      if (hasChildren(child)) getData(getChildren(child));else if (isObject(child) && !SP_REACT.isValidElement(child)) Object.assign(data, child);
    });
  };
  getData(children);
  const ast = c.parse(`<0>${targetString}</0>`);
  const opts = {
    ...data,
    ...combinedTOpts
  };
  const renderInner = (child, node, rootReactNode) => {
    const childs = getChildren(child);
    const mappedChildren = mapAST(childs, node.children, rootReactNode);
    return hasValidReactChildren(childs) && mappedChildren.length === 0 || child.props && child.props.i18nIsDynamicList ? childs : mappedChildren;
  };
  const pushTranslatedJSX = (child, inner, mem, i, isVoid) => {
    if (child.dummy) {
      child.children = inner;
      mem.push(SP_REACT.cloneElement(child, {
        key: i
      }, isVoid ? undefined : inner));
    } else {
      mem.push(...SP_REACT.Children.map([child], c => {
        const props = {
          ...c.props
        };
        delete props.i18nIsDynamicList;
        return SP_REACT.createElement(c.type, {
          ...props,
          key: i,
          ref: c.ref
        }, isVoid ? null : inner);
      }));
    }
  };
  const mapAST = (reactNode, astNode, rootReactNode) => {
    const reactNodes = getAsArray(reactNode);
    const astNodes = getAsArray(astNode);
    return astNodes.reduce((mem, node, i) => {
      const translationContent = node.children && node.children[0] && node.children[0].content && i18n.services.interpolator.interpolate(node.children[0].content, opts, i18n.language);
      if (node.type === 'tag') {
        let tmp = reactNodes[parseInt(node.name, 10)];
        if (rootReactNode.length === 1 && !tmp) tmp = rootReactNode[0][node.name];
        if (!tmp) tmp = {};
        const child = Object.keys(node.attrs).length !== 0 ? mergeProps({
          props: node.attrs
        }, tmp) : tmp;
        const isElement = SP_REACT.isValidElement(child);
        const isValidTranslationWithChildren = isElement && hasChildren(node, true) && !node.voidElement;
        const isEmptyTransWithHTML = emptyChildrenButNeedsHandling && isObject(child) && child.dummy && !isElement;
        const isKnownComponent = isObject(children) && Object.hasOwnProperty.call(children, node.name);
        if (isString(child)) {
          const value = i18n.services.interpolator.interpolate(child, opts, i18n.language);
          mem.push(value);
        } else if (hasChildren(child) || isValidTranslationWithChildren) {
          const inner = renderInner(child, node, rootReactNode);
          pushTranslatedJSX(child, inner, mem, i);
        } else if (isEmptyTransWithHTML) {
          const inner = mapAST(reactNodes, node.children, rootReactNode);
          pushTranslatedJSX(child, inner, mem, i);
        } else if (Number.isNaN(parseFloat(node.name))) {
          if (isKnownComponent) {
            const inner = renderInner(child, node, rootReactNode);
            pushTranslatedJSX(child, inner, mem, i, node.voidElement);
          } else if (i18nOptions.transSupportBasicHtmlNodes && keepArray.indexOf(node.name) > -1) {
            if (node.voidElement) {
              mem.push(SP_REACT.createElement(node.name, {
                key: `${node.name}-${i}`
              }));
            } else {
              const inner = mapAST(reactNodes, node.children, rootReactNode);
              mem.push(SP_REACT.createElement(node.name, {
                key: `${node.name}-${i}`
              }, inner));
            }
          } else if (node.voidElement) {
            mem.push(`<${node.name} />`);
          } else {
            const inner = mapAST(reactNodes, node.children, rootReactNode);
            mem.push(`<${node.name}>${inner}</${node.name}>`);
          }
        } else if (isObject(child) && !isElement) {
          const content = node.children[0] ? translationContent : null;
          if (content) mem.push(content);
        } else {
          pushTranslatedJSX(child, translationContent, mem, i, node.children.length !== 1 || !translationContent);
        }
      } else if (node.type === 'text') {
        const wrapTextNodes = i18nOptions.transWrapTextNodes;
        const content = shouldUnescape ? i18nOptions.unescape(i18n.services.interpolator.interpolate(node.content, opts, i18n.language)) : i18n.services.interpolator.interpolate(node.content, opts, i18n.language);
        if (wrapTextNodes) {
          mem.push(SP_REACT.createElement(wrapTextNodes, {
            key: `${node.name}-${i}`
          }, content));
        } else {
          mem.push(content);
        }
      }
      return mem;
    }, []);
  };
  const result = mapAST([{
    dummy: true,
    children: children || []
  }], ast, getAsArray(children || []));
  return getChildren(result[0]);
};
function Trans$1(_ref) {
  let {
    children,
    count,
    parent,
    i18nKey,
    context,
    tOptions = {},
    values,
    defaults,
    components,
    ns,
    i18n: i18nFromProps,
    t: tFromProps,
    shouldUnescape,
    ...additionalProps
  } = _ref;
  const i18n = i18nFromProps || getI18n();
  if (!i18n) {
    warnOnce('You will need to pass in an i18next instance by using i18nextReactModule');
    return children;
  }
  const t = tFromProps || i18n.t.bind(i18n) || (k => k);
  const reactI18nextOptions = {
    ...getDefaults(),
    ...(i18n.options && i18n.options.react)
  };
  let namespaces = ns || t.ns || i18n.options && i18n.options.defaultNS;
  namespaces = isString(namespaces) ? [namespaces] : namespaces || ['translation'];
  const nodeAsString = nodesToString(children, reactI18nextOptions);
  const defaultValue = defaults || nodeAsString || reactI18nextOptions.transEmptyNodeValue || i18nKey;
  const {
    hashTransKey
  } = reactI18nextOptions;
  const key = i18nKey || (hashTransKey ? hashTransKey(nodeAsString || defaultValue) : nodeAsString || defaultValue);
  if (i18n.options && i18n.options.interpolation && i18n.options.interpolation.defaultVariables) {
    values = values && Object.keys(values).length > 0 ? {
      ...values,
      ...i18n.options.interpolation.defaultVariables
    } : {
      ...i18n.options.interpolation.defaultVariables
    };
  }
  const interpolationOverride = values || count !== undefined || !children ? tOptions.interpolation : {
    interpolation: {
      ...tOptions.interpolation,
      prefix: '#$?',
      suffix: '?$#'
    }
  };
  const combinedTOpts = {
    ...tOptions,
    context: context || tOptions.context,
    count,
    ...values,
    ...interpolationOverride,
    defaultValue,
    ns: namespaces
  };
  const translation = key ? t(key, combinedTOpts) : defaultValue;
  if (components) {
    Object.keys(components).forEach(c => {
      const comp = components[c];
      if (typeof comp.type === 'function' || !comp.props || !comp.props.children || translation.indexOf(`${c}/>`) < 0 && translation.indexOf(`${c} />`) < 0) return;
      function Componentized() {
        return SP_REACT.createElement(SP_REACT.Fragment, null, comp);
      }
      components[c] = SP_REACT.createElement(Componentized);
    });
  }
  const content = renderNodes(components || children, translation, i18n, reactI18nextOptions, combinedTOpts, shouldUnescape);
  const useAsParent = parent !== undefined ? parent : reactI18nextOptions.defaultTransParent;
  return useAsParent ? SP_REACT.createElement(useAsParent, additionalProps, content) : content;
}

const initReactI18next = {
  type: '3rdParty',
  init(instance) {
    setDefaults(instance.options.react);
    setI18n(instance);
  }
};

const I18nContext = SP_REACT.createContext();
class ReportNamespaces {
  constructor() {
    this.usedNamespaces = {};
  }
  addUsedNamespaces(namespaces) {
    namespaces.forEach(ns => {
      if (!this.usedNamespaces[ns]) this.usedNamespaces[ns] = true;
    });
  }
  getUsedNamespaces = () => Object.keys(this.usedNamespaces);
}

function Trans(_ref) {
  let {
    children,
    count,
    parent,
    i18nKey,
    context,
    tOptions = {},
    values,
    defaults,
    components,
    ns,
    i18n: i18nFromProps,
    t: tFromProps,
    shouldUnescape,
    ...additionalProps
  } = _ref;
  const {
    i18n: i18nFromContext,
    defaultNS: defaultNSFromContext
  } = SP_REACT.useContext(I18nContext) || {};
  const i18n = i18nFromProps || i18nFromContext || getI18n();
  const t = tFromProps || i18n && i18n.t.bind(i18n);
  return Trans$1({
    children,
    count,
    parent,
    i18nKey,
    context,
    tOptions,
    values,
    defaults,
    components,
    ns: ns || t && t.ns || defaultNSFromContext || i18n && i18n.options && i18n.options.defaultNS,
    i18n,
    t: tFromProps,
    shouldUnescape,
    ...additionalProps
  });
}

const usePrevious = (value, ignore) => {
  const ref = SP_REACT.useRef();
  SP_REACT.useEffect(() => {
    ref.current = value;
  }, [value, ignore]);
  return ref.current;
};
const alwaysNewT = (i18n, language, namespace, keyPrefix) => i18n.getFixedT(language, namespace, keyPrefix);
const useMemoizedT = (i18n, language, namespace, keyPrefix) => SP_REACT.useCallback(alwaysNewT(i18n, language, namespace, keyPrefix), [i18n, language, namespace, keyPrefix]);
const useTranslation = function (ns) {
  let props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const {
    i18n: i18nFromProps
  } = props;
  const {
    i18n: i18nFromContext,
    defaultNS: defaultNSFromContext
  } = SP_REACT.useContext(I18nContext) || {};
  const i18n = i18nFromProps || i18nFromContext || getI18n();
  if (i18n && !i18n.reportNamespaces) i18n.reportNamespaces = new ReportNamespaces();
  if (!i18n) {
    warnOnce('You will need to pass in an i18next instance by using initReactI18next');
    const notReadyT = (k, optsOrDefaultValue) => {
      if (isString(optsOrDefaultValue)) return optsOrDefaultValue;
      if (isObject(optsOrDefaultValue) && isString(optsOrDefaultValue.defaultValue)) return optsOrDefaultValue.defaultValue;
      return Array.isArray(k) ? k[k.length - 1] : k;
    };
    const retNotReady = [notReadyT, {}, false];
    retNotReady.t = notReadyT;
    retNotReady.i18n = {};
    retNotReady.ready = false;
    return retNotReady;
  }
  if (i18n.options.react && i18n.options.react.wait !== undefined) warnOnce('It seems you are still using the old wait option, you may migrate to the new useSuspense behaviour.');
  const i18nOptions = {
    ...getDefaults(),
    ...i18n.options.react,
    ...props
  };
  const {
    useSuspense,
    keyPrefix
  } = i18nOptions;
  let namespaces = defaultNSFromContext || i18n.options && i18n.options.defaultNS;
  namespaces = isString(namespaces) ? [namespaces] : namespaces || ['translation'];
  if (i18n.reportNamespaces.addUsedNamespaces) i18n.reportNamespaces.addUsedNamespaces(namespaces);
  const ready = (i18n.isInitialized || i18n.initializedStoreOnce) && namespaces.every(n => hasLoadedNamespace(n, i18n, i18nOptions));
  const memoGetT = useMemoizedT(i18n, props.lng || null, i18nOptions.nsMode === 'fallback' ? namespaces : namespaces[0], keyPrefix);
  const getT = () => memoGetT;
  const getNewT = () => alwaysNewT(i18n, props.lng || null, i18nOptions.nsMode === 'fallback' ? namespaces : namespaces[0], keyPrefix);
  const [t, setT] = SP_REACT.useState(getT);
  let joinedNS = namespaces.join();
  if (props.lng) joinedNS = `${props.lng}${joinedNS}`;
  const previousJoinedNS = usePrevious(joinedNS);
  const isMounted = SP_REACT.useRef(true);
  SP_REACT.useEffect(() => {
    const {
      bindI18n,
      bindI18nStore
    } = i18nOptions;
    isMounted.current = true;
    if (!ready && !useSuspense) {
      if (props.lng) {
        loadLanguages(i18n, props.lng, namespaces, () => {
          if (isMounted.current) setT(getNewT);
        });
      } else {
        loadNamespaces(i18n, namespaces, () => {
          if (isMounted.current) setT(getNewT);
        });
      }
    }
    if (ready && previousJoinedNS && previousJoinedNS !== joinedNS && isMounted.current) {
      setT(getNewT);
    }
    const boundReset = () => {
      if (isMounted.current) setT(getNewT);
    };
    if (bindI18n && i18n) i18n.on(bindI18n, boundReset);
    if (bindI18nStore && i18n) i18n.store.on(bindI18nStore, boundReset);
    return () => {
      isMounted.current = false;
      if (bindI18n && i18n) bindI18n.split(' ').forEach(e => i18n.off(e, boundReset));
      if (bindI18nStore && i18n) bindI18nStore.split(' ').forEach(e => i18n.store.off(e, boundReset));
    };
  }, [i18n, joinedNS]);
  SP_REACT.useEffect(() => {
    if (isMounted.current && ready) {
      setT(getT);
    }
  }, [i18n, keyPrefix, ready]);
  const ret = [t, i18n, ready];
  ret.t = t;
  ret.i18n = i18n;
  ret.ready = ready;
  if (ready) return ret;
  if (!ready && !useSuspense) return ret;
  throw new Promise(resolve => {
    if (props.lng) {
      loadLanguages(i18n, props.lng, namespaces, () => resolve());
    } else {
      loadNamespaces(i18n, namespaces, () => resolve());
    }
  });
};

var translation$a = {
	battery_left: "Left",
	battery_right: "Right",
	battery_case: "Case",
	battery_single: "Charge",
	capabilities_noise_control_label: "Noise control",
	websocket_connection_issue: "Something went wrong, try reloading",
	headphones_disconnected: "Connect headphones to display their battery level and adjust settings",
	settings_low_battery_label: "Low battery notification",
	settings_low_battery_label_notchlabel_off: "Off",
	settings_language_button_label: "Language",
	settings_language_menu_label: "Choose language",
	settings_language_menu_canceltext: "Cancel",
	settings_hotkey_anc_label: "Switch noise cancellation hotkey",
	settings_hotkey_anc_description: "Press <key1/> + <key2/> to switch between noise cancelling modes",
	settings_hotkey_mic_label: "Mute microphone hotkey",
	settings_hotkey_mic_description: "Press <key1/> + <key2/> to mute/unmute microphone",
	settings_fix_disconnects_label: "Disable headphone standby mode",
	settings_fix_disconnects_description: "Fixes the problem of endless connect/disconnect headphones",
	settings_header: "Settings",
	settings_misc_header: "Useful links",
	settings_anc_modes_header: "Displayed modes",
	settings_anc_modes_off_label: "<icon/>Off",
	settings_anc_modes_transparency_label: "<icon/>Transparency",
	settings_anc_modes_adaptive_label: "<icon/>Adaptive",
	settings_anc_modes_wind_label: "<icon/>Wind cancellation",
	settings_anc_modes_anc_label: "<icon/>Noise cancellation",
	settings_social_button_description: "Show QR code",
	settings_social_button_start: "Getting started",
	settings_social_button_translate: "Translate",
	settings_social_button_donate: "Donate",
	settings_debug_header: "Debugging",
	settings_debug_level_label: "Log level",
	settings_debug_log_button: "Event Logs",
	bluetooth: "Bluetooth",
	headphones: "Headphones",
	notif_error_websocket_connection_issue: "Error! Open the plugin for more info",
	notif_low_battery: "{{battery}}% remaining. Charge your headphones.",
	capabilities_header: "Options",
	capabilities_modal: "Certain options may appear in the interface even if they are not supported by your headphones or the Steam Deck.",
	capabilities_aap_conversation_awareness_label: "Conversation awareness",
	capabilities_aap_conversation_awareness_volume_label: "Decrease volume by",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Off",
	capabilities_aap_personalized_volume_label: "Personalized volume",
	capabilities_aap_adaptive_audio_noise_label: "Adaptive mode",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "More noise",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Default",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "Less noise",
	capabilities_aap_anc_one_airpod_label: "ANC with one AirPod",
	capabilities_aap_press_and_hold_duration_label: "Press and hold duration",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Default",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Shorter",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Shortest",
	capabilities_aap_press_speed_label: "Press speed",
	capabilities_aap_press_speed_notchlabel_default: "Default",
	capabilities_aap_press_speed_notchlabel_slower: "Slower",
	capabilities_aap_press_speed_notchlabel_slowest: "Slowest",
	capabilities_aap_tone_volume_label: "Tone volume",
	capabilities_aap_volume_swipe_label: "Volume swipe",
	capabilities_aap_volume_swipe_length_label: "Volume swipe length",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Default",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Longer",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "Longest",
	capabilities_aap_end_call_label: "End call",
	capabilities_aap_end_call_notchlabel_single: "Press once",
	capabilities_aap_end_call_notchlabel_double: "Press twice",
	capabilities_aap_mute_unmute_label: "Mute and unmute",
	settings_hotkey_error: "<Key1/> Hotkeys are broken in all plugins due to a SteamOS update. No solution yet, hotkeys remain disabled."
};
var enUS = {
	translation: translation$a
};

var translation$9 = {
	battery_left: "Левый",
	battery_right: "Правый",
	battery_case: "Футляр",
	battery_single: "Заряд",
	capabilities_noise_control_label: "Управление шумом",
	websocket_connection_issue: "Что-то пошло не так, попробуйте перезагрузить",
	headphones_disconnected: "Подключите наушники, чтобы отобразить уровень заряда батареи и настроить параметры",
	settings_low_battery_label: "Уведомление о низком заряде",
	settings_low_battery_label_notchlabel_off: "Выкл.",
	settings_language_button_label: "Язык",
	settings_language_menu_label: "Выберите язык",
	settings_language_menu_canceltext: "Отмена",
	settings_hotkey_anc_label: "Горячая клавиша переключения режимов шумоподавления",
	settings_hotkey_anc_description: "Нажмите <key1/> + <key2/> для переключения между режимами шумоподавления",
	settings_hotkey_mic_label: "Горячая клавиша отключения микрофона",
	settings_hotkey_mic_description: "Нажмите <key1/> + <key2/> для отключения/включения микрофона",
	settings_fix_disconnects_label: "Отключить режим ожидания наушников",
	settings_fix_disconnects_description: "Решает проблему бесконечного подключения/отключения наушников",
	bluetooth: "Bluetooth",
	headphones: "Наушники",
	notif_error_websocket_connection_issue: "Ошибка! Откройте плагин для подробностей",
	notif_low_battery: "Осталось {{battery}}%. Зарядите ваши наушники.",
	settings_anc_modes_transparency_label: "<icon/>Прозрачность",
	settings_anc_modes_adaptive_label: "<icon/>Адаптивно",
	settings_anc_modes_wind_label: "<icon/>Подавление шума ветра",
	settings_anc_modes_anc_label: "<icon/>Шумоподавление",
	settings_anc_modes_off_label: "<icon/>Выключено",
	settings_debug_header: "Отладка",
	settings_debug_level_label: "Уровень журналирования",
	settings_debug_log_button: "Журнал событий",
	settings_social_button_donate: "Пожертвовать",
	settings_anc_modes_header: "Отображаемые режимы",
	settings_social_button_description: "Показать QR-код",
	settings_social_button_start: "Начало работы",
	settings_header: "Настройки",
	settings_misc_header: "Полезные ссылки",
	settings_social_button_translate: "Перевести",
	capabilities_aap_press_and_hold_duration_label: "Нажатие и удерживание",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "По умолчанию",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Быстрее",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Очень быстро",
	capabilities_aap_press_speed_label: "Нажатие",
	capabilities_aap_press_speed_notchlabel_default: "По умолчанию",
	capabilities_aap_press_speed_notchlabel_slower: "Медленнее",
	capabilities_aap_press_speed_notchlabel_slowest: "Очень медленно",
	capabilities_aap_tone_volume_label: "Громкость тона",
	capabilities_header: "Настройки",
	capabilities_aap_conversation_awareness_volume_label: "Уменьшить громкость на",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Выкл.",
	capabilities_aap_conversation_awareness_label: "Распознавание разговора",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "По умолчанию",
	capabilities_aap_volume_swipe_length_notchlabel_default: "По умолчанию",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Длиннее",
	capabilities_modal: "Некоторые настройки могут отображаться в интерфейсе, даже если они не поддерживаются вашими наушниками или Steam Deck.",
	capabilities_aap_personalized_volume_label: "Индивидуальная громкость",
	capabilities_aap_adaptive_audio_noise_label: "Адаптивный режим",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "Больше шума",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "Меньше шума",
	capabilities_aap_anc_one_airpod_label: "Шумопод. с одним AirPod",
	capabilities_aap_volume_swipe_label: "Изменение громкости смахиванием",
	capabilities_aap_volume_swipe_length_label: "Длина смахивания",
	capabilities_aap_end_call_label: "Завершить вызов",
	capabilities_aap_end_call_notchlabel_single: "Одиночное нажатие",
	capabilities_aap_mute_unmute_label: "Вкл. и выкл. звука",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "Очень длинно",
	capabilities_aap_end_call_notchlabel_double: "Двойное нажатие",
	settings_hotkey_error: "<Key1/> Обновление SteamOS сломало работу горячих клавиш во всех плагинах. Пока решение не найдено, горячие клавиши остаются отключены."
};
var ruRU = {
	translation: translation$9
};

var translation$8 = {
	battery_left: "左",
	battery_right: "右",
	battery_case: "充电盒",
	battery_single: "已充电",
	capabilities_noise_control_label: "噪音控制",
	websocket_connection_issue: "出错了，请尝试刷新",
	headphones_disconnected: "连接耳机以查看电池电量和调整设置",
	settings_low_battery_label: "低电量提醒",
	settings_low_battery_label_notchlabel_off: "关闭",
	settings_language_button_label: "语言",
	settings_language_menu_label: "选择语言",
	settings_language_menu_canceltext: "取消",
	settings_hotkey_anc_label: "切换降噪快捷键",
	settings_hotkey_anc_description: "按下 <key1/> + <key2/> 可切换降噪模式",
	settings_fix_disconnects_label: "禁用耳机待机模式",
	settings_fix_disconnects_description: "修复了无休止地连接/断开耳机的问题",
	settings_hotkey_mic_label: "麦克风静音热键",
	settings_hotkey_mic_description: "按 <key1/> + <key2/> 关闭/打开麦克风",
	bluetooth: "蓝牙",
	headphones: "耳机",
	notif_error_websocket_connection_issue: "错误！打开插件获取更多信息",
	notif_low_battery: "电量剩余 {{battery}}%，请为您的耳机充电。",
	settings_anc_modes_transparency_label: "<icon/>通透模式",
	settings_anc_modes_off_label: "<icon/>关闭",
	settings_anc_modes_adaptive_label: "<icon/>自适应",
	settings_anc_modes_wind_label: "<icon/>风力消除",
	settings_anc_modes_anc_label: "<icon/>噪音消除",
	settings_misc_header: "实用链接",
	settings_social_button_translate: "翻译",
	settings_debug_level_label: "日志级别",
	settings_debug_log_button: "事件日志",
	settings_debug_header: "调试",
	settings_social_button_start: "入门指南",
	settings_header: "设置",
	settings_anc_modes_header: "可显示模式",
	settings_social_button_description: "显示二维码",
	settings_social_button_donate: "捐赠",
	capabilities_aap_conversation_awareness_label: "对话感知",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "默认",
	capabilities_aap_press_and_hold_duration_label: "按住时长",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "默认",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "较短",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "最短",
	capabilities_aap_press_speed_label: "按压速度",
	capabilities_aap_personalized_volume_label: "个性化音量",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "关",
	capabilities_aap_press_speed_notchlabel_default: "默认",
	capabilities_aap_press_speed_notchlabel_slower: "慢点",
	capabilities_aap_press_speed_notchlabel_slowest: "最慢",
	capabilities_aap_tone_volume_label: "音量",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "更长",
	capabilities_aap_volume_swipe_length_notchlabel_default: "默认",
	capabilities_header: "选项",
	capabilities_modal: "即使某些选项不受您的耳机或 Steam Deck 支持，它们仍可能出现在界面中。",
	capabilities_aap_conversation_awareness_volume_label: "将音量降低",
	capabilities_aap_adaptive_audio_noise_label: "自适应模式",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "更多噪音",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "更少噪音",
	capabilities_aap_anc_one_airpod_label: "使用一只 AirPod 消除噪音",
	capabilities_aap_volume_swipe_label: "音量滑动",
	capabilities_aap_volume_swipe_length_label: "音量滑动距离",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "最长",
	capabilities_aap_end_call_label: "结束通话",
	capabilities_aap_end_call_notchlabel_single: "按一次",
	capabilities_aap_end_call_notchlabel_double: "按两次",
	capabilities_aap_mute_unmute_label: "静音和取消静音"
};
var zhCN = {
	translation: translation$8
};

var translation$7 = {
	settings_hotkey_anc_label: "Touche pour la réduction du bruit",
	battery_case: "Boîtier",
	battery_single: "Batterie",
	capabilities_noise_control_label: "Contrôle du bruit",
	settings_low_battery_label: "Avertissement de batterie faible",
	settings_low_battery_label_notchlabel_off: "Désactivé",
	settings_language_button_label: "Langue",
	settings_language_menu_canceltext: "Annuler",
	headphones: "Écouteurs",
	settings_hotkey_anc_description: "Appuyez sur <key1/> + <key2/> pour basculer entre les modes de réduction du bruit",
	notif_low_battery: "{{battery}}% restant. Rechargez vos écouteurs.",
	websocket_connection_issue: "Quelque chose s'est mal déroulé, réessayez",
	headphones_disconnected: "Connectez des écouteurs pour afficher leurs niveaux de batteries et ajuster leurs paramètres",
	settings_language_menu_label: "Choisissez la langue",
	settings_fix_disconnects_description: "Résout le problème de connexion/déconnexion sans fin des écouteurs",
	bluetooth: "Bluetooth",
	battery_left: "Gauche",
	battery_right: "Droit",
	settings_fix_disconnects_label: "Désactiver le mode veille des écouteurs",
	notif_error_websocket_connection_issue: "Erreur ! Ouvrez le plugin pour plus d'informations",
	settings_hotkey_mic_label: "Touche de raccourci pour couper le microphone",
	settings_hotkey_mic_description: "Appuyez sur <key1/> + <key2/> pour couper ou rétablir le microphone",
	settings_anc_modes_transparency_label: "<icon/>Transparence",
	settings_anc_modes_adaptive_label: "<icon/>Adaptatif",
	settings_anc_modes_wind_label: "<icon/>Réduction du bruit du vent",
	settings_anc_modes_anc_label: "<icon/>Réduction du bruit",
	settings_anc_modes_off_label: "<icon/>Désactivé",
	settings_header: "Paramètres",
	settings_misc_header: "Liens utiles",
	settings_anc_modes_header: "Modes affichés",
	settings_social_button_description: "Afficher le code QR",
	settings_social_button_start: "Premiers pas",
	settings_social_button_translate: "Traduire",
	settings_social_button_donate: "Faire un don",
	settings_debug_header: "Débogage",
	settings_debug_level_label: "Niveau de journalisation",
	settings_debug_log_button: "Journaux d'événements",
	capabilities_aap_conversation_awareness_label: "Détection de conversation",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Par défaut",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Par défaut",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Plus court",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Le plus court",
	capabilities_aap_press_speed_label: "Vitesse d'appui",
	capabilities_aap_press_speed_notchlabel_default: "Par défaut",
	capabilities_aap_press_speed_notchlabel_slower: "Plus lent",
	capabilities_aap_press_speed_notchlabel_slowest: "Le plus lent",
	capabilities_aap_tone_volume_label: "Volume des tonalités",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Par défaut",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Long",
	capabilities_aap_personalized_volume_label: "Volume personnalisé",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Désactivé",
	capabilities_aap_press_and_hold_duration_label: "Durée de pression et maintien",
	capabilities_aap_mute_unmute_label: "Mettre en sourdine et rétablir le son",
	capabilities_aap_end_call_label: "Terminer l'appel",
	capabilities_aap_anc_one_airpod_label: "Annulation du bruit avec un seul AirPod",
	capabilities_aap_end_call_notchlabel_single: "Appuyez une fois",
	capabilities_aap_end_call_notchlabel_double: "Appuyez deux fois",
	capabilities_header: "Options",
	capabilities_modal: "Certaines options peuvent apparaître sur l'interface même si elles ne sont pas supporté par vos écouteurs ou le Steam Deck.",
	capabilities_aap_conversation_awareness_volume_label: "Diminuer le volume de",
	capabilities_aap_adaptive_audio_noise_label: "Mode adaptatif",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "Le plus long",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "Plus de bruit",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "Moins de bruits",
	capabilities_aap_volume_swipe_label: "Faites glisser pour changer le volume",
	capabilities_aap_volume_swipe_length_label: "Longueur de la barre de volume"
};
var frFR = {
	translation: translation$7
};

var translation$6 = {
	settings_language_menu_canceltext: "Abbrechen",
	settings_fix_disconnects_label: "Deaktiviere Kopfhörer Ruhemodus",
	headphones: "Kopfhörer",
	notif_error_websocket_connection_issue: "Fehler! Öffne das Plugin für weitere Infos",
	notif_low_battery: "{{battery}}% verbleibend. Lade deine Kopfhörer.",
	battery_left: "Links",
	capabilities_noise_control_label: "Geräuschkontrolle",
	bluetooth: "Bluetooth",
	battery_right: "Rechts",
	battery_case: "Case",
	battery_single: "Akkustand",
	websocket_connection_issue: "Etwas ist schiefgelaufen, versuche neu zu laden",
	settings_low_battery_label: "Benachrichtigung bei niedrigem Akkustand",
	settings_low_battery_label_notchlabel_off: "Aus",
	settings_language_button_label: "Sprache",
	settings_language_menu_label: "Sprache auswählen",
	settings_hotkey_anc_description: "Drücke <key1/> + <key2/>, um den Modus der Geräuschunterdrückung zu wechseln",
	headphones_disconnected: "Verbinde Kopfhörer um ihren Akkustand anzuzeigen und Einstellungen anzupassen",
	settings_hotkey_mic_label: "Stummschaltung Tastenkombination",
	settings_hotkey_mic_description: "Drücke <key1/> + <key2/>, um die Stummschaltung zu (de-)aktivieren",
	settings_hotkey_anc_label: "Tastenkombination für Modus Wechsel",
	settings_fix_disconnects_description: "Löst das Problem der konstanten Verbindung/Trennung der Kopfhörer",
	settings_anc_modes_off_label: "<icon/>Aus",
	settings_anc_modes_transparency_label: "<icon/>Transparenzmodus",
	settings_anc_modes_adaptive_label: "<icon/>Adaptiv",
	settings_anc_modes_anc_label: "<icon/>Geräuschunterdrückung",
	settings_anc_modes_wind_label: "<icon/>Windgeräuschunterdrückung",
	settings_anc_modes_header: "Anzeigemodi",
	settings_social_button_description: "QR-Code anzeigen",
	settings_debug_header: "Fehlersuche",
	settings_social_button_donate: "Spenden",
	settings_misc_header: "Nützliche Links",
	settings_social_button_start: "Erste Schritte",
	settings_social_button_translate: "Übersetzen",
	settings_debug_level_label: "Protokollebene",
	settings_debug_log_button: "Ereignisprotokolle",
	settings_header: "Einstellungen",
	capabilities_aap_conversation_awareness_label: "Konversationserkennung",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Aus",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Standard",
	capabilities_aap_press_and_hold_duration_label: "Drück- und Haltedauer",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Standard",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Kürzer",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Am kürzesten",
	capabilities_aap_press_speed_label: "Druck Geschwindigkeit",
	capabilities_aap_press_speed_notchlabel_default: "Standard",
	capabilities_aap_press_speed_notchlabel_slower: "Langsamer",
	capabilities_aap_press_speed_notchlabel_slowest: "Am langsamsten",
	capabilities_aap_tone_volume_label: "Signalton Lautstärke",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Standard",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Länger",
	capabilities_aap_personalized_volume_label: "Personalisierte Lautstärke",
	capabilities_aap_mute_unmute_label: "Stumm oder Ton ein",
	capabilities_aap_anc_one_airpod_label: "Geräuschunterdrückung mit einem AirPod",
	capabilities_aap_end_call_label: "Anruf beenden",
	capabilities_aap_end_call_notchlabel_single: "Einmal drücken",
	capabilities_header: "Optionen",
	capabilities_modal: "Bestimmte Optionen können in der Benutzeroberfläche angezeigt werden, auch wenn sie von deinen Kopfhörern oder Steam Deck nicht unterstützt werden.",
	capabilities_aap_conversation_awareness_volume_label: "Lautstärke verringern um",
	capabilities_aap_adaptive_audio_noise_label: "Adaptiver Modus",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "Mehr Umgebungsgeräusche",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "Weniger Umgebungsgeräusche",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "am längsten",
	capabilities_aap_end_call_notchlabel_double: "Drücke zweimal",
	capabilities_aap_volume_swipe_label: "Lautstärkenregler",
	capabilities_aap_volume_swipe_length_label: "Lautstärkenregellänge"
};
var deDE = {
	translation: translation$6
};

var translation$5 = {
	battery_right: "Derecha",
	battery_single: "Carga",
	battery_case: "Caja",
	websocket_connection_issue: "Algo salió mal, intenta volver a intentar",
	settings_low_battery_label: "Notificación de batería baja",
	settings_language_button_label: "Idioma",
	settings_language_menu_label: "Elige lengua",
	settings_language_menu_canceltext: "Cancelar",
	settings_hotkey_anc_label: "Interruptor tecla de supresión de ruido",
	settings_hotkey_mic_label: "Tecla de acceso rápido para silenciar el micrófono",
	settings_fix_disconnects_description: "Soluciona el problema interminablementede conectar/desconectar los auriculares",
	headphones: "Auriculares",
	battery_left: "Izquierda",
	headphones_disconnected: "Conecte auriculares para mostrar el nivel de batería y ajustar la configuración",
	settings_fix_disconnects_label: "Desactivar el modo de espera de los auriculares",
	bluetooth: "Bluetooth",
	settings_hotkey_anc_description: "Presione <key1/> + <key2/> para cambiar entre los modos de cancelación de ruido",
	settings_hotkey_mic_description: "Presione <key1/> + <key2/> para silenciar/activar el micrófono",
	notif_low_battery: "{{battery}}% restante. Cargue sus auriculares.",
	notif_error_websocket_connection_issue: "¡Error! Abra el complemento para obtener más información",
	capabilities_noise_control_label: "Control de ruido",
	settings_low_battery_label_notchlabel_off: "Apagado",
	settings_anc_modes_adaptive_label: "<icon/>Adaptativo",
	settings_anc_modes_wind_label: "<icon/>Cancelación de viento",
	settings_anc_modes_off_label: "<icon/>Apagado",
	settings_anc_modes_transparency_label: "<icon/>Transparencia",
	settings_anc_modes_anc_label: "<icon/>Cancelación de Ruido",
	settings_header: "Ajustes",
	settings_social_button_description: "Mostrar código QR",
	settings_debug_log_button: "Registros de eventos",
	settings_social_button_start: "Comenzando",
	settings_social_button_translate: "Traducir",
	settings_social_button_donate: "Donar",
	settings_debug_header: "Depuración",
	settings_debug_level_label: "Nivel de registro",
	settings_misc_header: "Enlaces útiles",
	settings_anc_modes_header: "Modos mostrados",
	capabilities_aap_conversation_awareness_label: "Detección de conversación",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Por omisión",
	capabilities_aap_press_and_hold_duration_label: "Duración de mantener pulsado",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Por omisión",
	capabilities_aap_personalized_volume_label: "Volumen personalizado",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Corta",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Muy corta",
	capabilities_aap_press_speed_label: "Velocidad de presionado",
	capabilities_aap_press_speed_notchlabel_default: "Por omisión",
	capabilities_aap_press_speed_notchlabel_slower: "Lenta",
	capabilities_aap_press_speed_notchlabel_slowest: "Muy lenta",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Por omisión",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Largo",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Apagado",
	capabilities_aap_tone_volume_label: "Volumen del tono",
	capabilities_aap_anc_one_airpod_label: "Cancelación de ruido con un AirPod",
	capabilities_aap_end_call_label: "Finalizar llamada",
	capabilities_aap_mute_unmute_label: "Silenciar y activar sonido",
	capabilities_header: "Opciones",
	capabilities_modal: "Ciertas opciones pueden aparecer en la interfaz, aunque no sean compatible con sus auriculares o con la Steam Deck.",
	capabilities_aap_conversation_awareness_volume_label: "Disminuir volumen en",
	capabilities_aap_adaptive_audio_noise_label: "Modo adaptativo",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "Más ruido",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "Menos ruido",
	capabilities_aap_volume_swipe_label: "Deslizar para volumen",
	capabilities_aap_volume_swipe_length_label: "Longitud del deslizamiento de volumen",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "Más largo",
	capabilities_aap_end_call_notchlabel_single: "Presione una vez",
	capabilities_aap_end_call_notchlabel_double: "Presione dos veces"
};
var esES = {
	translation: translation$5
};

var translation$4 = {
	battery_case: "Estojo",
	battery_single: "Carga",
	websocket_connection_issue: "Aconteceu algo errado, tente recarregar",
	battery_left: "Esquerdo",
	battery_right: "Direito",
	capabilities_noise_control_label: "Controle de ruído",
	headphones_disconnected: "Conecte os fones para visualizar o nível de bateria e ajustar configurações",
	settings_low_battery_label_notchlabel_off: "Desl.",
	settings_language_button_label: "Idioma",
	settings_language_menu_label: "Escolha o idioma",
	settings_language_menu_canceltext: "Cancelar",
	settings_hotkey_anc_label: "Teclas de atalho para troca de cancelamento de ruído",
	settings_hotkey_anc_description: "Pressione <key1/> + <key2/> para alternar entre os modos de cancelamento de ruído",
	settings_hotkey_mic_label: "Tecla de atalho para microfone mudo",
	settings_hotkey_mic_description: "Pressione <key1/> + <key2/> para ativar/desativar mudo do microfone",
	settings_fix_disconnects_label: "Desabilitar modo de standby do fone",
	settings_fix_disconnects_description: "Corrige o problema do fone conectar/desconectar infinitamente",
	bluetooth: "Bluetooth",
	headphones: "Fones de ouvido",
	notif_error_websocket_connection_issue: "Erro! Abra o plugin para mais informações",
	notif_low_battery: "{{battery}}% de carga. Recarregue os fones de ouvido.",
	settings_low_battery_label: "Notificação de bateria fraca",
	settings_anc_modes_transparency_label: "<icon/>Transparência",
	settings_anc_modes_adaptive_label: "<icon/>Adaptativo",
	settings_anc_modes_wind_label: "<icon/>Cancelamento de vento",
	settings_anc_modes_anc_label: "<icon/>Cancelamento de ruído",
	settings_anc_modes_off_label: "<icon/>Desligado",
	settings_header: "Configurações",
	settings_misc_header: "Links úteis",
	settings_anc_modes_header: "Modos exibidos",
	settings_social_button_description: "Mostrar código QR",
	settings_social_button_start: "Primeiros passos",
	settings_debug_header: "Depuração",
	settings_social_button_translate: "Traduzir",
	settings_social_button_donate: "Doar",
	settings_debug_level_label: "Nível de log",
	settings_debug_log_button: "Registros de eventos",
	capabilities_aap_conversation_awareness_label: "Detecção de conversa",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Padrão",
	capabilities_aap_press_and_hold_duration_label: "Duração para manter pressionado",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Padrão",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Curta",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Mais Curta",
	capabilities_aap_press_speed_label: "Velocidade para pressionar",
	capabilities_aap_press_speed_notchlabel_slower: "Mais devagar",
	capabilities_aap_press_speed_notchlabel_slowest: "Mais lento",
	capabilities_aap_tone_volume_label: "Volume do Toque",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Padrão",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Longo",
	capabilities_aap_personalized_volume_label: "Volume personalizado",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Desl.",
	capabilities_aap_press_speed_notchlabel_default: "Padrão",
	capabilities_aap_mute_unmute_label: "Silenciar e ativar som",
	capabilities_aap_anc_one_airpod_label: "Cancelamento de ruído com um AirPod",
	capabilities_aap_end_call_label: "Encerrar chamada"
};
var ptBr = {
	translation: translation$4
};

var translation$3 = {
	capabilities_noise_control_label: "Έλεγχος θορύβου",
	settings_language_menu_canceltext: "Ακύρωση",
	battery_left: "Αριστερό",
	settings_hotkey_anc_label: "Πλήκτρο(α) συντόμευσης ακύρωσης θορύβου",
	battery_right: "Δεξί",
	battery_case: "Θήκη",
	battery_single: "Φόρτιση",
	websocket_connection_issue: "Κάτι πήγε στραβά, δοκιμάστε να επαναφορτώσετε",
	headphones_disconnected: "Συνδέστε τα ακουστικά για να προβάλετε το επίπεδο της μπαταρίας και να προσαρμόσετε τις ρυθμίσεις",
	settings_low_battery_label: "Ειδοποίηση χαμηλής μπαταρίας",
	settings_low_battery_label_notchlabel_off: "Ανενεργό",
	settings_language_button_label: "Γλώσσα",
	settings_language_menu_label: "Διαλέξτε γλώσσα",
	settings_hotkey_anc_description: "Πατήστε <key1/> + <key2/> για να κάνετε εναλλαγή μεταξύ λειτουργιών ακυρώσεως θορύβου",
	settings_fix_disconnects_description: "Διορθώνει το πρόβλημα των ατελείωτων επανασυνδέσεων των ακουστικών λόγω αδράνειας",
	headphones: "Ακουστικά",
	notif_low_battery: "Απομένει {{battery}}%. Παρακαλώ φορτίστε τα ακουστικά σας.",
	settings_hotkey_mic_label: "Πλήκτρο συντόμευσης σίγασης μικροφώνου",
	settings_fix_disconnects_label: "Απενεργοποίηση λειτουργία αναμονής ακουστικών",
	bluetooth: "Bluetooth",
	notif_error_websocket_connection_issue: "Σφάλμα! Ανοίξτε την προσθήκη για περισσότερες πληροφορίες",
	settings_hotkey_mic_description: "Πατήστε <key1/> + <key2/> για να κάνετε σίγαση/ τέλος σίγασης μικροφώνου",
	settings_anc_modes_off_label: "<icon/>Ανενεργό",
	settings_anc_modes_adaptive_label: "<icon/>Προσαρμοστικό",
	settings_anc_modes_transparency_label: "<icon/>Διαφάνεια",
	settings_anc_modes_wind_label: "<icon/>Ακύρωση θορύβου ανέμου",
	settings_anc_modes_anc_label: "<icon/>Ακύρωση Θορύβου",
	settings_header: "Ρυθμίσεις",
	settings_misc_header: "Χρήσιμοι σύνδεσμοι",
	settings_social_button_description: "Εμφάνιση κωδικού QR",
	settings_social_button_start: "Ξεκινώντας",
	settings_anc_modes_header: "Εμφανιζόμενες λειτουργίες",
	settings_social_button_translate: "Μετάφραση",
	settings_social_button_donate: "Κάντε δωρεά",
	settings_debug_header: "Εντοπισμός σφαλμάτων",
	settings_debug_log_button: "Συμβάντα",
	settings_debug_level_label: "Επίπεδο καταγραφής",
	capabilities_aap_conversation_awareness_label: "Αναγνώριση συζητήσεων",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "Προεπιλογή",
	capabilities_aap_press_and_hold_duration_label: "Διάρκεια παρατεταμένου πατήματος",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "Προεπιλογή",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Σύντομο",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Πολύ σύντομο",
	capabilities_aap_press_speed_label: "Ταχύτητα πατήματος",
	capabilities_aap_press_speed_notchlabel_default: "Προεπιλογή",
	capabilities_aap_press_speed_notchlabel_slower: "Αργό",
	capabilities_aap_press_speed_notchlabel_slowest: "Πολύ Αργό",
	capabilities_aap_volume_swipe_length_notchlabel_default: "Προεπιλογή",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Παρατεταμένο",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Απενεργοποιημένο",
	capabilities_aap_tone_volume_label: "Ένταση ηχητικών εφέ",
	capabilities_aap_personalized_volume_label: "Προσωποποιημένη ένταση",
	capabilities_aap_anc_one_airpod_label: "Ακύρωση θορύβου με ένα AirPod",
	capabilities_aap_end_call_label: "Τέλος κλήσης",
	capabilities_aap_mute_unmute_label: "Σίγαση και τέλος σίγασης"
};
var elGr = {
	translation: translation$3
};

var translation$2 = {
	battery_right: "오른쪽",
	battery_case: "케이스",
	battery_left: "왼쪽",
	capabilities_noise_control_label: "소음 제어",
	settings_low_battery_label: "배터리 부족 알림",
	settings_low_battery_label_notchlabel_off: "끔",
	settings_language_button_label: "언어",
	battery_single: "잔량",
	settings_language_menu_canceltext: "취소",
	settings_hotkey_anc_label: "노이즈 캔슬링 단축키 전환",
	settings_language_menu_label: "언어 선택",
	settings_hotkey_anc_description: "<key1/> + <key2/> 를 눌러 노이즈 캔슬링모드로 전환합니다",
	settings_hotkey_mic_label: "마이크 음소거 단축키",
	settings_hotkey_mic_description: "<key1/> + <key2/> 를 눌러 마이크를 음소거/해제 합니다",
	settings_fix_disconnects_label: "헤드셋 스탠바이 모드 비활성화",
	bluetooth: "Bluetooth",
	headphones: "헤드폰",
	settings_fix_disconnects_description: "헤드폰이 끝없이 연결/분리되는 문제를 수정합니다",
	notif_error_websocket_connection_issue: "오류가 발생했습니다! 플러그인을 열어 자세한 정보를 확인하세요",
	notif_low_battery: "배터리가 {{battery}}% 남았습니다. 헤드폰을 충전해주세요.",
	websocket_connection_issue: "무엇인가가 잘못되었습니다, 다시 시도해주세요",
	headphones_disconnected: "헤드폰을 연결하여 배터리 잔량을 표시하고 설정을 조정하세요",
	settings_anc_modes_adaptive_label: "<icon/>적응형 오디오",
	settings_anc_modes_off_label: "<icon/>끔",
	settings_anc_modes_wind_label: "<icon/>바람 차단",
	settings_anc_modes_transparency_label: "<icon/>주변음 허용",
	settings_anc_modes_anc_label: "<icon/>노이즈 캔슬링",
	settings_misc_header: "유용한 링크",
	settings_header: "설정",
	settings_social_button_description: "QR 코드 표시",
	settings_debug_header: "디버깅",
	settings_debug_level_label: "로그 수준",
	settings_social_button_donate: "기부하기",
	settings_anc_modes_header: "표시된 모드",
	settings_social_button_start: "시작하기",
	settings_social_button_translate: "번역하기",
	settings_debug_log_button: "이벤트 로그",
	capabilities_aap_conversation_awareness_label: "대화 인지",
	capabilities_aap_personalized_volume_label: "개인 맞춤형 음량",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "기본",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "더 짧게",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "가장 짧게",
	capabilities_aap_press_speed_label: "누르기 속도",
	capabilities_aap_press_speed_notchlabel_default: "기본",
	capabilities_aap_press_speed_notchlabel_slower: "느리게",
	capabilities_aap_press_speed_notchlabel_slowest: "가장 느리게",
	capabilities_aap_tone_volume_label: "톤 음량",
	capabilities_aap_volume_swipe_length_notchlabel_default: "기본",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "길게",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "끔",
	capabilities_aap_press_and_hold_duration_label: "길게 누르기 지속 시간",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "기본",
	capabilities_aap_end_call_label: "통화 종료하기",
	capabilities_aap_mute_unmute_label: "음소거",
	capabilities_aap_anc_one_airpod_label: "AIrPods 한 개 착용 시 노이즈 캔슬링",
	capabilities_header: "옵션들",
	capabilities_modal: "특정 옵션은 헤드폰이나 Steam Deck에서 지원되지 않더라도 인터페이스에 표시될 수 있습니다.",
	capabilities_aap_conversation_awareness_volume_label: "볼륨 감소",
	capabilities_aap_adaptive_audio_noise_label: "적응형 모드",
	capabilities_aap_adaptive_audio_noise_notchlabel_more: "더 큰 노이즈",
	capabilities_aap_adaptive_audio_noise_notchlabel_less: "적은 노이즈",
	capabilities_aap_volume_swipe_label: "볼륨 스와이프",
	capabilities_aap_volume_swipe_length_label: "볼륨 스와이프 길이",
	capabilities_aap_volume_swipe_length_notchlabel_longest: "최대",
	capabilities_aap_end_call_notchlabel_single: "1회 누르기",
	capabilities_aap_end_call_notchlabel_double: "2회 누르기"
};
var koKR = {
	translation: translation$2
};

var translation$1 = {
	battery_right: "දකුණ",
	battery_case: "කවරය",
	battery_single: "ආ‍ර‍ෝපණය",
	headphones_disconnected: "හෙඩ්ෆෝන් ඔවුන්ගේ බැටරි මට්ටම ප්රදර්ශනය කර සැකසුම් සකස් කරන්න",
	settings_low_battery_label: "අඩු බැටරි දැනුම්දීම",
	settings_language_button_label: "භාෂාව",
	settings_language_menu_label: "භාෂාව තෝරන්න",
	settings_language_menu_canceltext: "අවලංගු කරන්න",
	settings_hotkey_anc_label: "ශබ්දය අවලංගු කිරීමේ හොට්කි මාරු කරන්න",
	settings_hotkey_mic_label: "නිශ්ශබ්ද මයික්රොෆෝන් හොට්කි",
	settings_fix_disconnects_label: "හෙඩ්ෆෝන් ස්ටෝන් ප්රකාරය අක්රීය කරන්න",
	settings_fix_disconnects_description: "නිමක් නැති සම්බන්ධක / විසන්ධි කිරීමේ හෙඩ්ෆෝන් වල ගැටළුව විසඳයි",
	bluetooth: "බ්ලූටූත්",
	headphones: "හෙඩ්ෆෝන්",
	notif_low_battery: "{{battery}}% ඉතිරිව ඇත. ඔබේ හෙඩ්ෆෝන් ආරෝපණය කරන්න.",
	battery_left: "වම",
	websocket_connection_issue: "යමක් වැරදී, නැවත පූරණය කිරීමට උත්සාහ කරන්න",
	capabilities_noise_control_label: "ශබ්ද පාලනය",
	settings_low_battery_label_notchlabel_off: "අක්රියයි",
	settings_hotkey_anc_description: "ශබ්ද අවලංගු කිරීමේ මාතයන් අතර මාරුවීමට <key1/> + <key2/> ඔබන්න",
	settings_hotkey_mic_description: "මයික්රොෆෝනය නිශ්ශබ්ද / නිශ්ශබ්ද නොවීමට <key1/> + <key2/> ඔබන්න",
	notif_error_websocket_connection_issue: "දෝෂය! වැඩි විස්තර සඳහා ප්ලගිනය විවෘත කරන්න",
	settings_anc_modes_off_label: "<icon/>අක්රියයි",
	settings_header: "සැකසුම්",
	settings_anc_modes_transparency_label: "<icon/>පැහැදිලි බව",
	settings_social_button_description: "QR කේතය පෙන්වන්න",
	settings_social_button_start: "ආරම්භ කිරීම",
	settings_social_button_translate: "පරිවර්තනය කරන්න",
	settings_social_button_donate: "පරිත්‍යාග කරන්න",
	settings_anc_modes_adaptive_label: "<icon/>අනුරූපණශීලී",
	settings_anc_modes_wind_label: "<icon/>සුළඟ අහෝසි කිරීම",
	settings_anc_modes_anc_label: "<icon/>ශබ්ද අහෝසි කිරීම",
	settings_debug_header: "දෝෂ නිරාකරණය",
	settings_debug_log_button: "සිදුවීම් ලොග්",
	settings_anc_modes_header: "පෙන්වෙන ප්‍රකාර",
	settings_misc_header: "ප්‍රයෝජනවත් සබැඳි",
	settings_debug_level_label: "ලොග් මට්ටම",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "අක්රියයි"
};
var siLK = {
	translation: translation$1
};

var translation = {
	battery_left: "Лівий",
	headphones_disconnected: "Підключіть навушники, щоб побачити рівень заряду батареї та налаштувати параметри",
	notif_low_battery: "Залишилось {{battery}}%. Зарядіть ваші навушники.",
	settings_fix_disconnects_description: "Вирішує проблему нескінченного підключення/відключення навушників",
	capabilities_noise_control_label: "Керування шумом",
	settings_hotkey_anc_label: "Сполучення клавіш для зміни шумогасіння",
	battery_right: "Правий",
	battery_single: "Заряд",
	websocket_connection_issue: "Щось пішло не так, спробуйте перезавантажити",
	settings_low_battery_label: "Сповіщення про низький заряд батареї",
	settings_low_battery_label_notchlabel_off: "Вимк.",
	settings_language_button_label: "Мова",
	settings_language_menu_label: "Оберіть мову",
	settings_language_menu_canceltext: "Скасувати",
	battery_case: "Футляр",
	settings_hotkey_anc_description: "Натисніть <key1/> + <key2/> для перемикання між режимами шумогасіння",
	settings_hotkey_mic_label: "Сполучення клавіш для вимкнення мікрофона",
	settings_hotkey_mic_description: "Натисніть <key1/> + <key2/> щоб вимкнути/увімкнути мікрофон",
	settings_fix_disconnects_label: "Вимкнути режим очікування навушників",
	bluetooth: "Bluetooth",
	headphones: "Навушники",
	notif_error_websocket_connection_issue: "Помилка! Відкрийте плагін для детальної інформації",
	settings_anc_modes_transparency_label: "<icon/>Проникність",
	settings_anc_modes_adaptive_label: "<icon/>Адаптивно",
	settings_anc_modes_wind_label: "<icon/>Подавлення шуму вітру",
	settings_anc_modes_anc_label: "<icon/>Шумогасіння",
	settings_anc_modes_off_label: "<icon/>Вимкнено",
	settings_header: "Налаштування",
	settings_misc_header: "Корисні посилання",
	settings_anc_modes_header: "Відображувані режими",
	settings_social_button_description: "Показати QR-код",
	settings_debug_level_label: "Рівень журналювання",
	settings_debug_log_button: "Журнал подій",
	settings_social_button_donate: "Пожертвувати",
	settings_debug_header: "Зневадження",
	settings_social_button_start: "Початок роботи",
	settings_social_button_translate: "Перекласти",
	capabilities_aap_conversation_awareness_label: "Розпізнавання розмови",
	capabilities_aap_adaptive_audio_noise_notchlabel_default: "За замовчуванням",
	capabilities_aap_press_and_hold_duration_label: "Натиснення і утримування",
	capabilities_aap_press_and_hold_duration_notchlabel_default: "За замовчуванням",
	capabilities_aap_press_and_hold_duration_notchlabel_shorter: "Коротко",
	capabilities_aap_press_and_hold_duration_notchlabel_shortest: "Якомога коротше",
	capabilities_aap_press_speed_label: "Затримка у натисканнях",
	capabilities_aap_press_speed_notchlabel_default: "За замовчуванням",
	capabilities_aap_press_speed_notchlabel_slower: "Повільно",
	capabilities_aap_press_speed_notchlabel_slowest: "Якомога повільніше",
	capabilities_aap_tone_volume_label: "Гучність тону",
	capabilities_aap_volume_swipe_length_notchlabel_longer: "Довше",
	capabilities_aap_personalized_volume_label: "Адаптивна гучність",
	capabilities_aap_conversation_awareness_volume_label_notchlabel_off: "Вимкнено",
	capabilities_aap_volume_swipe_length_notchlabel_default: "За замовчуванням",
	capabilities_aap_anc_one_airpod_label: "Шумозаглушення із одним навушником AirPod",
	capabilities_aap_end_call_label: "Покласти слухавку",
	capabilities_aap_mute_unmute_label: "Увімк. і вимк. звуку"
};
var ukUA = {
	translation: translation
};

function initI18n() {
    instance
        .use(initReactI18next)
        //.use(LanguageDetector)
        .init({
        detection: {
            order: ['querystring', 'navigator'],
            lookupQuerystring: 'lng',
        },
        resources: {
            "en-US": enUS,
            "ru-RU": ruRU,
            "zh-CN": zhCN,
            "fr-FR": frFR,
            "de-DE": deDE,
            "es-ES": esES,
            "pt-BR": ptBr,
            "el-GR": elGr,
            "ko-KR": koKR,
            "si-LK": siLK,
            "uk-UA": ukUA
        },
        //debug: true,
        lng: navigator.language,
        //lng: "zh-CN",
        fallbackLng: "en-US",
    });
}

const Battery = ({ title, battery, isCharging, status }) => {
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null, status !== 0 && status !== 1 &&
        window.SP_REACT.createElement("div", { style: { display: "flex", padding: "0px 16px 0px 0px", minWidth: "76px", opacity: status === 3 ? "0.5" : "1" } },
            window.SP_REACT.createElement("div", null,
                window.SP_REACT.createElement("svg", { width: "16", height: "28", viewBox: "0 0 16 28", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                    window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M11 0H5V2H0V28H16V2H11V0ZM1.5 3.5H14.5V26.5H1.5V3.5Z", fill: "white" }),
                    window.SP_REACT.createElement("svg", { x: "3", y: "5", width: "10", height: "20" },
                        window.SP_REACT.createElement("rect", { height: "100%", width: "100%", fill: "#59BF40", transform: "translate(0," + (20 - Math.round(battery * 0.2)) + ")" })),
                    window.SP_REACT.createElement("svg", { x: "4.5", y: "10", width: "7", height: "10", viewBox: "0 0 7 10", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                        window.SP_REACT.createElement("path", { d: "M0 6.25L3.5 0V3.75H7L3.5 10V6.25H0Z", fill: isCharging ? 'white' : 'transparency' })))),
            window.SP_REACT.createElement("div", { style: { paddingLeft: "4px" } },
                window.SP_REACT.createElement("div", { className: DFL.gamepadSliderClasses.SliderNotchLabel, style: { paddingTop: "0px" } }, title),
                window.SP_REACT.createElement("div", { className: DFL.gamepadDialogClasses.FieldLabel, style: { fontWeight: "bold", lineHeight: "17px", paddingTop: "2px", fontSize: "20px" } },
                    battery,
                    "%")))));
};

const QUICK_ACCESS_MENU = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "1em", height: "1em", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32" },
        window.SP_REACT.createElement("rect", { width: "32", height: "32", fill: "none" }),
        window.SP_REACT.createElement("path", { d: "m7.31,8.66C3.28,8.66.02,11.95.02,16s3.26,7.34,7.29,7.34h17.42c4.03,0,7.29-3.28,7.29-7.34s-3.26-7.33-7.29-7.33H7.31Zm3.24,7.33c0,1.01-.82,1.83-1.82,1.83s-1.82-.82-1.82-1.83.82-1.83,1.82-1.83,1.82.82,1.82,1.83Zm5.47,1.83c1.01,0,1.82-.82,1.82-1.83s-.82-1.83-1.82-1.83-1.82.82-1.82,1.83.82,1.83,1.82,1.83Zm9.11-1.83c0,1.01-.82,1.83-1.82,1.83s-1.82-.82-1.82-1.83.82-1.83,1.82-1.83,1.82.82,1.82,1.83Z", "fill-rule": "evenodd", "clip-rule": "evenodd", fill: "currentColor" }));
};
const L5 = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "1em", height: "1em", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32" },
        window.SP_REACT.createElement("rect", { width: "32", height: "32", fill: "none" }),
        window.SP_REACT.createElement("path", { d: "m2,0C.9,0,0,.9,0,2v28c0,1.1.9,2,2,2h28c1.1,0,2-.9,2-2V2c0-1.1-.9-2-2-2H2Zm5.32,22h7.52v-2.11h-5.17v-9.09h-2.35v11.2Zm17.01-9.2v-2h-7.15v5.78l1.49.82c.33-.27.67-.46,1.01-.59.34-.14.71-.21,1.12-.21.54,0,.97.14,1.28.43.32.29.48.7.48,1.25,0,.62-.21,1.09-.62,1.42-.42.33-1,.5-1.76.5-1,0-1.91-.28-2.74-.83l-.83,1.79c.42.35.94.62,1.57.82.63.19,1.31.29,2.03.29.98,0,1.83-.17,2.54-.5.73-.34,1.27-.82,1.65-1.42.38-.61.58-1.32.58-2.13,0-1.09-.3-1.91-.91-2.48-.6-.58-1.4-.86-2.4-.86-.39,0-.79.05-1.18.14-.38.09-.73.22-1.04.42v-2.62h4.9Z", "fill-rule": "evenodd", "clip-rule": "evenodd", fill: "currentColor" }));
};
const L4 = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "1em", height: "1em", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32" },
        window.SP_REACT.createElement("rect", { width: "32", height: "32", fill: "none" }),
        window.SP_REACT.createElement("path", { d: "m2,0C.9,0,0,.9,0,2v28c0,1.1.9,2,2,2h28c1.1,0,2-.9,2-2V2c0-1.1-.9-2-2-2H2Zm5.67,22h7.52v-2.11h-5.17v-9.09h-2.35v11.2Zm16.61-4.35v-6.85h-2.18l-5.49,7.12v1.54h5.28v2.54h2.38v-2.54h1.62v-1.81h-1.62Zm-5.38,0l3.09-4.05v4.05h-3.09Z", "fill-rule": "evenodd", "clip-rule": "evenodd", fill: "currentColor" }));
};
//Icons for anc slider
const ANC_MODE_OFF = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M8.9948 5.9948C10.6545 4.33507 13.3455 4.33507 15.0052 5.9948C16.6649 7.65453 16.6649 10.3455 15.0052 12.0052C13.3455 13.6649 10.6545 13.6649 8.9948 12.0052C7.33507 10.3455 7.33507 7.65453 8.9948 5.9948ZM12 14.7578C9.86712 14.7578 7.7321 15.2735 6.10466 16.2209C4.48397 17.1644 3.25 18.6181 3.25 20.4998V21.4998C3.25 22.466 4.03379 23.2498 5 23.2498H19C19.9662 23.2498 20.75 22.466 20.75 21.4998V20.4998C20.75 18.6181 19.516 17.1644 17.8953 16.2209C16.2679 15.2735 14.1329 14.7578 12 14.7578Z", fill: "currentColor" }));
};
const ANC_MODE_TRANSPARENCY = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M11.4934 1.26437C11.661 1.25354 11.8299 1.24805 12 1.24805C12.1701 1.24805 12.339 1.25354 12.5066 1.26437C12.92 1.29108 13.2334 1.64782 13.2067 2.06117C13.18 2.47452 12.8232 2.78796 12.4099 2.76125C12.2745 2.7525 12.1378 2.74805 12 2.74805C11.8622 2.74805 11.7255 2.7525 11.5901 2.76125C11.1768 2.78796 10.82 2.47452 10.7933 2.06117C10.7666 1.64782 11.08 1.29108 11.4934 1.26437ZM14.4243 2.38631C14.6078 2.01495 15.0576 1.86264 15.4289 2.04612C15.7334 2.19656 16.0265 2.36635 16.3065 2.55386C16.6507 2.7843 16.743 3.25013 16.5125 3.59433C16.2821 3.93853 15.8163 4.03075 15.4721 3.80032C15.2461 3.64903 15.0098 3.51214 14.7645 3.39093C14.3931 3.20745 14.2408 2.75766 14.4243 2.38631ZM9.57571 2.38631C9.75919 2.75766 9.60689 3.20745 9.23553 3.39093C8.99021 3.51214 8.7539 3.64903 8.52793 3.80032C8.18373 4.03075 7.7179 3.93853 7.48746 3.59433C7.25703 3.25013 7.34925 2.7843 7.69345 2.55386C7.97354 2.36635 8.26662 2.19656 8.57108 2.04612C8.94244 1.86264 9.39223 2.01495 9.57571 2.38631ZM17.4037 4.48551C17.7479 4.25508 18.2137 4.3473 18.4442 4.6915C18.6317 4.97159 18.8015 5.26467 18.9519 5.56913C19.1354 5.94049 18.9831 6.39028 18.6117 6.57376C18.2404 6.75724 17.7906 6.60494 17.6071 6.23358C17.4859 5.98825 17.349 5.75195 17.1977 5.52598C16.9673 5.18178 17.0595 4.71595 17.4037 4.48551ZM6.59628 4.48551C6.94048 4.71595 7.0327 5.18178 6.80227 5.52598C6.65098 5.75195 6.5141 5.98825 6.39289 6.23358C6.2094 6.60494 5.75962 6.75724 5.38826 6.57376C5.0169 6.39028 4.8646 5.94049 5.04808 5.56913C5.19851 5.26467 5.3683 4.97159 5.55582 4.6915C5.78625 4.3473 6.25208 4.25508 6.59628 4.48551ZM18.9369 7.79135C19.3502 7.76464 19.707 8.07807 19.7337 8.49142C19.7445 8.659 19.75 8.82794 19.75 8.99805C19.75 9.16816 19.7445 9.33709 19.7337 9.50467C19.707 9.91803 19.3502 10.2315 18.9369 10.2047C18.5235 10.178 18.2101 9.82129 18.2368 9.40794C18.2456 9.27254 18.25 9.13587 18.25 8.99805C18.25 8.86023 18.2456 8.72356 18.2368 8.58815C18.2101 8.1748 18.5235 7.81806 18.9369 7.79135ZM5.06313 7.79135C5.47648 7.81806 5.78991 8.1748 5.7632 8.58815C5.75445 8.72356 5.75 8.86023 5.75 8.99805C5.75 9.13587 5.75445 9.27254 5.7632 9.40794C5.78991 9.82129 5.47648 10.178 5.06313 10.2047C4.64978 10.2315 4.29303 9.91803 4.26632 9.50467C4.25549 9.33709 4.25 9.16816 4.25 8.99805C4.25 8.82794 4.25549 8.659 4.26632 8.49142C4.29303 8.07807 4.64978 7.76464 5.06313 7.79135ZM18.6117 11.4223C18.9831 11.6058 19.1354 12.0556 18.9519 12.427C18.8015 12.7314 18.6317 13.0245 18.4442 13.3046C18.2137 13.6488 17.7479 13.741 17.4037 13.5106C17.0595 13.2801 16.9673 12.8143 17.1977 12.4701C17.349 12.2441 17.4859 12.0078 17.6071 11.7625C17.7906 11.3912 18.2404 11.2389 18.6117 11.4223ZM5.38826 11.4223C5.75962 11.2389 6.2094 11.3912 6.39289 11.7625C6.5141 12.0078 6.65098 12.2441 6.80227 12.4701C7.0327 12.8143 6.94048 13.2801 6.59628 13.5106C6.25208 13.741 5.78625 13.6488 5.55582 13.3046C5.3683 13.0245 5.19851 12.7314 5.04808 12.427C4.8646 12.0556 5.0169 11.6058 5.38826 11.4223ZM15.0052 5.9948C13.3455 4.33507 10.6545 4.33507 8.9948 5.9948C7.33507 7.65453 7.33507 10.3455 8.9948 12.0052C10.6545 13.6649 13.3455 13.6649 15.0052 12.0052C16.6649 10.3455 16.6649 7.65453 15.0052 5.9948ZM6.10466 16.2209C7.7321 15.2735 9.86712 14.7578 12 14.7578C14.1329 14.7578 16.2679 15.2735 17.8953 16.2209C19.516 17.1644 20.75 18.6181 20.75 20.4998V21.4998C20.75 22.466 19.9662 23.2498 19 23.2498H5C4.03379 23.2498 3.25 22.466 3.25 21.4998V20.4998C3.25 18.6181 4.48397 17.1644 6.10466 16.2209Z", fill: "currentColor" }));
};
const ANC_MODE_ADAPTIVE = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M16.5624 5.3114C16.2937 5.13073 16.013 4.96625 15.7216 4.81928C15.642 4.7791 15.5615 4.74023 15.4803 4.7027C15.3139 4.62579 15.3139 4.37389 15.4803 4.29699L15.4957 4.28983C15.5717 4.25452 15.647 4.21804 15.7216 4.18041C16.013 4.03344 16.2937 3.86896 16.5624 3.68829C16.5961 3.66562 16.6297 3.64269 16.663 3.61951C17.4262 3.08892 18.0889 2.4262 18.6195 1.66302C18.6427 1.62968 18.6656 1.59615 18.6883 1.56243C18.869 1.29372 19.0334 1.01301 19.1804 0.721632C19.2206 0.641973 19.2595 0.561518 19.297 0.480292C19.3739 0.313861 19.6258 0.313861 19.7027 0.480292C19.7402 0.561518 19.7791 0.641973 19.8193 0.721631C19.9662 1.01301 20.1307 1.29372 20.3114 1.56243C20.3341 1.59615 20.357 1.62968 20.3802 1.66302C20.9108 2.4262 21.5735 3.08892 22.3367 3.61951C22.37 3.64269 22.4035 3.66562 22.4373 3.68829C22.706 3.86896 22.9867 4.03344 23.2781 4.18041L23.2992 4.19105C23.372 4.22746 23.4454 4.26278 23.5194 4.29699C23.6858 4.37389 23.6858 4.62579 23.5194 4.7027C23.4382 4.74023 23.3577 4.7791 23.2781 4.81928C22.9867 4.96625 22.706 5.13073 22.4373 5.3114C22.4035 5.33407 22.37 5.35699 22.3367 5.38017C21.5735 5.91076 20.9108 6.57349 20.3802 7.33667C20.357 7.37001 20.3341 7.40354 20.3114 7.43726C20.1307 7.70596 19.9662 7.98668 19.8193 8.27806C19.7791 8.35771 19.7402 8.43817 19.7027 8.51939C19.6258 8.68583 19.3739 8.68583 19.297 8.51939C19.2595 8.43817 19.2206 8.35771 19.1804 8.27806C19.0334 7.98668 18.869 7.70596 18.6883 7.43726C18.6656 7.40354 18.6427 7.37001 18.6195 7.33667C18.0889 6.57349 17.4262 5.91076 16.663 5.38017C16.6297 5.35699 16.5961 5.33407 16.5624 5.3114ZM16.1002 2.42226C15.7394 2.69174 15.3493 2.92476 14.9352 3.11611C14.8137 3.17224 14.7048 3.24062 14.6085 3.31869C13.8146 2.9536 12.9311 2.75 12 2.75C8.54822 2.75 5.75 5.54822 5.75 9C5.75 10.7244 6.44835 12.2857 7.57765 13.4165C7.05809 13.5781 6.55333 13.7693 6.07018 13.9902C4.93438 12.642 4.25 10.9009 4.25 9C4.25 4.71979 7.71979 1.25 12 1.25C13.5056 1.25 14.9109 1.67934 16.1002 2.42226ZM19.6946 9.93141C19.1534 9.99861 18.5802 9.78414 18.2435 9.28799C18.1705 10.8978 17.4884 12.349 16.4223 13.4165C16.9419 13.5781 17.4467 13.7693 17.9298 13.9902C18.8773 12.8655 19.5106 11.4675 19.6946 9.93141ZM8.9948 5.9948C10.6545 4.33507 13.3455 4.33507 15.0052 5.9948C16.6649 7.65453 16.6649 10.3455 15.0052 12.0052C13.3455 13.6649 10.6545 13.6649 8.9948 12.0052C7.33507 10.3455 7.33507 7.65453 8.9948 5.9948ZM12 14.7578C9.86712 14.7578 7.7321 15.2735 6.10466 16.2209C4.48397 17.1644 3.25 18.6181 3.25 20.4998V21.4998C3.25 22.466 4.03379 23.2498 5 23.2498H19C19.9662 23.2498 20.75 22.466 20.75 21.4998V20.4998C20.75 18.6181 19.516 17.1644 17.8953 16.2209C16.2679 15.2735 14.1329 14.7578 12 14.7578Z", fill: "currentColor" }));
};
const ANC_MODE_WIND = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M14.0056 1.51189C15.279 1.85183 16.4827 2.52158 17.4802 3.51904C18.4776 4.5165 19.1474 5.72018 19.4873 6.99361C19.5941 7.39381 19.3563 7.80484 18.9561 7.91168C18.5559 8.01851 18.1449 7.78069 18.0381 7.38049C17.7643 6.35507 17.2255 5.38569 16.4195 4.5797C15.6135 3.7737 14.6441 3.23488 13.6187 2.96114C13.2185 2.8543 12.9807 2.44327 13.0875 2.04307C13.1944 1.64287 13.6054 1.40506 14.0056 1.51189ZM10.9127 2.04307C11.0195 2.44327 10.7817 2.8543 10.3815 2.96114C9.35605 3.23488 8.38667 3.7737 7.58067 4.5797C6.77468 5.38569 6.23585 6.35507 5.96212 7.38049C5.85528 7.78069 5.44425 8.01851 5.04405 7.91168C4.64385 7.80484 4.40603 7.39381 4.51287 6.99361C4.85281 5.72018 5.52255 4.5165 6.52001 3.51904C7.51747 2.52158 8.72116 1.85183 9.99459 1.51189C10.3948 1.40506 10.8058 1.64287 10.9127 2.04307ZM18.9561 10.0866C19.3563 10.1934 19.5941 10.6044 19.4873 11.0046C19.2012 12.0763 18.6816 13.0986 17.9296 13.9901C17.4463 13.7692 16.9414 13.5779 16.4217 13.4163C17.2265 12.6107 17.7646 11.6422 18.0381 10.6177C18.1449 10.2175 18.5559 9.97972 18.9561 10.0866ZM4.51287 11.0046C4.79894 12.0763 5.31859 13.0985 6.07056 13.9901C6.55383 13.7691 7.05872 13.5779 7.5784 13.4163C6.77366 12.6107 6.23559 11.6422 5.96212 10.6177C5.85528 10.2175 5.44425 9.97972 5.04405 10.0866C4.64385 10.1934 4.40603 10.6044 4.51287 11.0046ZM15.0052 5.9948C13.3455 4.33507 10.6545 4.33507 8.9948 5.9948C7.33507 7.65453 7.33507 10.3455 8.9948 12.0052C10.6545 13.6649 13.3455 13.6649 15.0052 12.0052C16.6649 10.3455 16.6649 7.65453 15.0052 5.9948ZM6.10466 16.2209C7.7321 15.2735 9.86712 14.7578 12 14.7578C14.1329 14.7578 16.2679 15.2735 17.8953 16.2209C19.516 17.1644 20.75 18.6181 20.75 20.4998V21.4998C20.75 22.466 19.9662 23.2498 19 23.2498H5C4.03379 23.2498 3.25 22.466 3.25 21.4998V20.4998C3.25 18.6181 4.48397 17.1644 6.10466 16.2209Z", fill: "currentColor" }));
};
const ANC_MODE_ANC = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M12 2.75C8.54822 2.75 5.75 5.54822 5.75 9C5.75 10.7244 6.44835 12.2857 7.57765 13.4165C7.05809 13.5781 6.55333 13.7693 6.07018 13.9902C4.93438 12.642 4.25 10.9009 4.25 9C4.25 4.71979 7.71979 1.25 12 1.25C16.2802 1.25 19.75 4.71979 19.75 9C19.75 10.9009 19.0656 12.642 17.9298 13.9902C17.4467 13.7693 16.9419 13.5781 16.4223 13.4165C17.5517 12.2857 18.25 10.7244 18.25 9C18.25 5.54822 15.4518 2.75 12 2.75ZM15.0052 5.9948C13.3455 4.33507 10.6545 4.33507 8.9948 5.9948C7.33507 7.65453 7.33507 10.3455 8.9948 12.0052C10.6545 13.6649 13.3455 13.6649 15.0052 12.0052C16.6649 10.3455 16.6649 7.65453 15.0052 5.9948ZM6.10466 16.2209C7.7321 15.2735 9.86712 14.7578 12 14.7578C14.1329 14.7578 16.2679 15.2735 17.8953 16.2209C19.516 17.1644 20.75 18.6181 20.75 20.4998V21.4998C20.75 22.466 19.9662 23.2498 19 23.2498H5C4.03379 23.2498 3.25 22.466 3.25 21.4998V20.4998C3.25 18.6181 4.48397 17.1644 6.10466 16.2209Z", fill: "currentColor" }));
};
const WARNING = ({ style }) => {
    return window.SP_REACT.createElement("svg", { style: style, width: "1em", height: "1em", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 32 32" },
        window.SP_REACT.createElement("rect", { width: "32", height: "32", fill: "none" }),
        window.SP_REACT.createElement("path", { d: "M16.0003 2.66602C13.3633 2.66602 10.7854 3.448 8.59273 4.91309C6.40008 6.37818 4.69111 8.46056 3.68194 10.8969C2.67277 13.3332 2.40872 16.0141 2.9232 18.6006C3.43767 21.187 4.70754 23.5627 6.57224 25.4274C8.43695 27.2921 10.8127 28.562 13.3991 29.0765C15.9856 29.591 18.6665 29.3269 21.1027 28.3177C23.5391 27.3086 25.6215 25.5996 27.0866 23.407C28.5517 21.2143 29.3337 18.6364 29.3337 15.9993C29.3337 14.2484 28.9888 12.5145 28.3187 10.8969C27.6487 9.27926 26.6666 7.80938 25.4284 6.57126C24.1903 5.33314 22.7204 4.35102 21.1027 3.68096C19.4851 3.0109 17.7513 2.66602 16.0003 2.66602ZM18.2226 23.1105H13.7781V14.2216H18.2226V23.1105ZM16.0003 12.4438C15.473 12.4438 14.9573 12.2874 14.5188 11.9944C14.0802 11.7014 13.7385 11.2849 13.5367 10.7977C13.3348 10.3104 13.282 9.77419 13.3849 9.25686C13.4878 8.73961 13.7418 8.26445 14.1147 7.89151C14.4876 7.51857 14.9628 7.26459 15.4801 7.1617C15.9974 7.05881 16.5336 7.11162 17.0208 7.31345C17.5081 7.51528 17.9246 7.85707 18.2176 8.29561C18.5106 8.73414 18.667 9.24975 18.667 9.77713C18.667 10.4843 18.386 11.1626 17.8859 11.6627C17.3858 12.1628 16.7075 12.4438 16.0003 12.4438Z", "fill-rule": "evenodd", "clip-rule": "evenodd", fill: "currentColor" }));
};

const FieldWithSeparator = DFL.joinClassNames(DFL.gamepadDialogClasses.Field, DFL.gamepadDialogClasses.WithBottomSeparatorStandard);
const OptionsPanelSection = DFL.joinClassNames(DFL.gamepadDialogClasses.HighlightOnFocus, DFL.gamepadDialogClasses.Field, DFL.quickAccessMenuClasses.PanelSectionRow);
const iconModesStyle$1 = {
    display: "block"
};
const AncModes = {
    OFF: 1,
    TRANSPARENCY: 2,
    ADAPTIVE: 4,
    WIND: 8,
    ANC: 16,
};
const getAncSliderConfig = async (backend, options, selected) => {
    backend.logDebug("Info: Options:", options, "Selected:", selected);
    let _count = 0;
    let _selectedIndex = 0;
    let _labels = [];
    let _convertBack = {};
    let isOff = await backend.loadBooleanSetting("allow_anc_mode_off");
    let isTransparency = await backend.loadBooleanSetting("allow_anc_mode_transparency");
    let isAdaptive = await backend.loadBooleanSetting("allow_anc_mode_adaptive");
    let isWind = await backend.loadBooleanSetting("allow_anc_mode_wind");
    let isAnc = await backend.loadBooleanSetting("allow_anc_mode_anc");
    const trueCount = [isOff, isTransparency, isAdaptive, isWind, isAnc].filter(Boolean).length;
    if (trueCount < 2)
        return null;
    //The order is important OFF->TRA->ADAP->WIND->ANC
    if (isOff && (options & AncModes.OFF) != 0) {
        _count += 1;
        _labels.push({ label: window.SP_REACT.createElement(ANC_MODE_OFF, { style: iconModesStyle$1 }), notchIndex: _count - 1, value: _count });
        _convertBack[_count] = AncModes.OFF;
        if ((selected & AncModes.OFF) != 0)
            _selectedIndex = _count;
    }
    if (isTransparency && (options & AncModes.TRANSPARENCY) != 0) {
        _count += 1;
        _labels.push({ label: window.SP_REACT.createElement(ANC_MODE_TRANSPARENCY, { style: iconModesStyle$1 }), notchIndex: _count - 1, value: _count });
        _convertBack[_count] = AncModes.TRANSPARENCY;
        if ((selected & AncModes.TRANSPARENCY) != 0)
            _selectedIndex = _count;
    }
    if (isAdaptive && (options & AncModes.ADAPTIVE) != 0) {
        _count += 1;
        _labels.push({ label: window.SP_REACT.createElement(ANC_MODE_ADAPTIVE, { style: iconModesStyle$1 }), notchIndex: _count - 1, value: _count });
        _convertBack[_count] = AncModes.ADAPTIVE;
        if ((selected & AncModes.ADAPTIVE) != 0)
            _selectedIndex = _count;
    }
    if (isWind && (options & AncModes.WIND) != 0) {
        _count += 1;
        _labels.push({ label: window.SP_REACT.createElement(ANC_MODE_WIND, { style: iconModesStyle$1 }), notchIndex: _count - 1, value: _count });
        _convertBack[_count] = AncModes.WIND;
        if ((selected & AncModes.WIND) != 0)
            _selectedIndex = _count;
    }
    if (isAnc && (options & AncModes.ANC) != 0) {
        _count += 1;
        _labels.push({ label: window.SP_REACT.createElement(ANC_MODE_ANC, { style: iconModesStyle$1 }), notchIndex: _count - 1, value: _count });
        _convertBack[_count] = AncModes.ANC;
        if ((selected & AncModes.ANC) != 0)
            _selectedIndex = _count;
    }
    backend.logDebug("Info: SelectedIndex:", _selectedIndex, "Count:", _count, "ConvertBackDict:", _convertBack, "Label:", _labels);
    return {
        value: _selectedIndex,
        max: _count,
        notchCount: _count,
        labels: _labels,
        convert: _convertBack,
    };
};
const showQrModal$1 = () => {
    DFL.showModal(window.SP_REACT.createElement(DFL.ModalRoot, null,
        window.SP_REACT.createElement("span", { style: { textAlign: 'center', wordBreak: 'break-word' } }, t$1("capabilities_modal"))), window);
};
function hasOtherCapabilities(capabilities) {
    const { anc, battery, ...rest } = capabilities;
    return Object.values(rest).some(value => value !== undefined && value !== null);
}
const TabInfo = ({ info, setInfoValue, backend }) => {
    const [config, setConfig] = SP_REACT.useState(null);
    const [loaded, setLoaded] = SP_REACT.useState(false);
    const [volume, setVolume] = SP_REACT.useState(0);
    const timeoutIds = SP_REACT.useRef({});
    const commonUpdateInfo = (key, value) => {
        const capability = info?.capabilities?.[key];
        if (capability && 'selected' in capability) {
            const clonedInfo = { ...info };
            clonedInfo.capabilities = {
                ...clonedInfo.capabilities,
                [key]: {
                    ...capability,
                    selected: value,
                },
            };
            setInfoValue(clonedInfo);
        }
    };
    const handleBooleanCapabilityChange = (key, value) => {
        commonUpdateInfo(key, value);
        const address = info?.address;
        if (address) {
            backend.logInfo(`Send set ${key} to`, value);
            backend.setCapability(key, address, value);
        }
    };
    const handleNumberCapabilityChange = (key, value) => {
        commonUpdateInfo(key, value);
        if (timeoutIds.current[key])
            clearTimeout(timeoutIds.current[key]);
        const starttime = Date.now();
        const address = info?.address;
        timeoutIds.current[key] = setTimeout(() => {
            if (address) {
                backend.logInfo(`Info: Elapsed: ${Date.now() - starttime}ms. Send set ${key} to`, value);
                backend.setCapability(key, address, value);
            }
            delete timeoutIds.current[key];
        }, 350);
    };
    SP_REACT.useEffect(() => {
        const fetchConfig = async () => {
            //setLoaded(false);
            if (info?.capabilities?.anc != null) {
                const result = await getAncSliderConfig(backend, info.capabilities.anc.options, info.capabilities.anc.selected);
                setConfig(result);
                setLoaded(true);
            }
            else {
                setConfig(null);
                setLoaded(true);
            }
        };
        fetchConfig();
    }, [info?.capabilities?.anc?.options, info?.capabilities?.anc?.selected]);
    //[info, backend]);
    SP_REACT.useEffect(() => {
        const fetchSettings = async () => {
            setVolume(await backend.loadNumberSetting("conversation_awareness_volume") ?? 0);
        };
        fetchSettings();
    }, [info?.capabilities?.conversationAwareness?.selected]);
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
        window.SP_REACT.createElement("div", { style: { marginLeft: "-8px", marginRight: "-8px" } },
            info == null && window.SP_REACT.createElement("div", { className: DFL.staticClasses.Text, style: { paddingLeft: "16px", paddingRight: "16px" } }, t$1("headphones_disconnected")),
            info?.name != null &&
                window.SP_REACT.createElement(DFL.PanelSection, { title: info.name },
                    info?.capabilities?.battery != null &&
                        window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                            window.SP_REACT.createElement("div", { className: FieldWithSeparator },
                                window.SP_REACT.createElement("div", { style: { display: "flex", padding: "0px 0px 0px 0px" } },
                                    window.SP_REACT.createElement(Battery, { title: t$1("battery_single"), battery: info.capabilities.battery.single.battery, isCharging: info.capabilities.battery.single.charging, status: info.capabilities.battery.single.status }),
                                    window.SP_REACT.createElement(Battery, { title: t$1("battery_left"), battery: info.capabilities.battery.left.battery, isCharging: info.capabilities.battery.left.charging, status: info.capabilities.battery.left.status }),
                                    window.SP_REACT.createElement(Battery, { title: t$1("battery_right"), battery: info.capabilities.battery.right.battery, isCharging: info.capabilities.battery.right.charging, status: info.capabilities.battery.right.status }),
                                    window.SP_REACT.createElement(Battery, { title: t$1("battery_case"), battery: info.capabilities.battery.case.battery, isCharging: info.capabilities.battery.case.charging, status: info.capabilities.battery.case.status })))),
                    info?.capabilities?.anc != null && config != null &&
                        window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                            window.SP_REACT.createElement(DFL.SliderField, { value: config.value, max: config.max, min: 1, step: 1, label: t$1("capabilities_noise_control_label"), notchCount: config.notchCount, notchTicksVisible: false, 
                                // @ts-ignore
                                notchLabels: config.labels, onChange: (n) => {
                                    const v = config.convert[n] ?? 0;
                                    backend.logDebug("Info: ANC slider changed to UI:", n, "Native:", v);
                                    handleNumberCapabilityChange("anc", v);
                                } })),
                    loaded == true && info?.capabilities != null && hasOtherCapabilities(info.capabilities) && (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
                        window.SP_REACT.createElement(DFL.Focusable, { noFocusRing: true, className: OptionsPanelSection, style: { marginLeft: "-16px", marginRight: "-16px", marginTop: "24px" }, onOKButton: () => showQrModal$1() },
                            window.SP_REACT.createElement("div", { className: DFL.staticClasses.PanelSectionTitle, style: { display: "flex", justifyContent: "space-between", alignItems: "center" }, onClick: () => showQrModal$1() },
                                t$1("capabilities_header"),
                                window.SP_REACT.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 36 36", fill: "none" },
                                    window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M18 3C15.0333 3 12.1332 3.87973 9.66645 5.52796C7.19971 7.17618 5.27712 9.51886 4.14181 12.2597C3.00649 15.0006 2.70944 18.0166 3.28822 20.9264C3.867 23.8361 5.29561 26.5088 7.3934 28.6066C9.49119 30.7044 12.1639 32.133 15.0736 32.7118C17.9834 33.2906 20.9994 32.9935 23.7402 31.8582C26.4811 30.7229 28.8238 28.8003 30.472 26.3336C32.1203 23.8668 33 20.9667 33 18C33 16.0302 32.612 14.0796 31.8582 12.2597C31.1044 10.4399 29.9995 8.78628 28.6066 7.3934C27.2137 6.00052 25.5601 4.89563 23.7402 4.14181C21.9204 3.38799 19.9698 3 18 3ZM20.5 26H15.5V16H20.5V26ZM18 14C17.4067 14 16.8266 13.8241 16.3333 13.4944C15.8399 13.1648 15.4554 12.6962 15.2284 12.1481C15.0013 11.5999 14.9419 10.9967 15.0576 10.4147C15.1734 9.83279 15.4591 9.29824 15.8787 8.87868C16.2982 8.45912 16.8328 8.1734 17.4147 8.05764C17.9967 7.94189 18.5999 8.0013 19.148 8.22836C19.6962 8.45542 20.1648 8.83994 20.4944 9.33329C20.8241 9.82664 21 10.4067 21 11C21 11.7956 20.6839 12.5587 20.1213 13.1213C19.5587 13.6839 18.7956 14 18 14Z", fill: "currentColor" })))),
                        info?.capabilities?.conversationAwareness != null && (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.ToggleField, { checked: info?.capabilities?.conversationAwareness.selected, label: t$1("capabilities_aap_conversation_awareness_label"), onChange: (b) => { handleBooleanCapabilityChange("conversationAwareness", b); } })),
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: volume, max: 100, min: 0, step: 1, label: t$1("capabilities_aap_conversation_awareness_volume_label"), notchCount: 2, notchTicksVisible: false, showValue: true, valueSuffix: "%", disabled: !info?.capabilities?.conversationAwareness.selected, notchLabels: [
                                        { label: t$1("capabilities_aap_conversation_awareness_volume_label_notchlabel_off"), notchIndex: 0, value: 0 },
                                        { label: "", notchIndex: 1, value: 100 }
                                    ], onChange: (n) => {
                                        setVolume(n);
                                        const key = "conversationAwarenessSpeaking";
                                        if (timeoutIds.current[key])
                                            clearTimeout(timeoutIds.current[key]);
                                        let starttime = Date.now();
                                        timeoutIds.current[key] = setTimeout(async () => {
                                            backend.logInfo("Settings: Elapsed", Date.now() - starttime, "Set volume to", n);
                                            await backend.saveSetting("conversation_awareness_volume", n);
                                            delete timeoutIds.current[key];
                                        }, 350);
                                    } })))),
                        info?.capabilities?.personalizedVolume != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.ToggleField, { checked: info?.capabilities?.personalizedVolume.selected, label: t$1("capabilities_aap_personalized_volume_label"), onChange: (b) => { handleBooleanCapabilityChange("personalizedVolume", b); } })),
                        info?.capabilities?.adaptiveAudioNoise != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.adaptiveAudioNoise.selected, max: 100, min: 0, step: 50, label: t$1("capabilities_aap_adaptive_audio_noise_label"), notchCount: 3, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_adaptive_audio_noise_notchlabel_more"), notchIndex: 0, value: 0 },
                                        { label: t$1("capabilities_aap_adaptive_audio_noise_notchlabel_default"), notchIndex: 1, value: 50 },
                                        { label: t$1("capabilities_aap_adaptive_audio_noise_notchlabel_less"), notchIndex: 2, value: 100 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("adaptiveAudioNoise", n); } })),
                        info?.capabilities?.ancOneAirPod != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.ToggleField, { checked: info?.capabilities?.ancOneAirPod.selected, label: t$1("capabilities_aap_anc_one_airpod_label"), onChange: (b) => { handleBooleanCapabilityChange("ancOneAirPod", b); } })),
                        info?.capabilities?.pressAndHoldDuration != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.pressAndHoldDuration.selected, max: 2, min: 0, step: 1, label: t$1("capabilities_aap_press_and_hold_duration_label"), notchCount: 3, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_press_and_hold_duration_notchlabel_default"), notchIndex: 0, value: 0 },
                                        { label: t$1("capabilities_aap_press_and_hold_duration_notchlabel_shorter"), notchIndex: 1, value: 1 },
                                        { label: t$1("capabilities_aap_press_and_hold_duration_notchlabel_shortest"), notchIndex: 2, value: 2 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("pressAndHoldDuration", n); } })),
                        info?.capabilities?.pressSpeed != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.pressSpeed.selected, max: 2, min: 0, step: 1, label: t$1("capabilities_aap_press_speed_label"), notchCount: 3, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_press_speed_notchlabel_default"), notchIndex: 0, value: 0 },
                                        { label: t$1("capabilities_aap_press_speed_notchlabel_slower"), notchIndex: 1, value: 1 },
                                        { label: t$1("capabilities_aap_press_speed_notchlabel_slowest"), notchIndex: 2, value: 2 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("pressSpeed", n); } })),
                        info?.capabilities?.toneVolume != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.toneVolume.selected, max: 125, min: 15, step: 1, label: t$1("capabilities_aap_tone_volume_label"), notchCount: 2, notchTicksVisible: false, showValue: true, valueSuffix: "%", notchLabels: [
                                        { label: "15", notchIndex: 0, value: 15 },
                                        { label: "125", notchIndex: 1, value: 100 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("toneVolume", n); } })),
                        info?.capabilities?.volumeSwipe != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.ToggleField, { checked: info?.capabilities?.volumeSwipe.selected, label: t$1("capabilities_aap_volume_swipe_label"), onChange: (b) => { handleBooleanCapabilityChange("volumeSwipe", b); } })),
                        info?.capabilities?.volumeSwipeLength != null &&
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.volumeSwipeLength.selected, max: 2, min: 0, step: 1, label: t$1("capabilities_aap_volume_swipe_length_label"), notchCount: 3, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_volume_swipe_length_notchlabel_default"), notchIndex: 0, value: 0 },
                                        { label: t$1("capabilities_aap_volume_swipe_length_notchlabel_longer"), notchIndex: 1, value: 1 },
                                        { label: t$1("capabilities_aap_volume_swipe_length_notchlabel_longest"), notchIndex: 2, value: 2 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("volumeSwipeLength", n); } })),
                        info?.capabilities?.endCall != null && (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.endCall.selected, max: 3, min: 2, step: 1, label: t$1("capabilities_aap_end_call_label"), notchCount: 2, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_end_call_notchlabel_double"), notchIndex: 0, value: 2 },
                                        { label: t$1("capabilities_aap_end_call_notchlabel_single"), notchIndex: 1, value: 3 }
                                    ], onChange: (n) => { handleNumberCapabilityChange("endCall", n); } })),
                            window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                                window.SP_REACT.createElement(DFL.SliderField, { value: info?.capabilities?.endCall.selected == 2 ? 3 : 2, max: 3, min: 2, step: 1, label: t$1("capabilities_aap_mute_unmute_label"), notchCount: 2, notchTicksVisible: false, notchLabels: [
                                        { label: t$1("capabilities_aap_end_call_notchlabel_double"), notchIndex: 0, value: 2 },
                                        { label: t$1("capabilities_aap_end_call_notchlabel_single"), notchIndex: 1, value: 3 }
                                    ], disabled: true }))))))))));
};

/// <reference path="../typings/index.d.ts" />


const TabHeadphones = ({ defaultBluetooth, setDefaultBluetooth, headphones, setHeadphones, backend }) => {
    const [disabledHeadphones, setDisabledHeadphones] = SP_REACT.useState({});
    const [checkedHeadphones, setCheckedHeadphones] = SP_REACT.useState({});
    const handleToggleFieldChange = (address, disabled) => {
        setDisabledHeadphones((prevState) => ({
            ...prevState,
            [address]: true,
        }));
        backend.logDebug("Headphones: Updated setCheckedHeadphones");
        setCheckedHeadphones((prevState) => ({
            ...prevState,
            [address]: disabled,
        }));
    };
    SP_REACT.useEffect(() => {
        backend.logDebug("Headphones: Updated headphones");
        setDisabledHeadphones({});
        headphones.forEach(headphone => {
            setCheckedHeadphones((prevState) => ({
                ...prevState,
                [headphone.address]: headphone.connected,
            }));
        });
    }, [headphones]);
    // const updateDeviceConnectedState = (address: string, isConnected: boolean) => {
    //   setHeadphones(prevState => {
    //     return prevState.map(device => {
    //       if (device.address === address) {
    //         return {
    //           ...device,
    //           connected: isConnected
    //         };
    //       }
    //       return device;
    //     });
    //   });
    // };
    // SteamClient.System.Bluetooth.RegisterForStateChanges((change: BluetoothStateChange)  => {
    //   setBluetoothAdapterEnabled(change.bEnabled);
    // });
    const onChangeBluetoothAdapterToggleField = (b) => {
        if (setDefaultBluetooth != null)
            setDefaultBluetooth({ enabled: b });
        if (b) {
            backend.enableDefaultBluetoothAdapter();
        }
        else {
            backend.disableDefaultBluetoothAdapter();
        }
        //void SteamClient.System.Bluetooth.SetEnabled(b); // disabled due SteamClient.System.Bluetooth is not available since Steam Deck OS 3.5.19
    };
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
        window.SP_REACT.createElement("div", { style: { marginLeft: "-8px", marginRight: "-8px" } },
            defaultBluetooth &&
                window.SP_REACT.createElement(DFL.PanelSection, null,
                    window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                        window.SP_REACT.createElement(DFL.ToggleField, { checked: defaultBluetooth.enabled, label: t$1("bluetooth"), onChange: onChangeBluetoothAdapterToggleField }))),
            (headphones.length !== 0) &&
                window.SP_REACT.createElement(DFL.PanelSection, { title: t$1("headphones") }, headphones
                    .slice()
                    .sort((a, b) => a.name.localeCompare(b.name))
                    .map((headphone, index) => (window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: checkedHeadphones[headphone.address], label: headphone.name, disabled: disabledHeadphones[headphone.address], onChange: (b) => {
                            backend.logInfo("Headphones: Change connection to", b, "for", headphone.name, "(", headphone.address, ")");
                            handleToggleFieldChange(headphone.address, b);
                            if (b) {
                                backend.connectDevice(headphone.address);
                            }
                            else {
                                backend.disconnectDevice(headphone.address);
                            }
                        } }))))))));
};

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/index.tsx


// src/third-party/qrcodegen/index.ts
/**
 * @license QR Code generator library (TypeScript)
 * Copyright (c) Project Nayuki.
 * SPDX-License-Identifier: MIT
 */
var qrcodegen;
((qrcodegen2) => {
  const _QrCode = class _QrCode {
    /*-- Constructor (low level) and fields --*/
    // Creates a new QR Code with the given version number,
    // error correction level, data codeword bytes, and mask number.
    // This is a low-level API that most users should not use directly.
    // A mid-level API is the encodeSegments() function.
    constructor(version, errorCorrectionLevel, dataCodewords, msk) {
      this.version = version;
      this.errorCorrectionLevel = errorCorrectionLevel;
      // The modules of this QR Code (false = light, true = dark).
      // Immutable after constructor finishes. Accessed through getModule().
      this.modules = [];
      // Indicates function modules that are not subjected to masking. Discarded when constructor finishes.
      this.isFunction = [];
      if (version < _QrCode.MIN_VERSION || version > _QrCode.MAX_VERSION)
        throw new RangeError("Version value out of range");
      if (msk < -1 || msk > 7)
        throw new RangeError("Mask value out of range");
      this.size = version * 4 + 17;
      let row = [];
      for (let i = 0; i < this.size; i++)
        row.push(false);
      for (let i = 0; i < this.size; i++) {
        this.modules.push(row.slice());
        this.isFunction.push(row.slice());
      }
      this.drawFunctionPatterns();
      const allCodewords = this.addEccAndInterleave(dataCodewords);
      this.drawCodewords(allCodewords);
      if (msk == -1) {
        let minPenalty = 1e9;
        for (let i = 0; i < 8; i++) {
          this.applyMask(i);
          this.drawFormatBits(i);
          const penalty = this.getPenaltyScore();
          if (penalty < minPenalty) {
            msk = i;
            minPenalty = penalty;
          }
          this.applyMask(i);
        }
      }
      assert(0 <= msk && msk <= 7);
      this.mask = msk;
      this.applyMask(msk);
      this.drawFormatBits(msk);
      this.isFunction = [];
    }
    /*-- Static factory functions (high level) --*/
    // Returns a QR Code representing the given Unicode text string at the given error correction level.
    // As a conservative upper bound, this function is guaranteed to succeed for strings that have 738 or fewer
    // Unicode code points (not UTF-16 code units) if the low error correction level is used. The smallest possible
    // QR Code version is automatically chosen for the output. The ECC level of the result may be higher than the
    // ecl argument if it can be done without increasing the version.
    static encodeText(text, ecl) {
      const segs = qrcodegen2.QrSegment.makeSegments(text);
      return _QrCode.encodeSegments(segs, ecl);
    }
    // Returns a QR Code representing the given binary data at the given error correction level.
    // This function always encodes using the binary segment mode, not any text mode. The maximum number of
    // bytes allowed is 2953. The smallest possible QR Code version is automatically chosen for the output.
    // The ECC level of the result may be higher than the ecl argument if it can be done without increasing the version.
    static encodeBinary(data, ecl) {
      const seg = qrcodegen2.QrSegment.makeBytes(data);
      return _QrCode.encodeSegments([seg], ecl);
    }
    /*-- Static factory functions (mid level) --*/
    // Returns a QR Code representing the given segments with the given encoding parameters.
    // The smallest possible QR Code version within the given range is automatically
    // chosen for the output. Iff boostEcl is true, then the ECC level of the result
    // may be higher than the ecl argument if it can be done without increasing the
    // version. The mask number is either between 0 to 7 (inclusive) to force that
    // mask, or -1 to automatically choose an appropriate mask (which may be slow).
    // This function allows the user to create a custom sequence of segments that switches
    // between modes (such as alphanumeric and byte) to encode text in less space.
    // This is a mid-level API; the high-level API is encodeText() and encodeBinary().
    static encodeSegments(segs, ecl, minVersion = 1, maxVersion = 40, mask = -1, boostEcl = true) {
      if (!(_QrCode.MIN_VERSION <= minVersion && minVersion <= maxVersion && maxVersion <= _QrCode.MAX_VERSION) || mask < -1 || mask > 7)
        throw new RangeError("Invalid value");
      let version;
      let dataUsedBits;
      for (version = minVersion; ; version++) {
        const dataCapacityBits2 = _QrCode.getNumDataCodewords(version, ecl) * 8;
        const usedBits = QrSegment.getTotalBits(segs, version);
        if (usedBits <= dataCapacityBits2) {
          dataUsedBits = usedBits;
          break;
        }
        if (version >= maxVersion)
          throw new RangeError("Data too long");
      }
      for (const newEcl of [_QrCode.Ecc.MEDIUM, _QrCode.Ecc.QUARTILE, _QrCode.Ecc.HIGH]) {
        if (boostEcl && dataUsedBits <= _QrCode.getNumDataCodewords(version, newEcl) * 8)
          ecl = newEcl;
      }
      let bb = [];
      for (const seg of segs) {
        appendBits(seg.mode.modeBits, 4, bb);
        appendBits(seg.numChars, seg.mode.numCharCountBits(version), bb);
        for (const b of seg.getData())
          bb.push(b);
      }
      assert(bb.length == dataUsedBits);
      const dataCapacityBits = _QrCode.getNumDataCodewords(version, ecl) * 8;
      assert(bb.length <= dataCapacityBits);
      appendBits(0, Math.min(4, dataCapacityBits - bb.length), bb);
      appendBits(0, (8 - bb.length % 8) % 8, bb);
      assert(bb.length % 8 == 0);
      for (let padByte = 236; bb.length < dataCapacityBits; padByte ^= 236 ^ 17)
        appendBits(padByte, 8, bb);
      let dataCodewords = [];
      while (dataCodewords.length * 8 < bb.length)
        dataCodewords.push(0);
      bb.forEach((b, i) => dataCodewords[i >>> 3] |= b << 7 - (i & 7));
      return new _QrCode(version, ecl, dataCodewords, mask);
    }
    /*-- Accessor methods --*/
    // Returns the color of the module (pixel) at the given coordinates, which is false
    // for light or true for dark. The top left corner has the coordinates (x=0, y=0).
    // If the given coordinates are out of bounds, then false (light) is returned.
    getModule(x, y) {
      return 0 <= x && x < this.size && 0 <= y && y < this.size && this.modules[y][x];
    }
    // Modified to expose modules for easy access
    getModules() {
      return this.modules;
    }
    /*-- Private helper methods for constructor: Drawing function modules --*/
    // Reads this object's version field, and draws and marks all function modules.
    drawFunctionPatterns() {
      for (let i = 0; i < this.size; i++) {
        this.setFunctionModule(6, i, i % 2 == 0);
        this.setFunctionModule(i, 6, i % 2 == 0);
      }
      this.drawFinderPattern(3, 3);
      this.drawFinderPattern(this.size - 4, 3);
      this.drawFinderPattern(3, this.size - 4);
      const alignPatPos = this.getAlignmentPatternPositions();
      const numAlign = alignPatPos.length;
      for (let i = 0; i < numAlign; i++) {
        for (let j = 0; j < numAlign; j++) {
          if (!(i == 0 && j == 0 || i == 0 && j == numAlign - 1 || i == numAlign - 1 && j == 0))
            this.drawAlignmentPattern(alignPatPos[i], alignPatPos[j]);
        }
      }
      this.drawFormatBits(0);
      this.drawVersion();
    }
    // Draws two copies of the format bits (with its own error correction code)
    // based on the given mask and this object's error correction level field.
    drawFormatBits(mask) {
      const data = this.errorCorrectionLevel.formatBits << 3 | mask;
      let rem = data;
      for (let i = 0; i < 10; i++)
        rem = rem << 1 ^ (rem >>> 9) * 1335;
      const bits = (data << 10 | rem) ^ 21522;
      assert(bits >>> 15 == 0);
      for (let i = 0; i <= 5; i++)
        this.setFunctionModule(8, i, getBit(bits, i));
      this.setFunctionModule(8, 7, getBit(bits, 6));
      this.setFunctionModule(8, 8, getBit(bits, 7));
      this.setFunctionModule(7, 8, getBit(bits, 8));
      for (let i = 9; i < 15; i++)
        this.setFunctionModule(14 - i, 8, getBit(bits, i));
      for (let i = 0; i < 8; i++)
        this.setFunctionModule(this.size - 1 - i, 8, getBit(bits, i));
      for (let i = 8; i < 15; i++)
        this.setFunctionModule(8, this.size - 15 + i, getBit(bits, i));
      this.setFunctionModule(8, this.size - 8, true);
    }
    // Draws two copies of the version bits (with its own error correction code),
    // based on this object's version field, iff 7 <= version <= 40.
    drawVersion() {
      if (this.version < 7)
        return;
      let rem = this.version;
      for (let i = 0; i < 12; i++)
        rem = rem << 1 ^ (rem >>> 11) * 7973;
      const bits = this.version << 12 | rem;
      assert(bits >>> 18 == 0);
      for (let i = 0; i < 18; i++) {
        const color = getBit(bits, i);
        const a = this.size - 11 + i % 3;
        const b = Math.floor(i / 3);
        this.setFunctionModule(a, b, color);
        this.setFunctionModule(b, a, color);
      }
    }
    // Draws a 9*9 finder pattern including the border separator,
    // with the center module at (x, y). Modules can be out of bounds.
    drawFinderPattern(x, y) {
      for (let dy = -4; dy <= 4; dy++) {
        for (let dx = -4; dx <= 4; dx++) {
          const dist = Math.max(Math.abs(dx), Math.abs(dy));
          const xx = x + dx;
          const yy = y + dy;
          if (0 <= xx && xx < this.size && 0 <= yy && yy < this.size)
            this.setFunctionModule(xx, yy, dist != 2 && dist != 4);
        }
      }
    }
    // Draws a 5*5 alignment pattern, with the center module
    // at (x, y). All modules must be in bounds.
    drawAlignmentPattern(x, y) {
      for (let dy = -2; dy <= 2; dy++) {
        for (let dx = -2; dx <= 2; dx++)
          this.setFunctionModule(x + dx, y + dy, Math.max(Math.abs(dx), Math.abs(dy)) != 1);
      }
    }
    // Sets the color of a module and marks it as a function module.
    // Only used by the constructor. Coordinates must be in bounds.
    setFunctionModule(x, y, isDark) {
      this.modules[y][x] = isDark;
      this.isFunction[y][x] = true;
    }
    /*-- Private helper methods for constructor: Codewords and masking --*/
    // Returns a new byte string representing the given data with the appropriate error correction
    // codewords appended to it, based on this object's version and error correction level.
    addEccAndInterleave(data) {
      const ver = this.version;
      const ecl = this.errorCorrectionLevel;
      if (data.length != _QrCode.getNumDataCodewords(ver, ecl))
        throw new RangeError("Invalid argument");
      const numBlocks = _QrCode.NUM_ERROR_CORRECTION_BLOCKS[ecl.ordinal][ver];
      const blockEccLen = _QrCode.ECC_CODEWORDS_PER_BLOCK[ecl.ordinal][ver];
      const rawCodewords = Math.floor(_QrCode.getNumRawDataModules(ver) / 8);
      const numShortBlocks = numBlocks - rawCodewords % numBlocks;
      const shortBlockLen = Math.floor(rawCodewords / numBlocks);
      let blocks = [];
      const rsDiv = _QrCode.reedSolomonComputeDivisor(blockEccLen);
      for (let i = 0, k = 0; i < numBlocks; i++) {
        let dat = data.slice(k, k + shortBlockLen - blockEccLen + (i < numShortBlocks ? 0 : 1));
        k += dat.length;
        const ecc = _QrCode.reedSolomonComputeRemainder(dat, rsDiv);
        if (i < numShortBlocks)
          dat.push(0);
        blocks.push(dat.concat(ecc));
      }
      let result = [];
      for (let i = 0; i < blocks[0].length; i++) {
        blocks.forEach((block, j) => {
          if (i != shortBlockLen - blockEccLen || j >= numShortBlocks)
            result.push(block[i]);
        });
      }
      assert(result.length == rawCodewords);
      return result;
    }
    // Draws the given sequence of 8-bit codewords (data and error correction) onto the entire
    // data area of this QR Code. Function modules need to be marked off before this is called.
    drawCodewords(data) {
      if (data.length != Math.floor(_QrCode.getNumRawDataModules(this.version) / 8))
        throw new RangeError("Invalid argument");
      let i = 0;
      for (let right = this.size - 1; right >= 1; right -= 2) {
        if (right == 6)
          right = 5;
        for (let vert = 0; vert < this.size; vert++) {
          for (let j = 0; j < 2; j++) {
            const x = right - j;
            const upward = (right + 1 & 2) == 0;
            const y = upward ? this.size - 1 - vert : vert;
            if (!this.isFunction[y][x] && i < data.length * 8) {
              this.modules[y][x] = getBit(data[i >>> 3], 7 - (i & 7));
              i++;
            }
          }
        }
      }
      assert(i == data.length * 8);
    }
    // XORs the codeword modules in this QR Code with the given mask pattern.
    // The function modules must be marked and the codeword bits must be drawn
    // before masking. Due to the arithmetic of XOR, calling applyMask() with
    // the same mask value a second time will undo the mask. A final well-formed
    // QR Code needs exactly one (not zero, two, etc.) mask applied.
    applyMask(mask) {
      if (mask < 0 || mask > 7)
        throw new RangeError("Mask value out of range");
      for (let y = 0; y < this.size; y++) {
        for (let x = 0; x < this.size; x++) {
          let invert;
          switch (mask) {
            case 0:
              invert = (x + y) % 2 == 0;
              break;
            case 1:
              invert = y % 2 == 0;
              break;
            case 2:
              invert = x % 3 == 0;
              break;
            case 3:
              invert = (x + y) % 3 == 0;
              break;
            case 4:
              invert = (Math.floor(x / 3) + Math.floor(y / 2)) % 2 == 0;
              break;
            case 5:
              invert = x * y % 2 + x * y % 3 == 0;
              break;
            case 6:
              invert = (x * y % 2 + x * y % 3) % 2 == 0;
              break;
            case 7:
              invert = ((x + y) % 2 + x * y % 3) % 2 == 0;
              break;
            default:
              throw new Error("Unreachable");
          }
          if (!this.isFunction[y][x] && invert)
            this.modules[y][x] = !this.modules[y][x];
        }
      }
    }
    // Calculates and returns the penalty score based on state of this QR Code's current modules.
    // This is used by the automatic mask choice algorithm to find the mask pattern that yields the lowest score.
    getPenaltyScore() {
      let result = 0;
      for (let y = 0; y < this.size; y++) {
        let runColor = false;
        let runX = 0;
        let runHistory = [0, 0, 0, 0, 0, 0, 0];
        for (let x = 0; x < this.size; x++) {
          if (this.modules[y][x] == runColor) {
            runX++;
            if (runX == 5)
              result += _QrCode.PENALTY_N1;
            else if (runX > 5)
              result++;
          } else {
            this.finderPenaltyAddHistory(runX, runHistory);
            if (!runColor)
              result += this.finderPenaltyCountPatterns(runHistory) * _QrCode.PENALTY_N3;
            runColor = this.modules[y][x];
            runX = 1;
          }
        }
        result += this.finderPenaltyTerminateAndCount(runColor, runX, runHistory) * _QrCode.PENALTY_N3;
      }
      for (let x = 0; x < this.size; x++) {
        let runColor = false;
        let runY = 0;
        let runHistory = [0, 0, 0, 0, 0, 0, 0];
        for (let y = 0; y < this.size; y++) {
          if (this.modules[y][x] == runColor) {
            runY++;
            if (runY == 5)
              result += _QrCode.PENALTY_N1;
            else if (runY > 5)
              result++;
          } else {
            this.finderPenaltyAddHistory(runY, runHistory);
            if (!runColor)
              result += this.finderPenaltyCountPatterns(runHistory) * _QrCode.PENALTY_N3;
            runColor = this.modules[y][x];
            runY = 1;
          }
        }
        result += this.finderPenaltyTerminateAndCount(runColor, runY, runHistory) * _QrCode.PENALTY_N3;
      }
      for (let y = 0; y < this.size - 1; y++) {
        for (let x = 0; x < this.size - 1; x++) {
          const color = this.modules[y][x];
          if (color == this.modules[y][x + 1] && color == this.modules[y + 1][x] && color == this.modules[y + 1][x + 1])
            result += _QrCode.PENALTY_N2;
        }
      }
      let dark = 0;
      for (const row of this.modules)
        dark = row.reduce((sum, color) => sum + (color ? 1 : 0), dark);
      const total = this.size * this.size;
      const k = Math.ceil(Math.abs(dark * 20 - total * 10) / total) - 1;
      assert(0 <= k && k <= 9);
      result += k * _QrCode.PENALTY_N4;
      assert(0 <= result && result <= 2568888);
      return result;
    }
    /*-- Private helper functions --*/
    // Returns an ascending list of positions of alignment patterns for this version number.
    // Each position is in the range [0,177), and are used on both the x and y axes.
    // This could be implemented as lookup table of 40 variable-length lists of integers.
    getAlignmentPatternPositions() {
      if (this.version == 1)
        return [];
      else {
        const numAlign = Math.floor(this.version / 7) + 2;
        const step = this.version == 32 ? 26 : Math.ceil((this.version * 4 + 4) / (numAlign * 2 - 2)) * 2;
        let result = [6];
        for (let pos = this.size - 7; result.length < numAlign; pos -= step)
          result.splice(1, 0, pos);
        return result;
      }
    }
    // Returns the number of data bits that can be stored in a QR Code of the given version number, after
    // all function modules are excluded. This includes remainder bits, so it might not be a multiple of 8.
    // The result is in the range [208, 29648]. This could be implemented as a 40-entry lookup table.
    static getNumRawDataModules(ver) {
      if (ver < _QrCode.MIN_VERSION || ver > _QrCode.MAX_VERSION)
        throw new RangeError("Version number out of range");
      let result = (16 * ver + 128) * ver + 64;
      if (ver >= 2) {
        const numAlign = Math.floor(ver / 7) + 2;
        result -= (25 * numAlign - 10) * numAlign - 55;
        if (ver >= 7)
          result -= 36;
      }
      assert(208 <= result && result <= 29648);
      return result;
    }
    // Returns the number of 8-bit data (i.e. not error correction) codewords contained in any
    // QR Code of the given version number and error correction level, with remainder bits discarded.
    // This stateless pure function could be implemented as a (40*4)-cell lookup table.
    static getNumDataCodewords(ver, ecl) {
      return Math.floor(_QrCode.getNumRawDataModules(ver) / 8) - _QrCode.ECC_CODEWORDS_PER_BLOCK[ecl.ordinal][ver] * _QrCode.NUM_ERROR_CORRECTION_BLOCKS[ecl.ordinal][ver];
    }
    // Returns a Reed-Solomon ECC generator polynomial for the given degree. This could be
    // implemented as a lookup table over all possible parameter values, instead of as an algorithm.
    static reedSolomonComputeDivisor(degree) {
      if (degree < 1 || degree > 255)
        throw new RangeError("Degree out of range");
      let result = [];
      for (let i = 0; i < degree - 1; i++)
        result.push(0);
      result.push(1);
      let root = 1;
      for (let i = 0; i < degree; i++) {
        for (let j = 0; j < result.length; j++) {
          result[j] = _QrCode.reedSolomonMultiply(result[j], root);
          if (j + 1 < result.length)
            result[j] ^= result[j + 1];
        }
        root = _QrCode.reedSolomonMultiply(root, 2);
      }
      return result;
    }
    // Returns the Reed-Solomon error correction codeword for the given data and divisor polynomials.
    static reedSolomonComputeRemainder(data, divisor) {
      let result = divisor.map((_) => 0);
      for (const b of data) {
        const factor = b ^ result.shift();
        result.push(0);
        divisor.forEach((coef, i) => result[i] ^= _QrCode.reedSolomonMultiply(coef, factor));
      }
      return result;
    }
    // Returns the product of the two given field elements modulo GF(2^8/0x11D). The arguments and result
    // are unsigned 8-bit integers. This could be implemented as a lookup table of 256*256 entries of uint8.
    static reedSolomonMultiply(x, y) {
      if (x >>> 8 != 0 || y >>> 8 != 0)
        throw new RangeError("Byte out of range");
      let z = 0;
      for (let i = 7; i >= 0; i--) {
        z = z << 1 ^ (z >>> 7) * 285;
        z ^= (y >>> i & 1) * x;
      }
      assert(z >>> 8 == 0);
      return z;
    }
    // Can only be called immediately after a light run is added, and
    // returns either 0, 1, or 2. A helper function for getPenaltyScore().
    finderPenaltyCountPatterns(runHistory) {
      const n = runHistory[1];
      assert(n <= this.size * 3);
      const core = n > 0 && runHistory[2] == n && runHistory[3] == n * 3 && runHistory[4] == n && runHistory[5] == n;
      return (core && runHistory[0] >= n * 4 && runHistory[6] >= n ? 1 : 0) + (core && runHistory[6] >= n * 4 && runHistory[0] >= n ? 1 : 0);
    }
    // Must be called at the end of a line (row or column) of modules. A helper function for getPenaltyScore().
    finderPenaltyTerminateAndCount(currentRunColor, currentRunLength, runHistory) {
      if (currentRunColor) {
        this.finderPenaltyAddHistory(currentRunLength, runHistory);
        currentRunLength = 0;
      }
      currentRunLength += this.size;
      this.finderPenaltyAddHistory(currentRunLength, runHistory);
      return this.finderPenaltyCountPatterns(runHistory);
    }
    // Pushes the given value to the front and drops the last value. A helper function for getPenaltyScore().
    finderPenaltyAddHistory(currentRunLength, runHistory) {
      if (runHistory[0] == 0)
        currentRunLength += this.size;
      runHistory.pop();
      runHistory.unshift(currentRunLength);
    }
  };
  /*-- Constants and tables --*/
  // The minimum version number supported in the QR Code Model 2 standard.
  _QrCode.MIN_VERSION = 1;
  // The maximum version number supported in the QR Code Model 2 standard.
  _QrCode.MAX_VERSION = 40;
  // For use in getPenaltyScore(), when evaluating which mask is best.
  _QrCode.PENALTY_N1 = 3;
  _QrCode.PENALTY_N2 = 3;
  _QrCode.PENALTY_N3 = 40;
  _QrCode.PENALTY_N4 = 10;
  _QrCode.ECC_CODEWORDS_PER_BLOCK = [
    // Version: (note that index 0 is for padding, and is set to an illegal value)
    //0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40    Error correction level
    [-1, 7, 10, 15, 20, 26, 18, 20, 24, 30, 18, 20, 24, 26, 30, 22, 24, 28, 30, 28, 28, 28, 28, 30, 30, 26, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30],
    // Low
    [-1, 10, 16, 26, 18, 24, 16, 18, 22, 22, 26, 30, 22, 22, 24, 24, 28, 28, 26, 26, 26, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28],
    // Medium
    [-1, 13, 22, 18, 26, 18, 24, 18, 22, 20, 24, 28, 26, 24, 20, 30, 24, 28, 28, 26, 30, 28, 30, 30, 30, 30, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30],
    // Quartile
    [-1, 17, 28, 22, 16, 22, 28, 26, 26, 24, 28, 24, 28, 22, 24, 24, 30, 28, 28, 26, 28, 30, 24, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30]
    // High
  ];
  _QrCode.NUM_ERROR_CORRECTION_BLOCKS = [
    // Version: (note that index 0 is for padding, and is set to an illegal value)
    //0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40    Error correction level
    [-1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 4, 4, 4, 4, 4, 6, 6, 6, 6, 7, 8, 8, 9, 9, 10, 12, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 24, 25],
    // Low
    [-1, 1, 1, 1, 2, 2, 4, 4, 4, 5, 5, 5, 8, 9, 9, 10, 10, 11, 13, 14, 16, 17, 17, 18, 20, 21, 23, 25, 26, 28, 29, 31, 33, 35, 37, 38, 40, 43, 45, 47, 49],
    // Medium
    [-1, 1, 1, 2, 2, 4, 4, 6, 6, 8, 8, 8, 10, 12, 16, 12, 17, 16, 18, 21, 20, 23, 23, 25, 27, 29, 34, 34, 35, 38, 40, 43, 45, 48, 51, 53, 56, 59, 62, 65, 68],
    // Quartile
    [-1, 1, 1, 2, 4, 4, 4, 5, 6, 8, 8, 11, 11, 16, 16, 18, 16, 19, 21, 25, 25, 25, 34, 30, 32, 35, 37, 40, 42, 45, 48, 51, 54, 57, 60, 63, 66, 70, 74, 77, 81]
    // High
  ];
  qrcodegen2.QrCode = _QrCode;
  function appendBits(val, len, bb) {
    if (len < 0 || len > 31 || val >>> len != 0)
      throw new RangeError("Value out of range");
    for (let i = len - 1; i >= 0; i--)
      bb.push(val >>> i & 1);
  }
  function getBit(x, i) {
    return (x >>> i & 1) != 0;
  }
  function assert(cond) {
    if (!cond)
      throw new Error("Assertion error");
  }
  const _QrSegment = class _QrSegment {
    /*-- Constructor (low level) and fields --*/
    // Creates a new QR Code segment with the given attributes and data.
    // The character count (numChars) must agree with the mode and the bit buffer length,
    // but the constraint isn't checked. The given bit buffer is cloned and stored.
    constructor(mode, numChars, bitData) {
      this.mode = mode;
      this.numChars = numChars;
      this.bitData = bitData;
      if (numChars < 0)
        throw new RangeError("Invalid argument");
      this.bitData = bitData.slice();
    }
    /*-- Static factory functions (mid level) --*/
    // Returns a segment representing the given binary data encoded in
    // byte mode. All input byte arrays are acceptable. Any text string
    // can be converted to UTF-8 bytes and encoded as a byte mode segment.
    static makeBytes(data) {
      let bb = [];
      for (const b of data)
        appendBits(b, 8, bb);
      return new _QrSegment(_QrSegment.Mode.BYTE, data.length, bb);
    }
    // Returns a segment representing the given string of decimal digits encoded in numeric mode.
    static makeNumeric(digits) {
      if (!_QrSegment.isNumeric(digits))
        throw new RangeError("String contains non-numeric characters");
      let bb = [];
      for (let i = 0; i < digits.length; ) {
        const n = Math.min(digits.length - i, 3);
        appendBits(parseInt(digits.substring(i, i + n), 10), n * 3 + 1, bb);
        i += n;
      }
      return new _QrSegment(_QrSegment.Mode.NUMERIC, digits.length, bb);
    }
    // Returns a segment representing the given text string encoded in alphanumeric mode.
    // The characters allowed are: 0 to 9, A to Z (uppercase only), space,
    // dollar, percent, asterisk, plus, hyphen, period, slash, colon.
    static makeAlphanumeric(text) {
      if (!_QrSegment.isAlphanumeric(text))
        throw new RangeError("String contains unencodable characters in alphanumeric mode");
      let bb = [];
      let i;
      for (i = 0; i + 2 <= text.length; i += 2) {
        let temp = _QrSegment.ALPHANUMERIC_CHARSET.indexOf(text.charAt(i)) * 45;
        temp += _QrSegment.ALPHANUMERIC_CHARSET.indexOf(text.charAt(i + 1));
        appendBits(temp, 11, bb);
      }
      if (i < text.length)
        appendBits(_QrSegment.ALPHANUMERIC_CHARSET.indexOf(text.charAt(i)), 6, bb);
      return new _QrSegment(_QrSegment.Mode.ALPHANUMERIC, text.length, bb);
    }
    // Returns a new mutable list of zero or more segments to represent the given Unicode text string.
    // The result may use various segment modes and switch modes to optimize the length of the bit stream.
    static makeSegments(text) {
      if (text == "")
        return [];
      else if (_QrSegment.isNumeric(text))
        return [_QrSegment.makeNumeric(text)];
      else if (_QrSegment.isAlphanumeric(text))
        return [_QrSegment.makeAlphanumeric(text)];
      else
        return [_QrSegment.makeBytes(_QrSegment.toUtf8ByteArray(text))];
    }
    // Returns a segment representing an Extended Channel Interpretation
    // (ECI) designator with the given assignment value.
    static makeEci(assignVal) {
      let bb = [];
      if (assignVal < 0)
        throw new RangeError("ECI assignment value out of range");
      else if (assignVal < 1 << 7)
        appendBits(assignVal, 8, bb);
      else if (assignVal < 1 << 14) {
        appendBits(2, 2, bb);
        appendBits(assignVal, 14, bb);
      } else if (assignVal < 1e6) {
        appendBits(6, 3, bb);
        appendBits(assignVal, 21, bb);
      } else
        throw new RangeError("ECI assignment value out of range");
      return new _QrSegment(_QrSegment.Mode.ECI, 0, bb);
    }
    // Tests whether the given string can be encoded as a segment in numeric mode.
    // A string is encodable iff each character is in the range 0 to 9.
    static isNumeric(text) {
      return _QrSegment.NUMERIC_REGEX.test(text);
    }
    // Tests whether the given string can be encoded as a segment in alphanumeric mode.
    // A string is encodable iff each character is in the following set: 0 to 9, A to Z
    // (uppercase only), space, dollar, percent, asterisk, plus, hyphen, period, slash, colon.
    static isAlphanumeric(text) {
      return _QrSegment.ALPHANUMERIC_REGEX.test(text);
    }
    /*-- Methods --*/
    // Returns a new copy of the data bits of this segment.
    getData() {
      return this.bitData.slice();
    }
    // (Package-private) Calculates and returns the number of bits needed to encode the given segments at
    // the given version. The result is infinity if a segment has too many characters to fit its length field.
    static getTotalBits(segs, version) {
      let result = 0;
      for (const seg of segs) {
        const ccbits = seg.mode.numCharCountBits(version);
        if (seg.numChars >= 1 << ccbits)
          return Infinity;
        result += 4 + ccbits + seg.bitData.length;
      }
      return result;
    }
    // Returns a new array of bytes representing the given string encoded in UTF-8.
    static toUtf8ByteArray(str) {
      str = encodeURI(str);
      let result = [];
      for (let i = 0; i < str.length; i++) {
        if (str.charAt(i) != "%")
          result.push(str.charCodeAt(i));
        else {
          result.push(parseInt(str.substring(i + 1, i + 3), 16));
          i += 2;
        }
      }
      return result;
    }
  };
  /*-- Constants --*/
  // Describes precisely all strings that are encodable in numeric mode.
  _QrSegment.NUMERIC_REGEX = /^[0-9]*$/;
  // Describes precisely all strings that are encodable in alphanumeric mode.
  _QrSegment.ALPHANUMERIC_REGEX = /^[A-Z0-9 $%*+.\/:-]*$/;
  // The set of all legal characters in alphanumeric mode,
  // where each character value maps to the index in the string.
  _QrSegment.ALPHANUMERIC_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";
  let QrSegment = _QrSegment;
  qrcodegen2.QrSegment = _QrSegment;
})(qrcodegen || (qrcodegen = {}));
((qrcodegen2) => {
  ((QrCode2) => {
    const _Ecc = class _Ecc {
      // The QR Code can tolerate about 30% erroneous codewords
      /*-- Constructor and fields --*/
      constructor(ordinal, formatBits) {
        this.ordinal = ordinal;
        this.formatBits = formatBits;
      }
    };
    /*-- Constants --*/
    _Ecc.LOW = new _Ecc(0, 1);
    // The QR Code can tolerate about  7% erroneous codewords
    _Ecc.MEDIUM = new _Ecc(1, 0);
    // The QR Code can tolerate about 15% erroneous codewords
    _Ecc.QUARTILE = new _Ecc(2, 3);
    // The QR Code can tolerate about 25% erroneous codewords
    _Ecc.HIGH = new _Ecc(3, 2);
    QrCode2.Ecc = _Ecc;
  })(qrcodegen2.QrCode || (qrcodegen2.QrCode = {}));
})(qrcodegen || (qrcodegen = {}));
((qrcodegen2) => {
  ((QrSegment2) => {
    const _Mode = class _Mode {
      /*-- Constructor and fields --*/
      constructor(modeBits, numBitsCharCount) {
        this.modeBits = modeBits;
        this.numBitsCharCount = numBitsCharCount;
      }
      /*-- Method --*/
      // (Package-private) Returns the bit width of the character count field for a segment in
      // this mode in a QR Code at the given version number. The result is in the range [0, 16].
      numCharCountBits(ver) {
        return this.numBitsCharCount[Math.floor((ver + 7) / 17)];
      }
    };
    /*-- Constants --*/
    _Mode.NUMERIC = new _Mode(1, [10, 12, 14]);
    _Mode.ALPHANUMERIC = new _Mode(2, [9, 11, 13]);
    _Mode.BYTE = new _Mode(4, [8, 16, 16]);
    _Mode.KANJI = new _Mode(8, [8, 10, 12]);
    _Mode.ECI = new _Mode(7, [0, 0, 0]);
    QrSegment2.Mode = _Mode;
  })(qrcodegen2.QrSegment || (qrcodegen2.QrSegment = {}));
})(qrcodegen || (qrcodegen = {}));
var qrcodegen_default = qrcodegen;

// src/index.tsx
/**
 * @license qrcode.react
 * Copyright (c) Paul O'Shannessy
 * SPDX-License-Identifier: ISC
 */
var ERROR_LEVEL_MAP = {
  L: qrcodegen_default.QrCode.Ecc.LOW,
  M: qrcodegen_default.QrCode.Ecc.MEDIUM,
  Q: qrcodegen_default.QrCode.Ecc.QUARTILE,
  H: qrcodegen_default.QrCode.Ecc.HIGH
};
var DEFAULT_SIZE = 128;
var DEFAULT_LEVEL = "L";
var DEFAULT_BGCOLOR = "#FFFFFF";
var DEFAULT_FGCOLOR = "#000000";
var DEFAULT_INCLUDEMARGIN = false;
var DEFAULT_MINVERSION = 1;
var SPEC_MARGIN_SIZE = 4;
var DEFAULT_MARGIN_SIZE = 0;
var DEFAULT_IMG_SCALE = 0.1;
function generatePath(modules, margin = 0) {
  const ops = [];
  modules.forEach(function(row, y) {
    let start = null;
    row.forEach(function(cell, x) {
      if (!cell && start !== null) {
        ops.push(
          `M${start + margin} ${y + margin}h${x - start}v1H${start + margin}z`
        );
        start = null;
        return;
      }
      if (x === row.length - 1) {
        if (!cell) {
          return;
        }
        if (start === null) {
          ops.push(`M${x + margin},${y + margin} h1v1H${x + margin}z`);
        } else {
          ops.push(
            `M${start + margin},${y + margin} h${x + 1 - start}v1H${start + margin}z`
          );
        }
        return;
      }
      if (cell && start === null) {
        start = x;
      }
    });
  });
  return ops.join("");
}
function excavateModules(modules, excavation) {
  return modules.slice().map((row, y) => {
    if (y < excavation.y || y >= excavation.y + excavation.h) {
      return row;
    }
    return row.map((cell, x) => {
      if (x < excavation.x || x >= excavation.x + excavation.w) {
        return cell;
      }
      return false;
    });
  });
}
function getImageSettings(cells, size, margin, imageSettings) {
  if (imageSettings == null) {
    return null;
  }
  const numCells = cells.length + margin * 2;
  const defaultSize = Math.floor(size * DEFAULT_IMG_SCALE);
  const scale = numCells / size;
  const w = (imageSettings.width || defaultSize) * scale;
  const h = (imageSettings.height || defaultSize) * scale;
  const x = imageSettings.x == null ? cells.length / 2 - w / 2 : imageSettings.x * scale;
  const y = imageSettings.y == null ? cells.length / 2 - h / 2 : imageSettings.y * scale;
  const opacity = imageSettings.opacity == null ? 1 : imageSettings.opacity;
  let excavation = null;
  if (imageSettings.excavate) {
    let floorX = Math.floor(x);
    let floorY = Math.floor(y);
    let ceilW = Math.ceil(w + x - floorX);
    let ceilH = Math.ceil(h + y - floorY);
    excavation = { x: floorX, y: floorY, w: ceilW, h: ceilH };
  }
  const crossOrigin = imageSettings.crossOrigin;
  return { x, y, h, w, excavation, opacity, crossOrigin };
}
function getMarginSize(includeMargin, marginSize) {
  if (marginSize != null) {
    return Math.max(Math.floor(marginSize), 0);
  }
  return includeMargin ? SPEC_MARGIN_SIZE : DEFAULT_MARGIN_SIZE;
}
function useQRCode({
  value,
  level,
  minVersion,
  includeMargin,
  marginSize,
  imageSettings,
  size,
  boostLevel
}) {
  let qrcode = SP_REACT.useMemo(() => {
    const values = Array.isArray(value) ? value : [value];
    const segments = values.reduce((accum, v) => {
      accum.push(...qrcodegen_default.QrSegment.makeSegments(v));
      return accum;
    }, []);
    return qrcodegen_default.QrCode.encodeSegments(
      segments,
      ERROR_LEVEL_MAP[level],
      minVersion,
      void 0,
      void 0,
      boostLevel
    );
  }, [value, level, minVersion, boostLevel]);
  const { cells, margin, numCells, calculatedImageSettings } = SP_REACT.useMemo(() => {
    let cells2 = qrcode.getModules();
    const margin2 = getMarginSize(includeMargin, marginSize);
    const numCells2 = cells2.length + margin2 * 2;
    const calculatedImageSettings2 = getImageSettings(
      cells2,
      size,
      margin2,
      imageSettings
    );
    return {
      cells: cells2,
      margin: margin2,
      numCells: numCells2,
      calculatedImageSettings: calculatedImageSettings2
    };
  }, [qrcode, size, imageSettings, includeMargin, marginSize]);
  return {
    qrcode,
    margin,
    cells,
    numCells,
    calculatedImageSettings
  };
}
var SUPPORTS_PATH2D = function() {
  try {
    new Path2D().addPath(new Path2D());
  } catch (e) {
    return false;
  }
  return true;
}();
var QRCodeCanvas = SP_REACT.forwardRef(
  function QRCodeCanvas2(props, forwardedRef) {
    const _a = props, {
      value,
      size = DEFAULT_SIZE,
      level = DEFAULT_LEVEL,
      bgColor = DEFAULT_BGCOLOR,
      fgColor = DEFAULT_FGCOLOR,
      includeMargin = DEFAULT_INCLUDEMARGIN,
      minVersion = DEFAULT_MINVERSION,
      boostLevel,
      marginSize,
      imageSettings
    } = _a, extraProps = __objRest(_a, [
      "value",
      "size",
      "level",
      "bgColor",
      "fgColor",
      "includeMargin",
      "minVersion",
      "boostLevel",
      "marginSize",
      "imageSettings"
    ]);
    const _b = extraProps, { style } = _b, otherProps = __objRest(_b, ["style"]);
    const imgSrc = imageSettings == null ? void 0 : imageSettings.src;
    const _canvas = SP_REACT.useRef(null);
    const _image = SP_REACT.useRef(null);
    const setCanvasRef = SP_REACT.useCallback(
      (node) => {
        _canvas.current = node;
        if (typeof forwardedRef === "function") {
          forwardedRef(node);
        } else if (forwardedRef) {
          forwardedRef.current = node;
        }
      },
      [forwardedRef]
    );
    const [isImgLoaded, setIsImageLoaded] = SP_REACT.useState(false);
    const { margin, cells, numCells, calculatedImageSettings } = useQRCode({
      value,
      level,
      minVersion,
      boostLevel,
      includeMargin,
      marginSize,
      imageSettings,
      size
    });
    SP_REACT.useEffect(() => {
      if (_canvas.current != null) {
        const canvas = _canvas.current;
        const ctx = canvas.getContext("2d");
        if (!ctx) {
          return;
        }
        let cellsToDraw = cells;
        const image = _image.current;
        const haveImageToRender = calculatedImageSettings != null && image !== null && image.complete && image.naturalHeight !== 0 && image.naturalWidth !== 0;
        if (haveImageToRender) {
          if (calculatedImageSettings.excavation != null) {
            cellsToDraw = excavateModules(
              cells,
              calculatedImageSettings.excavation
            );
          }
        }
        const pixelRatio = window.devicePixelRatio || 1;
        canvas.height = canvas.width = size * pixelRatio;
        const scale = size / numCells * pixelRatio;
        ctx.scale(scale, scale);
        ctx.fillStyle = bgColor;
        ctx.fillRect(0, 0, numCells, numCells);
        ctx.fillStyle = fgColor;
        if (SUPPORTS_PATH2D) {
          ctx.fill(new Path2D(generatePath(cellsToDraw, margin)));
        } else {
          cells.forEach(function(row, rdx) {
            row.forEach(function(cell, cdx) {
              if (cell) {
                ctx.fillRect(cdx + margin, rdx + margin, 1, 1);
              }
            });
          });
        }
        if (calculatedImageSettings) {
          ctx.globalAlpha = calculatedImageSettings.opacity;
        }
        if (haveImageToRender) {
          ctx.drawImage(
            image,
            calculatedImageSettings.x + margin,
            calculatedImageSettings.y + margin,
            calculatedImageSettings.w,
            calculatedImageSettings.h
          );
        }
      }
    });
    SP_REACT.useEffect(() => {
      setIsImageLoaded(false);
    }, [imgSrc]);
    const canvasStyle = __spreadValues({ height: size, width: size }, style);
    let img = null;
    if (imgSrc != null) {
      img = /* @__PURE__ */ SP_REACT.createElement(
        "img",
        {
          src: imgSrc,
          key: imgSrc,
          style: { display: "none" },
          onLoad: () => {
            setIsImageLoaded(true);
          },
          ref: _image,
          crossOrigin: calculatedImageSettings == null ? void 0 : calculatedImageSettings.crossOrigin
        }
      );
    }
    return /* @__PURE__ */ SP_REACT.createElement(SP_REACT.Fragment, null, /* @__PURE__ */ SP_REACT.createElement(
      "canvas",
      __spreadValues({
        style: canvasStyle,
        height: size,
        width: size,
        ref: setCanvasRef,
        role: "img"
      }, otherProps)
    ), img);
  }
);
QRCodeCanvas.displayName = "QRCodeCanvas";
var QRCodeSVG = SP_REACT.forwardRef(
  function QRCodeSVG2(props, forwardedRef) {
    const _a = props, {
      value,
      size = DEFAULT_SIZE,
      level = DEFAULT_LEVEL,
      bgColor = DEFAULT_BGCOLOR,
      fgColor = DEFAULT_FGCOLOR,
      includeMargin = DEFAULT_INCLUDEMARGIN,
      minVersion = DEFAULT_MINVERSION,
      boostLevel,
      title,
      marginSize,
      imageSettings
    } = _a, otherProps = __objRest(_a, [
      "value",
      "size",
      "level",
      "bgColor",
      "fgColor",
      "includeMargin",
      "minVersion",
      "boostLevel",
      "title",
      "marginSize",
      "imageSettings"
    ]);
    const { margin, cells, numCells, calculatedImageSettings } = useQRCode({
      value,
      level,
      minVersion,
      boostLevel,
      includeMargin,
      marginSize,
      imageSettings,
      size
    });
    let cellsToDraw = cells;
    let image = null;
    if (imageSettings != null && calculatedImageSettings != null) {
      if (calculatedImageSettings.excavation != null) {
        cellsToDraw = excavateModules(
          cells,
          calculatedImageSettings.excavation
        );
      }
      image = /* @__PURE__ */ SP_REACT.createElement(
        "image",
        {
          href: imageSettings.src,
          height: calculatedImageSettings.h,
          width: calculatedImageSettings.w,
          x: calculatedImageSettings.x + margin,
          y: calculatedImageSettings.y + margin,
          preserveAspectRatio: "none",
          opacity: calculatedImageSettings.opacity,
          crossOrigin: calculatedImageSettings.crossOrigin
        }
      );
    }
    const fgPath = generatePath(cellsToDraw, margin);
    return /* @__PURE__ */ SP_REACT.createElement(
      "svg",
      __spreadValues({
        height: size,
        width: size,
        viewBox: `0 0 ${numCells} ${numCells}`,
        ref: forwardedRef,
        role: "img"
      }, otherProps),
      !!title && /* @__PURE__ */ SP_REACT.createElement("title", null, title),
      /* @__PURE__ */ SP_REACT.createElement(
        "path",
        {
          fill: bgColor,
          d: `M0,0 h${numCells}v${numCells}H0z`,
          shapeRendering: "crispEdges"
        }
      ),
      /* @__PURE__ */ SP_REACT.createElement("path", { fill: fgColor, d: fgPath, shapeRendering: "crispEdges" }),
      image
    );
  }
);
QRCodeSVG.displayName = "QRCodeSVG";

const navLink = (url) => {
    DFL.Navigation.CloseSideMenus();
    DFL.Navigation.NavigateToExternalWeb(url);
};
const showQrModal = (url) => {
    DFL.showModal(window.SP_REACT.createElement(DFL.ModalRoot, null,
        window.SP_REACT.createElement(QRCodeSVG, { style: { margin: '0 auto 1.5em auto' }, value: url, marginSize: 1, size: 256 }),
        window.SP_REACT.createElement("span", { style: { textAlign: 'center', wordBreak: 'break-word' } }, url)), window);
};
const PanelSocialButton = ({ children, url }) => (window.SP_REACT.createElement(DFL.PanelSectionRow, null,
    window.SP_REACT.createElement(DFL.Field, { bottomSeparator: "none", icon: null, label: null, childrenLayout: undefined, inlineWrap: "keep-inline", padding: "none", spacingBetweenLabelAndChild: "none", childrenContainerWidth: "max" },
        window.SP_REACT.createElement(DFL.Focusable, { style: { display: 'flex' } },
            window.SP_REACT.createElement(DFL.DialogButton, { onClick: () => navLink(url), onSecondaryButton: () => showQrModal(url), onSecondaryActionDescription: "Press to win" }, children),
            window.SP_REACT.createElement(DFL.DialogButton, { onOKActionDescription: t$1("settings_social_button_description"), onClick: () => showQrModal(url), style: {
                    display: 'flex',
                    justifyContent: 'center',
                    alignItems: 'center',
                    padding: '10px',
                    maxWidth: '40px',
                    minWidth: 'auto',
                    marginLeft: '.5em',
                } },
                window.SP_REACT.createElement("svg", { width: "20px", height: "20px", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                    window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M8.56301 1.2002H3.39768C2.7752 1.20089 2.17841 1.44848 1.73825 1.88864C1.29808 2.3288 1.0505 2.92559 1.0498 3.54807V8.7134C1.0505 9.33588 1.29808 9.93267 1.73825 10.3728C2.17841 10.813 2.7752 11.0606 3.39768 11.0613H8.56301C9.18549 11.0606 9.78228 10.813 10.2224 10.3728C10.6626 9.93267 10.9102 9.33588 10.9109 8.7134V3.54807C10.9102 2.92559 10.6626 2.3288 10.2224 1.88864C9.78228 1.44848 9.18549 1.20089 8.56301 1.2002ZM8.09343 8.24382H3.86726V4.01765H8.09343V8.24382ZM8.56301 12.9385H3.39768C2.7752 12.9392 2.17841 13.1868 1.73825 13.6269C1.29808 14.0671 1.0505 14.6639 1.0498 15.2864V20.4517C1.0505 21.0742 1.29808 21.671 1.73825 22.1111C2.17841 22.5513 2.7752 22.7989 3.39768 22.7996H8.56301C9.18549 22.7989 9.78228 22.5513 10.2224 22.1111C10.6626 21.671 10.9102 21.0742 10.9109 20.4517V15.2864C10.9102 14.6639 10.6626 14.0671 10.2224 13.6269C9.78228 13.1868 9.18549 12.9392 8.56301 12.9385ZM8.09343 19.9821H3.86726V15.7559H8.09343V19.9821ZM15.1374 1.2002H20.3028C20.9252 1.20089 21.522 1.44848 21.9622 1.88864C22.4024 2.3288 22.6499 2.92559 22.6506 3.54807V8.7134C22.6499 9.33588 22.4024 9.93267 21.9622 10.3728C21.522 10.813 20.9252 11.0606 20.3028 11.0613H15.1374C14.5149 11.0606 13.9182 10.813 13.478 10.3728C13.0378 9.93267 12.7902 9.33588 12.7896 8.7134V3.54807C12.7902 2.92559 13.0378 2.3288 13.478 1.88864C13.9182 1.44848 14.5149 1.20089 15.1374 1.2002ZM15.607 8.24382H19.8332V4.01765H15.607V8.24382ZM14.1983 18.5734C14.5719 18.5734 14.9302 18.4249 15.1944 18.1608C15.4586 17.8966 15.607 17.5383 15.607 17.1647V14.3472C15.607 13.9736 15.4586 13.6153 15.1944 13.3511C14.9302 13.0869 14.5719 12.9385 14.1983 12.9385C13.8247 12.9385 13.4663 13.0869 13.2022 13.3511C12.938 13.6153 12.7896 13.9736 12.7896 14.3472V17.1647C12.7896 17.5383 12.938 17.8966 13.2022 18.1608C13.4664 18.4249 13.8247 18.5734 14.1983 18.5734ZM19.8332 14.8168H21.2419C21.6155 14.8168 21.9738 14.9652 22.238 15.2294C22.5022 15.4936 22.6506 15.8519 22.6506 16.2255C22.6506 16.5991 22.5022 16.9574 22.238 17.2216C21.9738 17.4858 21.6155 17.6342 21.2419 17.6342H19.8332V21.3908C19.8332 21.7644 19.6847 22.1227 19.4206 22.3869C19.1564 22.6511 18.7981 22.7995 18.4245 22.7996H14.1983C13.8247 22.7996 13.4663 22.6511 13.2022 22.3869C12.938 22.1228 12.7896 21.7644 12.7896 21.3908C12.7896 21.0172 12.938 20.6589 13.2022 20.3947C13.4663 20.1305 13.8247 19.9821 14.1983 19.9821H17.0157V14.3472C17.0157 13.9736 17.1641 13.6153 17.4283 13.3511C17.6925 13.0869 18.0508 12.9385 18.4245 12.9385C18.7981 12.9385 19.1564 13.0869 19.4206 13.3511C19.6848 13.6153 19.8332 13.9736 19.8332 14.3472V14.8168Z", fill: "currentColor" })))))));

class Input {
    constructor(shortcut) {
        this.onButtonsPressedListeners = [];
        this.keyPressingTime = Date.now();
        this.shortcutPressed = false;
        this.qamAndSteamDisabled = false;
        this.ignoreButtons = [19 /* Button.LEFT_TOUCHPAD_TOUCH */, 20 /* Button.RIGHT_TOUCHPAD_TOUCH */, 46 /* Button.LEFT_JOYSTICK_TOUCH */, 47 /* Button.RIGHT_JOYSTICK_TOUCH */]; //Ignore touch
        this.shortcut = shortcut;
        if (!Input.isSupported()) {
            return;
        }
        this.input_register = SteamClient.Input.RegisterForControllerStateChanges((changes) => {
            const buttons = [];
            for (const change of changes) {
                const lower_buttons = change.ulButtons.toString(2).padStart(32, "0").split('');
                for (const [index, value] of lower_buttons.entries()) {
                    if (value === '1') {
                        buttons.push(31 - index);
                        //console.log("l:", lower_buttons);
                    }
                }
                const upper_buttons = change.ulUpperButtons.toString(2).padStart(32, "0").split('');
                for (const [index, value] of upper_buttons.entries()) {
                    if (value === '1') {
                        buttons.push(63 - index);
                        //console.log("u:", upper_buttons);
                    }
                }
            }
            this.OnButtonsPressed(buttons);
        });
    }
    unregister() {
        this.input_register?.unregister();
    }
    OnButtonsPressed(buttons) {
        buttons = buttons.filter(item => !this.ignoreButtons.includes(item));
        if (this.shortcut.length === buttons.length && this.shortcut.every((value) => buttons.includes(value))) {
            if (this.shortcutPressed != true && Date.now() - this.keyPressingTime > 350) {
                if (buttons.includes(50 /* Button.QUICK_ACCESS_MENU */) || buttons.includes(13 /* Button.STEAM */)) {
                    DFL.Router.DisableHomeAndQuickAccessButtons();
                    this.qamAndSteamDisabled = true;
                }
                this.keyPressingTime = Date.now();
                this.shortcutPressed = true;
                //console.log("Shortcut pressed");
                this.onButtonsPressedListeners.forEach(callback => {
                    callback();
                });
            }
        }
        else {
            if (this.qamAndSteamDisabled != false &&
                (!buttons.includes(50 /* Button.QUICK_ACCESS_MENU */) || !buttons.includes(13 /* Button.STEAM */))) {
                this.qamAndSteamDisabled = false;
                setTimeout(() => {
                    DFL.Router.EnableHomeAndQuickAccessButtons();
                    //console.log("enable qam")
                }, 350);
            }
            if (this.shortcutPressed != false) {
                //console.log("Shortcut released")
                this.shortcutPressed = false;
            }
        }
    }
    onShortcutPressed(callback) {
        this.onButtonsPressedListeners.push(callback);
    }
    offShortcutPressed(callback) {
        const index = this.onButtonsPressedListeners.indexOf(callback);
        if (index !== -1) {
            this.onButtonsPressedListeners.splice(index, 1);
        }
    }
    static isSupported() {
        return SteamClient?.Input?.RegisterForControllerStateChanges != null;
    }
}

let sliderTimeoutId;
const buttonStyle = {
    height: "16px",
    width: "auto",
    marginBottom: "-4px"
};
const iconModesStyle = {
    display: "block",
    marginTop: "-4px",
    alignSelf: "center",
    minWidth: "24px"
};
const TabSettings = ({ backend }) => {
    const [sliderLowBattery, setSliderLowBattery] = SP_REACT.useState(-1);
    const [sliderLogLevel, setSliderLogLevel] = SP_REACT.useState(-1);
    const [toggleSwitchAncHotkey, setToggleSwitchAncHotkey] = SP_REACT.useState(false);
    const [toggleMicHotkey, setToggleMicHotkey] = SP_REACT.useState(false);
    const [toggleFixDisconnects, setToggleFixDisconnects] = SP_REACT.useState(false);
    const [toggleAncOff, setToggleAncOff] = SP_REACT.useState(false);
    const [toggleAncTransparency, setToggleAncTransparency] = SP_REACT.useState(false);
    const [toggleAncAdaptive, setToggleAncAdaptive] = SP_REACT.useState(false);
    const [toggleAncWind, setToggleAncWind] = SP_REACT.useState(false);
    const [toggleAncOn, setToggleAncOn] = SP_REACT.useState(false);
    const [availableLanguages, setAvailableLanguages] = SP_REACT.useState([]);
    const { i18n } = useTranslation();
    SP_REACT.useEffect(() => {
        const getSetting = async () => {
            setSliderLowBattery(await backend.loadNumberSetting("notif_low_battery") ?? -1);
            setSliderLogLevel(await backend.loadNumberSetting("log_level") ?? -1);
            setToggleSwitchAncHotkey(await backend.loadBooleanSetting("anc_l5_r5_switch"));
            setToggleFixDisconnects(await backend.loadBooleanSetting("fix_disconnects"));
            setToggleMicHotkey(await backend.loadBooleanSetting("mic_qam_l5_toggle"));
            setToggleAncOff(await backend.loadBooleanSetting("allow_anc_mode_off"));
            setToggleAncTransparency(await backend.loadBooleanSetting("allow_anc_mode_transparency"));
            setToggleAncAdaptive(await backend.loadBooleanSetting("allow_anc_mode_adaptive"));
            setToggleAncWind(await backend.loadBooleanSetting("allow_anc_mode_wind"));
            setToggleAncOn(await backend.loadBooleanSetting("allow_anc_mode_anc"));
        };
        getSetting();
        const availableLocales = Object.keys(instance.services.resourceStore.data);
        const updatedLanguageValue = availableLocales.map(locale => ({
            tag: locale,
            nativeName: new Intl.DisplayNames([locale], { type: 'language' }).of(locale) || locale
        }));
        backend.logDebug("Settings:", updatedLanguageValue);
        setAvailableLanguages(updatedLanguageValue);
    }, []);
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
        window.SP_REACT.createElement("div", { style: { marginLeft: "-8px", marginRight: "-8px" } },
            window.SP_REACT.createElement(DFL.PanelSection, { title: t$1("settings_header") },
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.SliderField, { value: sliderLowBattery, max: 100, min: 0, step: 1, label: t$1("settings_low_battery_label"), notchCount: 2, showValue: true, valueSuffix: "%", notchTicksVisible: false, notchLabels: [
                            { label: t$1("settings_low_battery_label_notchlabel_off"), notchIndex: 0, value: 0 },
                            { label: "", notchIndex: 1, value: 100 },
                        ], onChange: (n) => {
                            setSliderLowBattery(n);
                            if (sliderTimeoutId)
                                clearTimeout(sliderTimeoutId);
                            let starttime = Date.now();
                            sliderTimeoutId = setTimeout(async () => {
                                backend.logInfo("Settings: Elapsed", Date.now() - starttime, "Set low battery to", n);
                                await backend.saveSetting("notif_low_battery", n);
                            }, 350);
                        } })),
                !Input.isSupported() &&
                    window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                        window.SP_REACT.createElement("div", { className: DFL.staticClasses.Label, style: { paddingLeft: "0px", paddingRight: "0px" } },
                            window.SP_REACT.createElement(Trans, { i18nKey: "settings_hotkey_error", components: { Key1: window.SP_REACT.createElement(WARNING, { style: { height: "16px", width: "auto", marginBottom: "-3.5px", paddingRight: "0px" } }) } }))),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { disabled: !Input.isSupported(), checked: toggleSwitchAncHotkey, label: t$1("settings_hotkey_anc_label"), description: window.SP_REACT.createElement(Trans, { i18nKey: "settings_hotkey_anc_description", components: { key1: window.SP_REACT.createElement(QUICK_ACCESS_MENU, { style: buttonStyle }), key2: window.SP_REACT.createElement(L5, { style: buttonStyle }) } }), onChange: async (b) => {
                            setToggleSwitchAncHotkey(b);
                            await backend.saveSetting("anc_l5_r5_switch", b);
                            backend.bgAncSwitch.updateSetting();
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { disabled: !Input.isSupported(), checked: toggleMicHotkey, label: t$1("settings_hotkey_mic_label"), description: window.SP_REACT.createElement(Trans, { i18nKey: "settings_hotkey_mic_description", components: { key1: window.SP_REACT.createElement(QUICK_ACCESS_MENU, { style: buttonStyle }), key2: window.SP_REACT.createElement(L4, { style: buttonStyle }) } }), onChange: async (b) => {
                            setToggleMicHotkey(b);
                            await backend.saveSetting("mic_qam_l5_toggle", b);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleFixDisconnects, label: t$1("settings_fix_disconnects_label"), description: t$1("settings_fix_disconnects_description"), onChange: async (b) => {
                            setToggleFixDisconnects(b);
                            await backend.saveSetting("fix_disconnects", b);
                            backend.player.updateSetting();
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ButtonItem, { layout: "below", label: t$1("settings_language_button_label"), onClick: (e) => DFL.showContextMenu(window.SP_REACT.createElement(DFL.Menu, { label: t$1("settings_language_menu_label"), cancelText: t$1("settings_language_menu_canceltext"), onCancel: () => { } }, availableLanguages.map((lng) => (window.SP_REACT.createElement(DFL.MenuItem, { key: lng.tag, disabled: i18n.resolvedLanguage === lng.tag, onSelected: () => { i18n.changeLanguage(lng.tag); backend.logDebug(i18n.resolvedLanguage); } }, lng.nativeName)))), e.currentTarget ?? window) }, availableLanguages.find(lng => lng.tag == i18n.resolvedLanguage)?.nativeName || i18n.resolvedLanguage))),
            window.SP_REACT.createElement(DFL.PanelSection, { title: t$1("settings_anc_modes_header") },
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleAncOff, label: window.SP_REACT.createElement(Trans, { i18nKey: "settings_anc_modes_off_label", components: { icon: window.SP_REACT.createElement(ANC_MODE_OFF, { style: iconModesStyle }) } }), onChange: async (b) => {
                            setToggleAncOff(b);
                            await backend.saveSetting("allow_anc_mode_off", b);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleAncTransparency, label: window.SP_REACT.createElement(Trans, { i18nKey: "settings_anc_modes_transparency_label", components: { icon: window.SP_REACT.createElement(ANC_MODE_TRANSPARENCY, { style: iconModesStyle }) } }), onChange: async (b) => {
                            setToggleAncTransparency(b);
                            await backend.saveSetting("allow_anc_mode_transparency", b);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleAncAdaptive, label: window.SP_REACT.createElement(Trans, { i18nKey: "settings_anc_modes_adaptive_label", components: { icon: window.SP_REACT.createElement(ANC_MODE_ADAPTIVE, { style: iconModesStyle }) } }), onChange: async (b) => {
                            setToggleAncAdaptive(b);
                            await backend.saveSetting("allow_anc_mode_adaptive", b);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleAncWind, label: window.SP_REACT.createElement(Trans, { i18nKey: "settings_anc_modes_wind_label", components: { icon: window.SP_REACT.createElement(ANC_MODE_WIND, { style: iconModesStyle }) } }), onChange: async (b) => {
                            setToggleAncWind(b);
                            await backend.saveSetting("allow_anc_mode_wind", b);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ToggleField, { checked: toggleAncOn, label: window.SP_REACT.createElement(Trans, { i18nKey: "settings_anc_modes_anc_label", components: { icon: window.SP_REACT.createElement(ANC_MODE_ANC, { style: iconModesStyle }) } }), onChange: async (b) => {
                            setToggleAncOn(b);
                            await backend.saveSetting("allow_anc_mode_anc", b);
                        } }))),
            window.SP_REACT.createElement(DFL.PanelSection, { title: t$1("settings_misc_header") },
                window.SP_REACT.createElement(PanelSocialButton, { url: "https://magicpods.app/donate/" }, t$1("settings_social_button_donate")),
                window.SP_REACT.createElement(PanelSocialButton, { url: "https://magicpods.app/steamdeck/" }, t$1("settings_social_button_start")),
                window.SP_REACT.createElement(PanelSocialButton, { url: "https://weblate.magicpods.app/engage/magicpods-steamdeck/" }, t$1("settings_social_button_translate")),
                window.SP_REACT.createElement(PanelSocialButton, { url: "https://discord.com/invite/ARSm6CG7jf" }, "Discord")),
            window.SP_REACT.createElement(DFL.PanelSection, { title: t$1("settings_debug_header") },
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.SliderField, { value: 50 - sliderLogLevel, max: 50, min: 0, step: 10, label: t$1("settings_debug_level_label"), notchCount: 6, notchTicksVisible: true, notchLabels: [
                            { label: "Off", notchIndex: 0, value: 0 },
                            { label: "Err", notchIndex: 1, value: 10 },
                            { label: "Wrn", notchIndex: 2, value: 20 },
                            { label: "Inf", notchIndex: 3, value: 30 },
                            { label: "Dbg", notchIndex: 4, value: 40 },
                            { label: "TRC", notchIndex: 5, value: 50 },
                        ], onChange: (n) => {
                            const nn = 50 - n;
                            setSliderLogLevel(nn);
                            if (sliderTimeoutId)
                                clearTimeout(sliderTimeoutId);
                            let starttime = Date.now();
                            sliderTimeoutId = setTimeout(async () => {
                                backend.logInfo("Settings: Elapsed", Date.now() - starttime, "Set log level to", nn);
                                await backend.saveSetting("log_level", nn);
                                await call("update_log_level");
                                await backend.updateReactLogLevel();
                                await backend.updateBinaryLogLevel();
                            }, 350);
                        } })),
                window.SP_REACT.createElement(DFL.PanelSectionRow, null,
                    window.SP_REACT.createElement(DFL.ButtonItem, { layout: "below", bottomSeparator: "none", onClick: () => {
                            DFL.Navigation.CloseSideMenus();
                            DFL.Navigation.Navigate("/magicpods-log");
                        } }, t$1("settings_debug_log_button")))))));
};

class BackgroundAncSwitch {
    constructor(backend) {
        this.selected = 0;
        this.options = 0;
        this.address = "";
        this.enabled = false;
        this.connected = false;
        this.onJsonMessageReceived = (json) => {
            this.backend.logDebug("AncSwitch: Json message received");
            const typedJson = json;
            if (typedJson?.info == null)
                return;
            if (Object.keys(typedJson.info).length !== 0) {
                const info = typedJson.info;
                if (info.capabilities?.anc != null) {
                    if (this.selected !== info.capabilities.anc.selected)
                        this.selected = info.capabilities.anc.selected;
                    if (this.options !== info.capabilities.anc.options)
                        this.options = info.capabilities.anc.options;
                    if (this.address !== info.address)
                        this.address = info.address;
                    if (this.connected !== true)
                        this.connected = true;
                    this.register();
                }
            }
            else {
                this.unregister();
                this.selected = 0;
                this.options = 0;
                this.address = "";
                this.connected = false;
            }
        };
        this.onShortcutPressed = async () => {
            this.backend.logDebug("AncSwitch: Hotkey pressed");
            let isOff = await this.backend.loadBooleanSetting("allow_anc_mode_off");
            let isTransparency = await this.backend.loadBooleanSetting("allow_anc_mode_transparency");
            let isAdaptive = await this.backend.loadBooleanSetting("allow_anc_mode_adaptive");
            let isWind = await this.backend.loadBooleanSetting("allow_anc_mode_wind");
            let isAnc = await this.backend.loadBooleanSetting("allow_anc_mode_anc");
            this.backend.logDebug("AncSwitch: Options:", this.options, "Selected:", this.selected);
            let modes = [];
            if (isOff && (this.options & AncModes.OFF) != 0) {
                modes.push(AncModes.OFF);
            }
            if (isTransparency && (this.options & AncModes.TRANSPARENCY) != 0) {
                modes.push(AncModes.TRANSPARENCY);
            }
            if (isAdaptive && (this.options & AncModes.ADAPTIVE) != 0) {
                modes.push(AncModes.ADAPTIVE);
            }
            if (isWind && (this.options & AncModes.WIND) != 0) {
                modes.push(AncModes.WIND);
            }
            if (isAnc && (this.options & AncModes.ANC) != 0) {
                modes.push(AncModes.ANC);
            }
            this.backend.logDebug("AncSwitch: UI modes:", modes);
            if (modes.length <= 1)
                this.backend.logError("AncSwitch: Nothing to do: fewer than two modes selected.");
            let nextAnc = modes.find(x => x > this.selected);
            if (nextAnc === undefined) {
                nextAnc = modes[0];
            }
            this.backend.logInfo("AncSwitch: Next selected mode:", nextAnc);
            if (nextAnc !== 0) {
                this.backend.setAnc(this.address, nextAnc);
            }
        };
        this.backend = backend;
        this.backend.onJsonMessageReceived(this.onJsonMessageReceived);
        this.updateSetting();
    }
    async updateSetting() {
        this.enabled = await this.backend.loadBooleanSetting("anc_l5_r5_switch");
        this.backend.logInfo("AncSwitch: Update enabled option to:", this.enabled);
        // Make action only when headphones connected
        if (this.connected) {
            if (this.enabled) {
                this.register();
            }
            else {
                this.unregister();
            }
        }
    }
    // Manual unregister hotkey
    disable() {
        this.backend.offJsonMessageReceived(this.onJsonMessageReceived);
        this.unregister();
    }
    register() {
        if (this.enabled && this.input == null) {
            this.input = new Input([50 /* Button.QUICK_ACCESS_MENU */, 15 /* Button.L5 */]);
            this.input.onShortcutPressed(this.onShortcutPressed);
            this.backend.logDebug("AncSwitch: Hotkey registered");
        }
    }
    unregister() {
        if (this.input != null) {
            this.input.offShortcutPressed(this.onShortcutPressed);
            this.input.unregister();
            this.input = undefined;
            this.backend.logDebug("AncSwitch: Hotkey unregistered");
        }
    }
}

class Player {
    constructor(backend) {
        this.enabled = false;
        this.connected = false;
        this.onJsonMessageReceived = (json) => {
            this.backend.logDebug("Player: Json message received");
            const typedJson = json;
            if (typedJson?.info == null)
                return;
            if (Object.keys(typedJson.info).length !== 0) {
                if (this.connected !== true) {
                    this.connected = true;
                    this.register();
                }
            }
            else {
                if (this.connected !== false) {
                    this.connected = false;
                    this.unregister();
                }
            }
        };
        this.backend = backend;
        this.backend.onJsonMessageReceived(this.onJsonMessageReceived);
        this.updateSetting();
    }
    async updateSetting() {
        this.enabled = await this.backend.loadBooleanSetting("fix_disconnects");
        this.backend.logInfo("Player: Update enabled option to:", this.enabled);
        // Make action only when headphones connected
        if (this.connected) {
            if (this.enabled) {
                this.register();
            }
            else {
                this.unregister();
            }
        }
    }
    // Manual unregister hotkey
    disable() {
        this.backend.offJsonMessageReceived(this.onJsonMessageReceived);
        this.unregister();
    }
    async register() {
        if (this.enabled) {
            await call("play");
            this.backend.logDebug("Player: started");
        }
    }
    async unregister() {
        await call("stop");
        this.backend.logDebug("Player: stopped");
    }
}

class Backend {
    constructor() {
        this.logLevel = 0;
        this.socketState = -2 /* BackendSocketState.UNINSTANTIATED */;
        this.jsonMessageReceivedListeners = [];
        this.socketConnectionChangedListeners = [];
        this.allowReconnect = false;
        this.onOpenHandler = async (event) => {
            this.reconnectAttempts = Backend.maxAttempts;
            this.logInfo("Backend: Socket opened (", this.convert(this.socket.readyState), ")", event);
            this.notifySocketConnectionChanged(1 /* BackendSocketState.OPEN */);
        };
        this.onMessageHandler = (event) => {
            this.logInfo("Backend: Message received:", event.data);
            this.notifyJsonMessageReceivedListeners(event.data);
        };
        this.onCloseHandler = async (event) => {
            this.logInfo("Backend: Socket closed (", this.convert(this.socket.readyState), ")", event);
            if (!this.allowReconnect) {
                this.logError("Backend: Reconnecting is prohibited");
                this.notifySocketConnectionChanged(3 /* BackendSocketState.CLOSED */);
                return;
            }
            if (this.reconnectAttempts !== 0) {
                const isBackendAllowed = await call("backend_allowed");
                if (!isBackendAllowed) { // When user delete the plugin, we do not want to reconnect socket.
                    this.logError("Backend: Running backend is prohibited by python");
                    this.notifySocketConnectionChanged(3 /* BackendSocketState.CLOSED */);
                    return;
                }
                if (this.reconnectTimeoutId)
                    clearTimeout(this.reconnectTimeoutId);
                this.logInfo("Backend: Trying start bucked due socket closed");
                await call("start_backed");
                this.reconnectTimeoutId = setTimeout(async () => {
                    this.notifySocketConnectionChanged(0 /* BackendSocketState.CONNECTING */);
                    this.reconnectAttempts -= 1;
                    this.logInfo("Backend: Trying reconnecting socket due socket closed. Left attempts", this.reconnectAttempts);
                    this.socketConnect();
                }, 1000);
            }
            else {
                this.notifySocketConnectionChanged(-1 /* BackendSocketState.ERROR */);
            }
        };
        this.onErrorHandler = (error) => {
            this.logError("Backend: Socket error (", this.convert(this.socket.readyState), ")", error);
        };
        this.updateReactLogLevel().catch(console.error);
        this.bgAncSwitch = new BackgroundAncSwitch(this);
        this.player = new Player(this);
        this.connect();
    }
    //settings
    async loadSetting(key) {
        try {
            const response = await call("load_setting", key);
            return response;
        }
        catch (e) {
            this.logError("Backend: Exception while loading setting:", key, e);
            return null;
        }
    }
    async loadBooleanSetting(key) {
        const value = await this.loadSetting(key);
        return String(value).toLowerCase() === "true";
    }
    async loadNumberSetting(key) {
        const value = await this.loadSetting(key);
        const parsed = Number(value);
        if (isNaN(parsed)) {
            this.logError("Backend: Invalid number in setting:", key, value);
            return null;
        }
        return parsed;
    }
    async saveSetting(key, value) {
        try {
            const response = await call("save_setting", key, value);
            return response;
        }
        catch (e) {
            this.logError("Backend: Exception while saving setting:", key, e);
            return false;
        }
    }
    getSocketState() {
        return this.socketState;
    }
    connect() {
        this.allowReconnect = true;
        this.reconnectAttempts = Backend.maxAttempts;
        this.socketConnect();
    }
    disconnect() {
        this.allowReconnect = false;
        this.socketDisconnect();
    }
    socketConnect() {
        this.socketDisconnect();
        if (this.socket) {
            this.logDebug("Backend: RemoveEventListener from socket");
            this.socket.removeEventListener("open", this.onOpenHandler);
            this.socket.removeEventListener("message", this.onMessageHandler);
            this.socket.removeEventListener("close", this.onCloseHandler);
            this.socket.removeEventListener("error", this.onErrorHandler);
        }
        this.logDebug("Backend: Trying connect socket");
        this.socket = new WebSocket("ws://localhost:2020");
        this.socket.addEventListener("open", this.onOpenHandler);
        this.socket.addEventListener("message", this.onMessageHandler);
        this.socket.addEventListener("close", this.onCloseHandler);
        this.socket.addEventListener("error", this.onErrorHandler);
    }
    socketDisconnect() {
        if (this.socket) {
            if (this.socket.readyState == 1) { //open
                this.socket.close();
                this.logInfo('Backend: Socket disconnected');
            }
        }
    }
    onJsonMessageReceived(callback) {
        this.jsonMessageReceivedListeners.push(callback);
    }
    offJsonMessageReceived(callback) {
        const index = this.jsonMessageReceivedListeners.indexOf(callback);
        if (index !== -1) {
            this.jsonMessageReceivedListeners.splice(index, 1);
        }
    }
    notifyJsonMessageReceivedListeners(data) {
        if (!this.isJsonString(data)) {
            return;
        }
        const json = JSON.parse(data);
        this.jsonMessageReceivedListeners.forEach(callback => {
            callback(json);
        });
    }
    onSocketConnectionChanged(callback) {
        this.socketConnectionChangedListeners.push(callback);
    }
    offSocketConnectionChanged(callback) {
        const index = this.socketConnectionChangedListeners.indexOf(callback);
        if (index !== -1) {
            this.socketConnectionChangedListeners.splice(index, 1);
        }
    }
    notifySocketConnectionChanged(state) {
        if (this.socketState === state) {
            return;
        }
        this.logInfo("Backend: SocketState changed to", this.convert(state));
        this.socketState = state;
        this.socketConnectionChangedListeners.forEach(callback => {
            callback(this.socketState);
        });
    }
    isJsonString(str) {
        try {
            JSON.parse(str);
        }
        catch (e) {
            return false;
        }
        return true;
    }
    convert(n) {
        switch (n) {
            case -1:
                return "error";
            case 0:
                return "connecting";
            case 1:
                return "open";
            case 2:
                return "closing";
            case 3:
                return "closed";
            default:
                return "unknown";
        }
    }
    sendToSocket(str) {
        if (this.socket.readyState == 1) { //open
            this.logInfo("Backend: Sending:", str);
            this.socket.send(str);
        }
        else {
            this.logError("Backend: Failed (readyState:", this.socket.readyState, "socketState:", this.socketState, ") to send:", str);
        }
    }
    // Methods
    getAll() {
        const json = {
            method: "GetAll"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    getInfo() {
        const json = {
            method: "GetDeckyInfo"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    getDevices() {
        const json = {
            method: "GetDevices"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    getDefaultBluetoothAdapter() {
        const json = {
            method: "GetDefaultBluetoothAdapter"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    connectDevice(address) {
        const json = {
            method: "ConnectDevice",
            arguments: {
                address: address
            }
        };
        this.sendToSocket(JSON.stringify(json));
    }
    disconnectDevice(address) {
        const json = {
            method: "DisconnectDevice",
            arguments: {
                address: address
            }
        };
        this.sendToSocket(JSON.stringify(json));
    }
    enableDefaultBluetoothAdapter() {
        const json = {
            method: "EnableDefaultBluetoothAdapter"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    disableDefaultBluetoothAdapter() {
        const json = {
            method: "DisableDefaultBluetoothAdapter"
        };
        this.sendToSocket(JSON.stringify(json));
    }
    setAnc(address, value) {
        const json = {
            method: "SetCapabilities",
            arguments: {
                address: address,
                capabilities: {
                    anc: {
                        selected: value
                    }
                }
            }
        };
        this.sendToSocket(JSON.stringify(json));
    }
    setCapability(capability, address, value) {
        const json = {
            method: "SetCapabilities",
            arguments: {
                address: address,
                capabilities: {
                    [capability]: {
                        selected: value
                    }
                }
            }
        };
        this.sendToSocket(JSON.stringify(json));
    }
    SetLogLevel(value) {
        const json = {
            method: "SetLogLevel",
            arguments: {
                selected: value,
            }
        };
        this.sendToSocket(JSON.stringify(json));
    }
    // Custom logger
    async updateBinaryLogLevel() {
        let option = await this.loadNumberSetting("log_level") ?? 0;
        this.SetLogLevel(option);
    }
    async updateReactLogLevel() {
        let option = await this.loadNumberSetting("log_level") ?? 0;
        this.logLevel = option;
        this.logCritical("Set log level to", option);
    }
    convertToString(...args) {
        var message = "";
        for (var i = 0; i < args.length; ++i) {
            if (typeof args[i] == 'object') {
                message += (JSON && JSON.stringify ? JSON.stringify(args[i]) : String(args[i]));
            }
            else {
                message += String(args[i]);
            }
            message += " ";
        }
        message = message.trim();
        return message;
    }
    async logCritical(...args) {
        if (50 < this.logLevel)
            return;
        await call("logger_react", 50, this.convertToString(...args));
    }
    async logError(...args) {
        if (40 < this.logLevel)
            return;
        await call("logger_react", 40, this.convertToString(...args));
    }
    async logWarning(...args) {
        if (30 < this.logLevel)
            return;
        await call("logger_react", 30, this.convertToString(...args));
    }
    async logInfo(...args) {
        if (20 < this.logLevel)
            return;
        await call("logger_react", 20, this.convertToString(...args));
    }
    async logDebug(...args) {
        if (10 < this.logLevel)
            return;
        await call("logger_react", 10, this.convertToString(...args));
    }
    //Do not use! Trace Added for backwards compatibility
    async logTrace(...args) {
        if (0 < this.logLevel)
            return;
        await call("logger_react", 0, this.convertToString(...args));
    }
}
Backend.maxAttempts = 3;

const LogoIcon = () => {
    return window.SP_REACT.createElement("svg", { style: { display: "block" }, width: "1em", height: "1em", viewBox: "0 0 64 64", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        window.SP_REACT.createElement("rect", { fill: "none", width: "64", height: "64" }),
        window.SP_REACT.createElement("path", { fill: "currentColor", "fill-opacity": "0.8", d: "M34,28c0-2.8,2.2-5,5-5l0,0c2.8,0,5,2.2,5,5v30c0,2.8-2.2,5-5,5l0,0c-2.8,0-5-2.2-5-5V28z M20,28\n  c0-2.8,2.2-5,5-5l0,0c2.8,0,5,2.2,5,5v30c0,2.8-2.2,5-5,5l0,0c-2.8,0-5-2.2-5-5V28z" }),
        window.SP_REACT.createElement("path", { fill: "currentColor", d: "M34,26c0,8.3,6.7,15,15,15s15-6.7,15-15s-6.7-15-15-15S34,17.7,34,26z M30,26c0,8.3-6.7,15-15,15C6.7,41,0,34.3,0,26\ns6.7-15,15-15C23.3,11,30,17.7,30,26z M55,44l0.3,0.9c1,2.6,3.1,4.7,5.8,5.8L62,51l-0.9,0.3c-2.6,1-4.7,3.1-5.8,5.8L55,58l-0.3-0.9\nc-1-2.6-3.1-4.7-5.8-5.8L48,51l0.9-0.3c2.6-1,4.7-3.1,5.8-5.8L55,44z M32,2l0.1,0.2c1,2.6,3.1,4.7,5.8,5.8L38,8l-0.2,0.1\nc-2.6,1-4.7,3.1-5.8,5.8L32,14l-0.1-0.2c-1-2.6-3.1-4.7-5.8-5.8L26,8l0.2-0.1c2.6-1,4.7-3.1,5.8-5.8L32,2z M9,44l0.1,0.1\nc0.8,2.2,2.6,4,4.8,4.8L14,49l-0.1,0.1c-2.2,0.8-4,2.6-4.8,4.8L9,54l-0.1-0.1c-0.8-2.2-2.6-4-4.8-4.8L4,49l0.1-0.1\nc2.2-0.8,4-2.6,4.8-4.8L9,44z" }));
};

const LogRouter = ({ backend }) => {
    const [logValue, setLogValue] = SP_REACT.useState();
    const containerStyle = {
        height: "100vh",
        overflowY: "auto",
        overflowX: "auto",
        paddingLeft: "0px",
        paddingRight: "0px",
        paddingTop: "40px",
        paddingBottom: "44px",
        whiteSpace: 'pre',
        fontFamily: "monospace",
        fontSize: "12px",
        lineHeight: "12px"
    };
    const divRef = SP_REACT.useRef(null);
    SP_REACT.useEffect(() => {
        backend.logDebug("LogRouter");
        const getLog = async () => {
            let output = await call("read_logs");
            setLogValue(output);
        };
        setTimeout(() => {
            if (divRef.current) {
                divRef.current.scrollTop = divRef.current.scrollHeight;
            }
        }, 250);
        getLog();
    }, []);
    return (window.SP_REACT.createElement("div", { style: containerStyle, ref: divRef }, logValue));
};

var UIComposition;
(function (UIComposition) {
    UIComposition[UIComposition["Hidden"] = 0] = "Hidden";
    UIComposition[UIComposition["Notification"] = 1] = "Notification";
    UIComposition[UIComposition["Overlay"] = 2] = "Overlay";
    UIComposition[UIComposition["Opaque"] = 3] = "Opaque";
    UIComposition[UIComposition["OverlayKeyboard"] = 4] = "OverlayKeyboard";
})(UIComposition || (UIComposition = {}));
const useUIComposition = DFL.findModuleChild((m) => {
    if (typeof m !== "object")
        return undefined;
    for (let prop in m) {
        if (typeof m[prop] === "function" &&
            m[prop].toString().includes("AddMinimumCompositionStateRequest") &&
            m[prop].toString().includes("ChangeMinimumCompositionStateRequest") &&
            m[prop].toString().includes("RemoveMinimumCompositionStateRequest") &&
            !m[prop].toString().includes("m_mapCompositionStateRequests")) {
            return m[prop];
        }
    }
});
const MicrophoneMute = () => {
    useUIComposition(UIComposition.Notification);
    return (window.SP_REACT.createElement("div", { style: {
            height: "16px",
            width: "16px",
            opacity: 1,
            zIndex: 7002,
            position: "fixed",
            paddingTop: "1px",
            top: 0,
            right: 0
        } },
        window.SP_REACT.createElement("svg", { width: "1em", height: "1em", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            window.SP_REACT.createElement("path", { d: "M9.79961 16.9472L12.0529 14.7005L22.0396 4.70719L20.6263 3.29385L15.9996 7.92049V5.36719C15.9996 4.30632 15.5782 3.28891 14.8281 2.53876C14.0779 1.78861 13.0605 1.36719 11.9996 1.36719C10.9387 1.36719 9.92134 1.78861 9.17121 2.53876C8.42108 3.28891 7.99961 4.30632 7.99961 5.36719V10.7005C8.00108 11.3722 8.17161 12.0326 8.49548 12.621C8.81941 13.2094 9.28621 13.7068 9.85294 14.0672L7.99961 15.8938C7.09908 15.1274 6.43732 14.1186 6.09297 12.9872L3.5663 13.7472C4.0375 15.2929 4.92832 16.6776 6.13964 17.7472L3.29297 20.6272L4.7063 22.0406L9.79961 16.9472Z", fill: "#D4372B" }),
            window.SP_REACT.createElement("path", { d: "M12.2196 17.3338L9.82628 19.7205C10.1031 19.7946 10.3835 19.8547 10.6663 19.9005V22.6738H13.3329V19.9272C14.9772 19.6674 16.5151 18.95 17.7707 17.8572C19.0263 16.7642 19.9489 15.3399 20.4329 13.7472L17.8796 12.9872C17.4997 14.207 16.7519 15.2796 15.7386 16.0577C14.7253 16.8359 13.4962 17.2816 12.2196 17.3338Z", fill: "#D4372B" }))));
};
let micId = -1;
let micSavedVolume = -1;
const BackgroundMicrophoneMute = ({ backend }) => {
    const [visible, setVisible] = SP_REACT.useState(false);
    SP_REACT.useEffect(() => {
        backend.logDebug("MicMute: RegisterForInputChanged");
        const input = new Input([50 /* Button.QUICK_ACCESS_MENU */, 41 /* Button.L4 */]);
        input.onShortcutPressed(onShortcutPressed);
        backend.logDebug("MicMute: RegisterForDeviceVolumeChanged");
        // Mic changes
        SteamClient.System.Audio.RegisterForDeviceVolumeChanged((audioDeviceId, audioType, volume) => {
            if (audioDeviceId === micId && audioType === 0 && volume !== 0) {
                micId = -1;
                micSavedVolume = -1;
                setVisible(false);
                backend.logDebug("MicMute: Changed: audioDeviceId", audioDeviceId, "audioType", audioType, "volume", volume);
            }
        });
        return () => {
            input.offShortcutPressed(onShortcutPressed);
            input.unregister();
        };
    }, []);
    const onShortcutPressed = async () => {
        const enableToggleMicValue = await backend.loadBooleanSetting("mic_qam_l5_toggle");
        if (!enableToggleMicValue) {
            return;
        }
        if (micId === -1 && micSavedVolume === -1) {
            // Mic info
            const devices = await SteamClient.System.Audio.GetDevices();
            micId = devices.activeInputDeviceId;
            devices.vecDevices.forEach(dev => {
                if (dev.id === micId) {
                    micSavedVolume = dev.flInputVolume;
                }
            });
            backend.logDebug("MicMute:", devices);
            backend.logDebug("MicMute: Saved: audioDeviceId", micId, "volume", micSavedVolume);
            // Mute mic
            await SteamClient.System.Audio.SetDeviceVolume(micId, 0, 0);
            setVisible(true);
        }
        // Unmute mic
        else {
            await SteamClient.System.Audio.SetDeviceVolume(micId, 0, micSavedVolume);
        }
    };
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null, visible &&
        window.SP_REACT.createElement(MicrophoneMute, null)));
};

function delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
class ConversationAwarenessVolume {
    constructor() {
        this.savedVolume = -1;
        this.lastSpeaking = null;
    }
    async process(info, backend) {
        const speaking = info?.capabilities?.conversationAwarenessSpeaking?.selected;
        if (speaking == null)
            return;
        if (this.lastSpeaking === speaking)
            return;
        this.lastSpeaking = speaking;
        const devices = await SteamClient.System.Audio.GetDevices();
        const id = devices.activeOutputDeviceId;
        let volume = -1;
        devices.vecDevices.forEach(dev => {
            if (dev.id === id) {
                volume = dev.flOutputVolume;
                backend.logDebug("Output device volume:", dev.flOutputVolume);
            }
        });
        if (volume == -1) {
            backend.logError("Failed to get volume level");
            return;
        }
        if (speaking === true) {
            if (this.savedVolume == -1) {
                let percent = await backend.loadNumberSetting("conversation_awareness_volume") ?? 0;
                if (percent == 0)
                    return;
                //await SteamClient.System.Audio.SetDeviceVolume(id, 1, volume * ((100-percent) * 0.01));
                const targetVolume = volume * ((100 - percent) * 0.01);
                await this.fadeVolume(volume, targetVolume, id, backend);
                this.savedVolume = volume;
            }
        }
        else if (speaking === false) {
            if (this.savedVolume != -1) {
                //await SteamClient.System.Audio.SetDeviceVolume(id, 1, this.savedVolume);
                await this.fadeVolume(volume, this.savedVolume, id, backend);
                this.savedVolume = -1;
            }
        }
    }
    async fadeVolume(from, to, deviceId, backend, steps = 10, delayMs = 25) {
        const stepSize = (to - from) / steps;
        backend.logDebug("New volume:", to, "StepsSize:", stepSize);
        for (let i = 1; i <= steps; i++) {
            const current = from + stepSize * i;
            await SteamClient.System.Audio.SetDeviceVolume(deviceId, 1, current);
            //backend.logDebug(`Step ${i}: Volume ${current.toFixed(3)}`);
            await delay(delayMs);
        }
    }
    reset() {
        this.lastSpeaking = null;
        this.savedVolume = -1;
    }
}

const Content = ({ backend }) => {
    SP_REACT.useEffect(() => {
        backend.logInfo("Index: Starting UI");
        backend.onSocketConnectionChanged(onConnectionChanged);
        backend.onJsonMessageReceived(onJsonMessageReceived);
        const state = backend.getSocketState();
        onConnectionChanged(state);
        return () => {
            backend.offSocketConnectionChanged(onConnectionChanged);
            backend.offJsonMessageReceived(onJsonMessageReceived);
        };
    }, []);
    const onConnectionChanged = (state) => {
        if (state === 1 /* BackendSocketState.OPEN */) {
            setConnectionErrorValue(false);
            setIsButtonDisabledValue(true);
            backend.getAll();
        }
        if (state === -1 /* BackendSocketState.ERROR */) {
            setConnectionErrorValue(true);
            setIsButtonDisabledValue(false);
        }
    };
    const onJsonMessageReceived = (lastJsonMessage) => {
        backend.logDebug("Index: Json message received");
        if (lastJsonMessage === null) {
            return;
        }
        const typedJson = lastJsonMessage;
        if (typedJson?.info != null) {
            setInfoValue(Object.keys(typedJson.info).length === 0 ? undefined : typedJson.info);
        }
        if (typedJson?.defaultbluetooth != null) {
            setDefaultBluetoothValue(Object.keys(typedJson.defaultbluetooth).length === 0 ? undefined : typedJson.defaultbluetooth);
        }
        if (typedJson?.headphones != null) {
            setHeadphonesValue(typedJson.headphones.length === 0 ? [] : typedJson.headphones);
        }
    };
    const [headphonesValue, setHeadphonesValue] = SP_REACT.useState([]);
    const [infoValue, setInfoValue] = SP_REACT.useState();
    const [defaultBluetoothValue, setDefaultBluetoothValue] = SP_REACT.useState();
    const [connectionErrorValue, setConnectionErrorValue] = SP_REACT.useState(false);
    const [isButtonDisabledValue, setIsButtonDisabledValue] = SP_REACT.useState(false);
    const [currentTabRoute, setCurrentTabRoute] = SP_REACT.useState("info");
    return (window.SP_REACT.createElement(window.SP_REACT.Fragment, null,
        window.SP_REACT.createElement("style", null, `
.magicpods-tabs > div > div:first-child::before {
  background: #0D141C;
  box-shadow: none;
  backdrop-filter: none;
}
`),
        window.SP_REACT.createElement("div", { className: "magicpods-tabs", style: { height: "95%", width: "300px", position: "fixed", marginTop: "-12px", overflow: "hidden" } },
            connectionErrorValue &&
                window.SP_REACT.createElement("div", { style: { display: "flex", paddingTop: "12px", paddingLeft: "16px", paddingRight: "16px", alignItems: "center" } },
                    window.SP_REACT.createElement("div", { className: DFL.staticClasses.Text, style: { paddingRight: "8px", width: "100%" } }, t$1("websocket_connection_issue")),
                    window.SP_REACT.createElement(DFL.DialogButton, { disabled: isButtonDisabledValue, style: { height: "28px", width: "40px", minWidth: "40px", padding: "10px 12px" }, onClick: async () => {
                            backend.logDebug("Index: Restarting backend");
                            setIsButtonDisabledValue(true);
                            await call("restart_backend");
                            backend.connect();
                            backend.logInfo("Index: Backend restarted");
                        } },
                        window.SP_REACT.createElement("svg", { style: { display: "block", marginTop: "-4px" }, width: "1em", height: "1em", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M11.0608 4.48844C11.8828 4.38507 12.4653 3.63495 12.3619 2.81299C12.2586 1.99104 11.5084 1.40851 10.6865 1.51188C5.97823 2.10399 2.1833 5.83131 1.58187 10.6572C0.925634 15.9227 4.27647 20.8622 9.41005 22.1733C14.5452 23.4847 19.8439 20.7515 21.7747 15.8084C23.1662 12.2459 22.4971 8.33342 20.2724 5.47532C20.9708 5.34719 21.5 4.7354 21.5 4C21.5 3.17157 20.8284 2.5 20 2.5H16C15.1716 2.5 14.5 3.17157 14.5 4V8C14.5 8.82843 15.1716 9.5 16 9.5C16.8284 9.5 17.5 8.82843 17.5 8V6.84125C19.4093 8.91101 20.0578 11.9584 18.9803 14.7169C17.5981 18.2556 13.8121 20.2012 10.1524 19.2666C6.4911 18.3315 4.08842 14.8028 4.55884 11.0282C4.98961 7.57163 7.70599 4.91034 11.0608 4.48844Z", fill: "currentColor" })))),
            window.SP_REACT.createElement(DFL.Tabs, { activeTab: currentTabRoute, 
                // @ts-ignore
                onShowTab: (tabID) => {
                    setCurrentTabRoute(tabID);
                }, tabs: [
                    {
                        // @ts-ignore
                        title: window.SP_REACT.createElement("svg", { style: { display: "block" }, width: "20", height: "20", viewBox: "0 0 20 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            window.SP_REACT.createElement("path", { d: "M14.9248 8.93341H12.3498V2.93341C12.3498 1.53341 11.5914 1.25008 10.6664 2.30008L9.99977 3.05841L4.3581 9.47508C3.5831 10.3501 3.9081 11.0667 5.07477 11.0667H7.64977V17.0667C7.64977 18.4667 8.4081 18.7501 9.3331 17.7001L9.99977 16.9417L15.6414 10.5251C16.4164 9.65008 16.0914 8.93341 14.9248 8.93341Z", fill: "currentColor" })),
                        content: window.SP_REACT.createElement(TabInfo, { info: infoValue, setInfoValue: setInfoValue, backend: backend }),
                        id: "info",
                    },
                    {
                        // @ts-ignore
                        title: window.SP_REACT.createElement("svg", { style: { display: "block" }, width: "20", height: "20", viewBox: "0 0 20 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            window.SP_REACT.createElement("path", { "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M1.66652 14.9163L1.66667 14.93V15.1167C1.66667 16.8667 3.09167 18.2917 4.84167 18.2917H4.95C6.7 18.2917 8.125 16.8667 8.125 15.1167V13.55C8.125 11.8 6.7 10.375 4.95 10.375H4.84167C4.1186 10.375 3.45102 10.6183 2.91652 11.0272V10.1497C2.88318 8.21634 3.59152 6.40801 4.92485 5.04967C6.24985 3.69967 8.03318 2.95801 9.95818 2.95801C13.8915 2.95801 17.0832 6.15801 17.0832 10.083V11.027C16.5487 10.6182 15.8813 10.375 15.1583 10.375H15.05C13.3 10.375 11.875 11.8 11.875 13.55V15.1167C11.875 16.8667 13.3 18.2917 15.05 18.2917H15.1583C16.9083 18.2917 18.3333 16.8667 18.3333 15.1167V13.55C18.3333 13.5396 18.3333 13.5292 18.3332 13.5188V10.083C18.3332 5.46634 14.5748 1.70801 9.95818 1.70801C7.69985 1.70801 5.59985 2.58301 4.03318 4.17467C2.46652 5.77467 1.62485 7.90801 1.66652 10.1663V14.9163Z", fill: "currentColor" })),
                        content: window.SP_REACT.createElement(TabHeadphones, { defaultBluetooth: defaultBluetoothValue, setDefaultBluetooth: setDefaultBluetoothValue, headphones: headphonesValue, setHeadphones: setHeadphonesValue, backend: backend }),
                        id: "headphones",
                    },
                    {
                        // @ts-ignore
                        title: window.SP_REACT.createElement("svg", { style: { display: "block" }, width: "20", height: "20", viewBox: "0 0 20 20", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            window.SP_REACT.createElement("path", { d: "M15.7834 4.51686L11.4751 2.0252C10.6501 1.5502 9.3584 1.5502 8.5334 2.0252L4.1834 4.53353C2.4584 5.7002 2.3584 5.8752 2.3584 7.73353V12.2585C2.3584 14.1169 2.4584 14.3002 4.21673 15.4835L8.52506 17.9752C8.94173 18.2169 9.47507 18.3335 10.0001 18.3335C10.5251 18.3335 11.0584 18.2169 11.4667 17.9752L15.8167 15.4669C17.5417 14.3002 17.6417 14.1252 17.6417 12.2669V7.73353C17.6417 5.8752 17.5417 5.7002 15.7834 4.51686ZM10.0001 12.7085C8.5084 12.7085 7.29173 11.4919 7.29173 10.0002C7.29173 8.50853 8.5084 7.29186 10.0001 7.29186C11.4917 7.29186 12.7084 8.50853 12.7084 10.0002C12.7084 11.4919 11.4917 12.7085 10.0001 12.7085Z", fill: "currentColor" })),
                        content: window.SP_REACT.createElement(TabSettings, { backend: backend }),
                        id: "settings",
                    }
                    /*
                    ,{
                      // @ts-ignore
                      title: <svg style={{ display: "block" }} width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.7497 5.78366C16.7497 6.23366 16.508 6.64199 16.1247 6.85033L14.6747 7.63366L13.4413 8.29199L10.883 9.67533C10.608 9.82533 10.308 9.90033 9.99968 9.90033C9.69134 9.90033 9.39134 9.82533 9.11634 9.67533L3.87467 6.85033C3.49134 6.64199 3.24967 6.23366 3.24967 5.78366C3.24967 5.33366 3.49134 4.92533 3.87467 4.71699L5.51634 3.83366L6.82467 3.12533L9.11634 1.89199C9.66634 1.59199 10.333 1.59199 10.883 1.89199L16.1247 4.71699C16.508 4.92533 16.7497 5.33366 16.7497 5.78366ZM8.24993 10.6588L3.37493 8.22544C2.99994 8.03378 2.5666 8.05878 2.20827 8.27544C1.84993 8.49211 1.6416 8.87544 1.6416 9.29211V13.9004C1.6416 14.7004 2.08327 15.4171 2.79993 15.7754L7.67493 18.2088C7.8416 18.2921 8.02494 18.3338 8.20827 18.3338C8.42494 18.3338 8.6416 18.2754 8.83327 18.1504C9.1916 17.9338 9.39993 17.5504 9.39993 17.1338V12.5254C9.40827 11.7338 8.9666 11.0171 8.24993 10.6588ZM18.3581 13.9V9.29169C18.3581 8.87502 18.1414 8.49169 17.7914 8.27502C17.4331 8.05002 16.9997 8.03336 16.6247 8.22502L14.7914 9.14169L13.5414 9.76669L11.7497 10.6584C11.0331 11.0167 10.5914 11.7334 10.5914 12.5334V17.1334C10.5914 17.55 10.8081 17.9334 11.1581 18.15C11.3581 18.275 11.5747 18.3334 11.7914 18.3334C11.9747 18.3334 12.1581 18.2917 12.3247 18.2084L17.1997 15.7667C17.9164 15.4084 18.3581 14.6917 18.3581 13.9Z" fill="currentColor"/></svg>,
                      content: <TabDebug backend={backend} />,
                      id: "debug",
                    }
                    */
                ] }))));
};
var index = DFL.definePlugin(() => {
    initI18n();
    let AllowLowBatteryNotification = true;
    const volumeCA = new ConversationAwarenessVolume();
    const onConnectionChanged = (state) => {
        if (state === -1 /* BackendSocketState.ERROR */) {
            toaster.toast({
                icon: window.SP_REACT.createElement(LogoIcon, null),
                title: "MagicPods",
                duration: 15000,
                body: t$1("notif_error_websocket_connection_issue")
            });
        }
    };
    const onJsonMessageReceived = async (json) => {
        backend.logDebug("LowBattNotif: Json message received");
        const typedJson = json;
        if (typedJson?.info == null)
            return;
        if (Object.keys(typedJson.info).length !== 0) {
            await volumeCA.process(typedJson.info, backend);
            const lowBatterySettingValue = await backend.loadNumberSetting("notif_low_battery") ?? 0;
            if (lowBatterySettingValue <= 0)
                return;
            const info = typedJson.info;
            if (info.capabilities.battery == null)
                return;
            let minBattery = 100;
            for (let key of ["single", "left", "right", "case"]) {
                let battery = info.capabilities.battery[key];
                if (battery.status === 2 &&
                    battery.charging === false &&
                    battery.battery !== 0 && // Sometimes headphones send battery 0 and immediately update battery to real value
                    battery.battery < minBattery) {
                    minBattery = battery.battery;
                }
            }
            if (AllowLowBatteryNotification &&
                minBattery <= lowBatterySettingValue) {
                AllowLowBatteryNotification = false;
                backend.logInfo(`LowBattNotif: Showing low battery notification ${minBattery}%`);
                toaster.toast({
                    icon: window.SP_REACT.createElement(LogoIcon, null),
                    title: "MagicPods",
                    body: t$1("notif_low_battery", { battery: minBattery })
                });
            }
        }
        else {
            backend.logInfo("LowBattNotif: Empty info allow low battery notification");
            AllowLowBatteryNotification = true;
            volumeCA.reset();
        }
    };
    const backend = new Backend();
    backend.onSocketConnectionChanged(onConnectionChanged);
    backend.onJsonMessageReceived(onJsonMessageReceived);
    routerHook.addRoute("/magicpods-log", () => (window.SP_REACT.createElement(LogRouter, { backend: backend })));
    routerHook.addGlobalComponent("BackgroundMicrophoneMute", () => (window.SP_REACT.createElement(BackgroundMicrophoneMute, { backend: backend })));
    backend.logInfo("Plugin: Loaded");
    return {
        title: window.SP_REACT.createElement("div", { className: DFL.staticClasses.Title }, "MagicPods"),
        content: window.SP_REACT.createElement(Content, { backend: backend }),
        icon: window.SP_REACT.createElement(LogoIcon, null),
        onDismount() {
            backend.logInfo("Plugin: Dismounting");
            routerHook.removeRoute("/magicpods-log");
            routerHook.removeGlobalComponent("BackgroundMicrophoneMute");
            backend.offSocketConnectionChanged(onConnectionChanged);
            backend.offJsonMessageReceived(onJsonMessageReceived);
            backend.bgAncSwitch.disable();
            backend.player.disable();
            backend.disconnect();
        },
    };
});

export { index as default };
//# sourceMappingURL=index.js.map
