# MagicPods✨ for Steam Deck

A magic plugin for the Decky Loader that allows you to control your AirPods and Beats headphones in a comfortable way.

![](./docs/images/screenshot-1.png)

## 🎨 Features

🔋 Battery level  
⚙️ Noise control  
🔌 Fix headphones disconnects  
🎙️ Hotkey to mute microphone  
🔄 Hotkey to cycle between noise modes  
🎉 New features coming soon

### 🔥 Exclusive to AirPods and Beats

Additional settings — just like on iPhone and Mac:

- Audio is lowered during conversation awareness
- Noise level adjustment in adaptive mode
- Personalized volume
- Noise cancellation with one AirPod
- Press duration adjustment
- Press and hold duration adjustment
- Customization of single and double tap for call control

## 🎧 Headphones supported

| Apple            | Beats                  | Samsung           |
| ---------------- | ---------------------- | ----------------- |
| AirPods 1        | PowerBeats Pro         | Galaxy Buds       |
| AirPods 2        | PowerBeats Pro 2       | Galaxy Buds Plus  |
| AirPods 3        | PowerBeats 3           | Galaxy Buds Live  |
| AirPods 4        | PowerBeats 4           | Galaxy Buds Pro   |
| AirPods 4 (ANC)  | Beats Fit Pro          | Galaxy Buds 2     |
| AirPods Pro      | Beats Studio Buds      | Galaxy Buds 2 Pro |
| AirPods Pro 2    | Beats Studio Buds Plus | Galaxy Buds Fe    |
| AirPods Pro 3    | Beats Studio Pro       | Galaxy Buds 3     |
| AirPods Max      | Beats Solo 3           | Galaxy Buds 3 Pro | 
| AirPods Max 2024 | Beats Solo Pro         |                   |
|                  | Beats Studio 3         |                   |
|                  | Beats X                |                   |
|                  | Beats Flex             |                   |
|                  | Beats Solo Buds        |                   |

## 💾 Installation

### Using the Decky Store

1. Install [Decky Loader](https://github.com/SteamDeckHomebrew/decky-loader/tree/main?tab=readme-ov-file#-installation)
2. Switch to steam game mode
3. Press <img src="./docs/images/dark/qam.svg#gh-light-mode-only" height=16><img src="./docs/images/light/qam.svg#gh-dark-mode-only" height=16>
4. Go to the tab <img src="./docs/images/dark/plug.svg#gh-light-mode-only" height=16><img src="./docs/images/light/plug.svg#gh-dark-mode-only" height=16>
5. In the upper right corner, click <img src="./docs/images/dark/store.svg#gh-light-mode-only" height=16><img src="./docs/images/light/store.svg#gh-dark-mode-only" height=16>
6. Find `MagicPods` in the plugin list or search for it
7. Press the `Install` button

### Using the Decky developer mode

1. Install [Decky Loader](https://github.com/SteamDeckHomebrew/decky-loader/tree/main?tab=readme-ov-file#-installation)
2. Switch to steam game mode
3. Press <img src="./docs/images/dark/qam.svg#gh-light-mode-only" height=16><img src="./docs/images/light/qam.svg#gh-dark-mode-only" height=16>
4. Go to the tab <img src="./docs/images/dark/plug.svg#gh-light-mode-only" height=16><img src="./docs/images/light/plug.svg#gh-dark-mode-only" height=16>
5. In the upper right corner, click <img src="./docs/images/dark/gear.svg#gh-light-mode-only" height=16><img src="./docs/images/light/gear.svg#gh-dark-mode-only" height=16>
6. On the General tab, enable developer mode
7. Go to the Developer tab
8. Type in the URL `https://magicpods.app/plugin`
9. Press the Install button

## 🚀 Getting started

Now that you have MagicPods, press <img src="./docs/images/dark/qam.svg#gh-light-mode-only" height=16><img src="./docs/images/light/qam.svg#gh-dark-mode-only" height=16> and go to <img src="./docs/images/dark/plug.svg#gh-light-mode-only" height=16><img src="./docs/images/light/plug.svg#gh-dark-mode-only" height=16> and select <img src="./docs/images/dark/mp.svg#gh-light-mode-only" height=16><img src="./docs/images/light/mp.svg#gh-dark-mode-only" height=16> MagicPods in the installed plugins list.

<img src="./docs/images/dark/mp-charge.svg#gh-light-mode-only" height=16><img src="./docs/images/light/mp-charge.svg#gh-dark-mode-only" height=16> displays information about the current charge level and additional features, if supported by the headphones.  
<img src="./docs/images/dark/mp-hd.svg#gh-light-mode-only" height=16><img src="./docs/images/light/mp-hd.svg#gh-dark-mode-only" height=16> shows headphones supported by MagicPods, here you can connect/disconnect headphones and control Bluetooth.  
<img src="./docs/images/dark/mp-sett.svg#gh-light-mode-only" height=16><img src="./docs/images/light/mp-sett.svg#gh-dark-mode-only" height=16> Contains additional features, settings, and other useful information.  

All you need to do is select your headphones and connect them, and the charge level and additional features will appear on the <img src="./docs/images/dark/mp-charge.svg#gh-light-mode-only" height=16><img src="./docs/images/light/mp-charge.svg#gh-dark-mode-only" height=16> tab

## 🌐 Become a Translator

Go to the [MagicPods-SteamDeck](https://weblate.magicpods.app/engage/magicpods-steamdeck/) project. Register (don’t forget to check your Spam folder — the confirmation email might end up there), or suggest translations without creating an account.

Use the shortest phrases and abbreviations possible — the Steam interface is very compact. Refer to the screenshots attached to each phrase.

## 🧪 Ideas and bugs

In the [Discord](https://discord.com/invite/UyY4PY768V) community you can suggest an idea or report a problem.

## 🩼 Known issues

- Hotkeys stop working after opening the controller settings in the Steam menu — the solution is to restart the plugin.
- When managing Bluetooth through the plugin, changes are not visible in the Steam interface — the current Bluetooth status is shown only in MagicPods.

## 💰 Donate

[Support the project here](https://magicpods.app/donate/) — every bit helps ❤️

## 💖 Developers

Developed by [Aleksandr Maslov](https://github.com/steam3d/) and [Andrey Litvintsev](https://github.com/andreylitvintsev)